/*
 * Copyright (C) 2020 ActiveJ LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.activej.test.rules;

import org.junit.runners.model.Statement;

public final class LambdaStatement extends Statement {
	public static final Statement EMPTY = new LambdaStatement(() -> {});

	private final ThrowingRunnable body;

	public LambdaStatement(ThrowingRunnable body) {
		this.body = body;
	}

	@Override
	public void evaluate() throws Throwable {
		body.run();
	}

	@FunctionalInterface
	public interface ThrowingRunnable {
		void run() throws Throwable;
	}
}
