/*
 * Decompiled with CFR 0.152.
 */
package io.activej.uikernel;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.activej.uikernel.AbstractRecord;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class UpdateResponse<K, R extends AbstractRecord<K>> {
    private final List<R> changes;
    private final Map<K, Map<String, List<String>>> errors;

    private UpdateResponse(@NotNull List<R> changes, @NotNull Map<K, Map<String, List<String>>> errors) {
        this.changes = changes;
        this.errors = errors;
    }

    public static <K, R extends AbstractRecord<K>> UpdateResponse<K, R> of(List<R> changes) {
        return new UpdateResponse(changes, Collections.emptyMap());
    }

    public static <K, R extends AbstractRecord<K>> UpdateResponse<K, R> of(List<R> changes, Map<K, Map<String, List<String>>> errors) {
        return new UpdateResponse<K, R>(changes, errors);
    }

    String toJson(Gson gson, Class<R> type, Class<K> idType) {
        JsonObject result = new JsonObject();
        JsonArray change = new JsonArray();
        for (AbstractRecord record : this.changes) {
            JsonArray arr = new JsonArray();
            arr.add(gson.toJsonTree(record.getId(), idType));
            arr.add(gson.toJsonTree((Object)record, type));
            change.add((JsonElement)arr);
        }
        result.add("changes", (JsonElement)change);
        JsonArray errs = new JsonArray();
        for (Map.Entry<K, Map<String, List<String>>> entry : this.errors.entrySet()) {
            JsonArray arr = new JsonArray();
            arr.add(gson.toJsonTree(entry.getKey(), idType));
            arr.add(gson.toJsonTree(entry.getValue()));
            errs.add((JsonElement)arr);
        }
        result.add("errors", (JsonElement)errs);
        return gson.toJson((JsonElement)result);
    }
}

