/*
 * Decompiled with CFR 0.152.
 */
package io.activej.uikernel;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import io.activej.common.exception.MalformedDataException;
import io.activej.uikernel.AbstractRecord;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

class Utils {
    Utils() {
    }

    static <K, R extends AbstractRecord<K>> List<R> deserializeUpdateRequest(Gson gson, String json, Class<R> type, Class<K> idType) throws MalformedDataException {
        ArrayList<AbstractRecord> result = new ArrayList<AbstractRecord>();
        JsonArray root = Utils.fromJson(gson, json, JsonArray.class);
        for (JsonElement element : root) {
            JsonArray arr = Utils.fromJson(gson, element, JsonArray.class);
            K id = Utils.fromJson(gson, arr.get(0), idType);
            AbstractRecord obj = (AbstractRecord)Utils.fromJson(gson, arr.get(1), type);
            obj.setId(id);
            result.add(obj);
        }
        return result;
    }

    static <T> T fromJson(Gson gson, String json, Type typeOfT) throws MalformedDataException {
        try {
            return (T)gson.fromJson(json, typeOfT);
        }
        catch (JsonSyntaxException e) {
            throw new MalformedDataException("Failed to read from JSON", (Throwable)e);
        }
    }

    static <T> T fromJson(Gson gson, String json, Class<T> typeOfT) throws MalformedDataException {
        try {
            return (T)gson.fromJson(json, typeOfT);
        }
        catch (JsonSyntaxException e) {
            throw new MalformedDataException("Failed to read from JSON", (Throwable)e);
        }
    }

    static <T> T fromJson(Gson gson, JsonElement json, Type typeOfT) throws MalformedDataException {
        try {
            return (T)gson.fromJson(json, typeOfT);
        }
        catch (JsonSyntaxException e) {
            throw new MalformedDataException("Failed to read from JSON", (Throwable)e);
        }
    }

    static <T> T fromJson(Gson gson, JsonElement json, Class<T> typeOfT) throws MalformedDataException {
        try {
            return (T)gson.fromJson(json, typeOfT);
        }
        catch (JsonSyntaxException e) {
            throw new MalformedDataException("Failed to read from JSON", (Throwable)e);
        }
    }
}

