/*
 * Decompiled with CFR 0.152.
 */
package io.adminshell.aas.v3.dataformat.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.adminshell.aas.v3.dataformat.DeserializationException;
import io.adminshell.aas.v3.dataformat.Deserializer;
import io.adminshell.aas.v3.dataformat.core.ReflectionHelper;
import io.adminshell.aas.v3.dataformat.core.deserialization.EmbeddedDataSpecificationDeserializer;
import io.adminshell.aas.v3.dataformat.core.deserialization.EnumDeserializer;
import io.adminshell.aas.v3.dataformat.json.ReflectionAnnotationIntrospector;
import io.adminshell.aas.v3.dataformat.json.modeltype.ModelTypeProcessor;
import io.adminshell.aas.v3.model.AssetAdministrationShellEnvironment;
import io.adminshell.aas.v3.model.EmbeddedDataSpecification;
import java.util.Map;

public class JsonDeserializer
implements Deserializer {
    protected JsonMapper mapper;
    protected SimpleAbstractTypeResolver typeResolver;
    protected static Map<Class<?>, com.fasterxml.jackson.databind.JsonDeserializer> customDeserializers = Map.of(EmbeddedDataSpecification.class, new EmbeddedDataSpecificationDeserializer());

    public JsonDeserializer() {
        this.initTypeResolver();
        this.buildMapper();
    }

    protected void buildMapper() {
        this.mapper = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).annotationIntrospector((AnnotationIntrospector)new ReflectionAnnotationIntrospector())).addModule((Module)this.buildEnumModule())).addModule((Module)this.buildImplementationModule())).addModule((Module)this.buildCustomDeserializerModule())).build();
        ReflectionHelper.JSON_MIXINS.entrySet().forEach(x -> this.mapper.addMixIn((Class)x.getKey(), (Class)x.getValue()));
    }

    protected SimpleModule buildCustomDeserializerModule() {
        SimpleModule module = new SimpleModule();
        customDeserializers.forEach((arg_0, arg_1) -> ((SimpleModule)module).addDeserializer(arg_0, arg_1));
        return module;
    }

    private void initTypeResolver() {
        this.typeResolver = new SimpleAbstractTypeResolver();
        ReflectionHelper.DEFAULT_IMPLEMENTATIONS.stream().filter(x -> !customDeserializers.containsKey(x.getInterfaceType())).forEach(x -> this.typeResolver.addMapping(x.getInterfaceType(), x.getImplementationType()));
    }

    protected SimpleModule buildEnumModule() {
        SimpleModule module = new SimpleModule();
        ReflectionHelper.ENUMS.forEach(x -> module.addDeserializer(x, (com.fasterxml.jackson.databind.JsonDeserializer)new EnumDeserializer(x)));
        return module;
    }

    protected SimpleModule buildImplementationModule() {
        SimpleModule module = new SimpleModule();
        module.setAbstractTypes(this.typeResolver);
        return module;
    }

    public AssetAdministrationShellEnvironment read(String value) throws DeserializationException {
        try {
            return (AssetAdministrationShellEnvironment)this.mapper.treeToValue((TreeNode)ModelTypeProcessor.preprocess(value), AssetAdministrationShellEnvironment.class);
        }
        catch (JsonProcessingException ex) {
            throw new DeserializationException("error deserializing AssetAdministrationShellEnvironment", (Throwable)ex);
        }
    }

    public <T> void useImplementation(Class<T> aasInterface, Class<? extends T> implementation) {
        this.typeResolver.addMapping(aasInterface, implementation);
        this.buildMapper();
    }
}

