/*
 * Decompiled with CFR 0.152.
 */
package io.adminshell.aas.v3.dataformat.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.SpecVersionDetector;
import com.networknt.schema.ValidationMessage;
import io.adminshell.aas.v3.dataformat.SchemaValidator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonSchemaValidator
implements SchemaValidator {
    private static final String SCHEMA = "/aas.json";
    private final ObjectMapper mapper = new ObjectMapper();

    public Set<String> validateSchema(String serialized) {
        try {
            return this.validateSchema(serialized, this.loadDefaultSchema());
        }
        catch (IOException | URISyntaxException e) {
            return Set.of(e.getMessage());
        }
    }

    public Set<String> validateSchema(String serialized, String serializedSchema) {
        try {
            JsonNode schemaRootNode = this.mapper.readTree(serializedSchema);
            JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersionDetector.detect((JsonNode)schemaRootNode));
            JsonSchema schema = factory.getSchema(schemaRootNode);
            JsonNode node = this.mapper.readTree(serialized);
            Set validationMessages = schema.validate(node);
            return this.generalizeValidationMessagesAsStringSet(validationMessages);
        }
        catch (JsonProcessingException e) {
            return Set.of(e.getMessage());
        }
    }

    private String loadDefaultSchema() throws IOException, URISyntaxException {
        return new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(SCHEMA))).lines().collect(Collectors.joining("\n"));
    }

    private Set<String> generalizeValidationMessagesAsStringSet(Set<ValidationMessage> messages) {
        return messages.stream().map(ValidationMessage::getMessage).collect(Collectors.toSet());
    }
}

