/*
 * Decompiled with CFR 0.152.
 */
package io.adminshell.aas.v3.dataformat.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.adminshell.aas.v3.dataformat.SerializationException;
import io.adminshell.aas.v3.dataformat.Serializer;
import io.adminshell.aas.v3.dataformat.core.ReflectionHelper;
import io.adminshell.aas.v3.dataformat.core.serialization.EmbeddedDataSpecificationSerializer;
import io.adminshell.aas.v3.dataformat.core.serialization.EnumSerializer;
import io.adminshell.aas.v3.dataformat.json.ReflectionAnnotationIntrospector;
import io.adminshell.aas.v3.dataformat.json.modeltype.ModelTypeProcessor;
import io.adminshell.aas.v3.model.AssetAdministrationShellEnvironment;
import io.adminshell.aas.v3.model.EmbeddedDataSpecification;

public class JsonSerializer
implements Serializer {
    protected JsonMapper mapper;

    public JsonSerializer() {
        this.buildMapper();
    }

    protected void buildMapper() {
        this.mapper = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY})).serializationInclusion(JsonInclude.Include.NON_NULL)).addModule((Module)this.buildEnumModule())).addModule((Module)this.buildCustomSerializerModule())).annotationIntrospector((AnnotationIntrospector)new ReflectionAnnotationIntrospector())).build();
        ReflectionHelper.JSON_MIXINS.entrySet().forEach(x -> this.mapper.addMixIn((Class)x.getKey(), (Class)x.getValue()));
    }

    protected SimpleModule buildCustomSerializerModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(EmbeddedDataSpecification.class, (com.fasterxml.jackson.databind.JsonSerializer)new EmbeddedDataSpecificationSerializer());
        return module;
    }

    protected SimpleModule buildEnumModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Enum.class, (com.fasterxml.jackson.databind.JsonSerializer)new EnumSerializer());
        return module;
    }

    public String write(AssetAdministrationShellEnvironment aasEnvironment) throws SerializationException {
        try {
            return this.mapper.writeValueAsString((Object)ModelTypeProcessor.postprocess(this.mapper.valueToTree((Object)aasEnvironment)));
        }
        catch (JsonProcessingException ex) {
            throw new SerializationException("error serializing AssetAdministrationShellEnvironment", (Throwable)ex);
        }
    }
}

