/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.stream.Collectors;
import lombok.Generated;

public final class AdobeClientCredentials {
    private final String orgId;
    private final String technicalAccountId;
    private final String apiKey;
    private final String clientSecret;
    private final PrivateKey privateKey;

    public static PrivateKey getKeyFromPem(String pem) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        try (BufferedReader pemReader = new BufferedReader(new StringReader(pem));){
            PrivateKey privateKey = AdobeClientCredentials.getKeyFromPem(pemReader);
            return privateKey;
        }
    }

    public static PrivateKey getKeyFromPem(BufferedReader pemReader) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] encodedKey = AdobeClientCredentials.convertPemToDer(pemReader);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(encodedKey);
        return keyFactory.generatePrivate(ks);
    }

    private static byte[] convertPemToDer(BufferedReader reader) {
        String base64 = reader.lines().filter(line -> !line.startsWith("-----BEGIN") && !line.startsWith("-----END")).collect(Collectors.joining());
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(base64);
    }

    @Generated
    public AdobeClientCredentials(String orgId, String technicalAccountId, String apiKey, String clientSecret, PrivateKey privateKey) {
        this.orgId = orgId;
        this.technicalAccountId = technicalAccountId;
        this.apiKey = apiKey;
        this.clientSecret = clientSecret;
        this.privateKey = privateKey;
    }

    @Generated
    public String getOrgId() {
        return this.orgId;
    }

    @Generated
    public String getTechnicalAccountId() {
        return this.technicalAccountId;
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdobeClientCredentials)) {
            return false;
        }
        AdobeClientCredentials other = (AdobeClientCredentials)o;
        String this$orgId = this.getOrgId();
        String other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId)) {
            return false;
        }
        String this$technicalAccountId = this.getTechnicalAccountId();
        String other$technicalAccountId = other.getTechnicalAccountId();
        if (this$technicalAccountId == null ? other$technicalAccountId != null : !this$technicalAccountId.equals(other$technicalAccountId)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        PrivateKey this$privateKey = this.getPrivateKey();
        PrivateKey other$privateKey = other.getPrivateKey();
        return !(this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
        String $technicalAccountId = this.getTechnicalAccountId();
        result = result * 59 + ($technicalAccountId == null ? 43 : $technicalAccountId.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        PrivateKey $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AdobeClientCredentials(orgId=" + this.getOrgId() + ", technicalAccountId=" + this.getTechnicalAccountId() + ", apiKey=" + this.getApiKey() + ", clientSecret=" + this.getClientSecret() + ", privateKey=" + this.getPrivateKey() + ")";
    }
}

