/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.adobe.cloudmanager.swagger.invoker.ApiException;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;

public class CloudManagerApiException
extends Exception {
    private static final String DEFAULT_REASON = "Unknown";
    private final String message;

    public CloudManagerApiException(ErrorType type, String baseUrl, String apiPath, ApiException cause) {
        super(cause);
        String errorMessage;
        ProblemPayload problemBody = CloudManagerApiException.getProblemBody(cause);
        ErrorPayload errorBody = CloudManagerApiException.getErrorBody(cause);
        StringBuilder errorBuilder = new StringBuilder();
        errorBuilder.append(baseUrl).append(apiPath).append(' ').append(String.format("(%s %s)", cause.getCode(), CloudManagerApiException.getReason(cause)));
        if (problemBody != null) {
            String errorMessage2 = String.join((CharSequence)", ", problemBody.errors);
            if ("http://ns.adobe.com/adobecloud/validation-exception".equals(problemBody.type)) {
                errorBuilder.append(" - Validation Error(s): ").append(errorMessage2);
            }
        } else if (errorBody != null && (errorMessage = errorBody.errorMessage) != null) {
            errorBuilder.append(" - Detail: ").append(errorMessage);
            String errorCode = errorBody.errorCode;
            if (errorCode != null) {
                errorBuilder.append(" (Code: ").append(errorCode).append(")");
            }
        }
        this.message = String.format(type.message, errorBuilder.toString());
    }

    public CloudManagerApiException(ErrorType type, String ... vars) {
        this.message = String.format(type.message, vars);
    }

    private static ProblemPayload getProblemBody(ApiException cause) {
        String contentType = CloudManagerApiException.getHeader(cause, "Content-Type", null);
        if (StringUtils.equals((CharSequence)contentType, (CharSequence)"application/problem+json")) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return (ProblemPayload)objectMapper.readValue(cause.getResponseBody(), ProblemPayload.class);
            }
            catch (JsonProcessingException e) {
                return null;
            }
        }
        return null;
    }

    private static ErrorPayload getErrorBody(ApiException cause) {
        MediaType parsed;
        String contentType = CloudManagerApiException.getHeader(cause, "Content-Type", null);
        if (contentType != null && MediaType.APPLICATION_JSON_TYPE.isCompatible(parsed = MediaType.valueOf((String)contentType))) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return (ErrorPayload)objectMapper.readValue(cause.getResponseBody(), ErrorPayload.class);
            }
            catch (JsonProcessingException e) {
                return null;
            }
        }
        return null;
    }

    private static String getReason(ApiException cause) {
        return CloudManagerApiException.getHeader(cause, "x-cmapi-reason", DEFAULT_REASON);
    }

    private static String getHeader(ApiException cause, String headerName, String defaultValue) {
        if (cause == null) {
            return defaultValue;
        }
        List<String> header = cause.getResponseHeaders().get(headerName.toLowerCase());
        if (header == null || header.isEmpty()) {
            return defaultValue;
        }
        return header.get(0);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    private static class ErrorPayload {
        private String errorCode;
        private String errorMessage;

        private ErrorPayload() {
        }

        @JsonProperty(value="error_code")
        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @JsonProperty(value="message")
        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    private static class ProblemPayload {
        private String type;
        private String[] errors;

        private ProblemPayload() {
        }

        @JsonProperty(value="type")
        public void setErrorCode(String type) {
            this.type = type;
        }

        @JsonProperty(value="errors")
        public void setErrorMessage(String[] errors) {
            this.errors = errors;
        }
    }

    public static enum ErrorType {
        LIST_PROGRAMS("Cannot retrieve programs: %s"),
        GET_PROGRAM("Cannot retrieve program: %s"),
        LIST_PIPELINES("Cannot retrieve pipelines: %s"),
        FIND_PROGRAM("Could not find program %s"),
        FIND_PIPELINES("Could not find pipelines for program %s"),
        FIND_PIPELINE_START("Cannot start execution. Pipeline %s does not exist in program %s."),
        FIND_PIPELINE("Pipeline %s does not exist in program %s."),
        PIPELINE_START("Cannot create execution: %s"),
        PIPELINE_START_RUNNING("Cannot create execution. Pipeline already running."),
        GET_EXECUTION("Cannot get execution: %s"),
        FIND_STEP_STATE("Cannot find step state for action %s on execution %s."),
        GET_METRICS("Cannot get metrics: %s."),
        FIND_CURRENT_STEP("Cannot find a current step for pipeline %s."),
        FIND_CANCEL_LINK("Cannot find a cancel link for the current step (%s). Step may not be cancellable."),
        FIND_ADVANCE_LINK("Cannot find an advance link for the current step (%s)."),
        CANCEL_EXECUTION("Cannot cancel execution: %s"),
        ADVANCE_EXECUTION("Cannot advance execution: %s"),
        FIND_WAITING_STEP("Cannot find a waiting step for pipeline %s."),
        FIND_ENVIRONMENTS("Could not find environments for program %s."),
        FIND_ENVIRONMENT("Could not find environment %s for program %s."),
        RETRIEVE_ENVIRONMENTS("Could not find environments: %s."),
        DELETE_PIPELINE("Cannot delete pipeline: %s"),
        GET_LOGS("Cannot get logs: %s"),
        NO_LOG_REDIRECT("Log %s did not contain a redirect. Was %s."),
        LOG_DOWNLOAD("Could not download %s to %s (%s)."),
        LOG_UNZIP("Could not unzip %s to %s."),
        LOG_INITIAL_SIZE("Could not get initial size of %s"),
        FIND_LOG("Log not found: %s (%s %s)"),
        TAIL_LOG("Cannot tail log: %s (%s %s)"),
        FIND_TAIL_LOGS("No logs for tailing available in %s for program %s"),
        FIND_LOGS("No logs available in %s for program %s"),
        NO_BUILD_PHASE("Pipeline %s does not appear to have a build phase."),
        NO_DEVELOPER_CONSOLE("Environment %s does not appear to support Developer Console."),
        FIND_VARIABLES_LINK_ENVIRONMENT("Could not find variables link for environment %s for program %s."),
        FIND_LOGS_LINK_ENVIRONMENT("Could not find logs link for environment %s for program %s."),
        FIND_VARIABLES_LINK_PIPELINE("Could not find variables link for pipeline %s for program %s."),
        FIND_LOGS_LINK_EXECUTION("Could not find logs link for action %s."),
        GET_VARIABLES("Cannot get variables: %s"),
        SET_VARIABLES("Cannot set variables: %s"),
        DELETE_PROGRAM("Cannot delete program: %s"),
        DELETE_ENVIRONMENT("Cannot delete environment: %s"),
        UPDATE_PIPELINE("Cannot update pipeline: %s"),
        GENERATE_BODY("Unable to generate request body: %s");

        private final String message;

        private ErrorType(String message) {
            this.message = message;
        }
    }
}

