/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.impl;

import io.adobe.cloudmanager.CloudManagerApi;
import io.adobe.cloudmanager.CloudManagerApiException;
import io.adobe.cloudmanager.PipelineUpdate;
import io.adobe.cloudmanager.impl.ConfiguredApiClient;
import io.adobe.cloudmanager.model.EmbeddedProgram;
import io.adobe.cloudmanager.model.EnvironmentLog;
import io.adobe.cloudmanager.model.Variable;
import io.adobe.cloudmanager.swagger.invoker.ApiClient;
import io.adobe.cloudmanager.swagger.invoker.ApiException;
import io.adobe.cloudmanager.swagger.invoker.Pair;
import io.adobe.cloudmanager.swagger.model.Environment;
import io.adobe.cloudmanager.swagger.model.EnvironmentList;
import io.adobe.cloudmanager.swagger.model.EnvironmentLogs;
import io.adobe.cloudmanager.swagger.model.HalLink;
import io.adobe.cloudmanager.swagger.model.Pipeline;
import io.adobe.cloudmanager.swagger.model.PipelineExecution;
import io.adobe.cloudmanager.swagger.model.PipelineExecutionEmbedded;
import io.adobe.cloudmanager.swagger.model.PipelineExecutionStepState;
import io.adobe.cloudmanager.swagger.model.PipelineList;
import io.adobe.cloudmanager.swagger.model.PipelinePhase;
import io.adobe.cloudmanager.swagger.model.PipelineStepMetrics;
import io.adobe.cloudmanager.swagger.model.Program;
import io.adobe.cloudmanager.swagger.model.ProgramList;
import io.adobe.cloudmanager.swagger.model.Redirect;
import io.adobe.cloudmanager.swagger.model.VariableList;
import io.adobe.cloudmanager.util.Predicates;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;

public class CloudManagerApiImpl
implements CloudManagerApi {
    private final ApiClient apiClient = new ConfiguredApiClient();
    private final String orgId;
    private final String apiKey;
    private final String accessToken;
    private final String baseUrl;

    public CloudManagerApiImpl(String orgId, String apiKey, String accessToken) {
        this(orgId, apiKey, accessToken, null);
    }

    public CloudManagerApiImpl(String orgId, String apiKey, String accessToken, String baseUrl) {
        this.orgId = orgId;
        this.apiKey = apiKey;
        this.accessToken = accessToken;
        if (baseUrl != null) {
            this.baseUrl = baseUrl;
            this.apiClient.setBasePath(baseUrl);
        } else {
            this.baseUrl = this.apiClient.getBasePath();
        }
    }

    private static String processTemplate(String path, Map<String, String> values) {
        return new StringSubstitutor(values, "{", "}").replace(path);
    }

    @Override
    public List<EmbeddedProgram> listPrograms() throws CloudManagerApiException {
        ProgramList programList = null;
        try {
            programList = this.get("/api/programs", new GenericType<ProgramList>(){});
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.LIST_PROGRAMS, this.baseUrl, "/api/programs", e);
        }
        return programList.getEmbedded() == null ? Collections.emptyList() : programList.getEmbedded().getPrograms().stream().map(p -> new EmbeddedProgram((io.adobe.cloudmanager.swagger.model.EmbeddedProgram)p, this)).collect(Collectors.toList());
    }

    @Override
    public List<io.adobe.cloudmanager.model.Pipeline> listPipelines(String programId) throws CloudManagerApiException {
        return this.listPipelines(programId, p -> true);
    }

    @Override
    public List<io.adobe.cloudmanager.model.Pipeline> listPipelines(String programId, Predicate<io.adobe.cloudmanager.model.Pipeline> predicate) throws CloudManagerApiException {
        PipelineList pipelineList;
        EmbeddedProgram embeddedProgram = this.listPrograms().stream().filter(p -> programId.equals(p.getId())).findFirst().orElseThrow(() -> new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_PROGRAM, programId));
        Program program = this.getProgram(embeddedProgram.getSelfLink());
        String pipelinesHref = program.getLinks().getHttpnsAdobeComadobecloudrelpipelines().getHref();
        try {
            pipelineList = this.get(pipelinesHref, new GenericType<PipelineList>(){});
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.LIST_PIPELINES, this.baseUrl, pipelinesHref, e);
        }
        if (pipelineList == null || pipelineList.getEmbedded() == null || pipelineList.getEmbedded().getPipelines() == null) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_PIPELINES, programId);
        }
        return pipelineList.getEmbedded().getPipelines().stream().map(p -> new io.adobe.cloudmanager.model.Pipeline((Pipeline)p, this)).filter(predicate).collect(Collectors.toList());
    }

    @Override
    public io.adobe.cloudmanager.model.PipelineExecution startExecution(String programId, String pipelineId) throws CloudManagerApiException {
        io.adobe.cloudmanager.model.Pipeline pipeline = this.getPipeline(programId, pipelineId, CloudManagerApiException.ErrorType.FIND_PIPELINE_START);
        return this.startExecution(pipeline);
    }

    @Override
    public io.adobe.cloudmanager.model.PipelineExecution startExecution(io.adobe.cloudmanager.model.Pipeline pipeline) throws CloudManagerApiException {
        String executionHref = pipeline.getLinks().getHttpnsAdobeComadobecloudrelexecution().getHref();
        PipelineExecution execution = null;
        try {
            execution = this.put(executionHref, new GenericType<PipelineExecution>(){});
        }
        catch (ApiException e) {
            if (412 == e.getCode()) {
                throw new CloudManagerApiException(CloudManagerApiException.ErrorType.PIPELINE_START_RUNNING, new String[0]);
            }
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.PIPELINE_START, this.baseUrl, executionHref, e);
        }
        return new io.adobe.cloudmanager.model.PipelineExecution(execution, this);
    }

    @Override
    public io.adobe.cloudmanager.model.Pipeline updatePipeline(String programId, String pipelineId, PipelineUpdate updates) throws CloudManagerApiException {
        io.adobe.cloudmanager.model.Pipeline original = this.getPipeline(programId, pipelineId);
        return this.updatePipeline(original, updates);
    }

    @Override
    public io.adobe.cloudmanager.model.Pipeline updatePipeline(io.adobe.cloudmanager.model.Pipeline original, PipelineUpdate updates) throws CloudManagerApiException {
        Pipeline toUpdate = new Pipeline();
        PipelinePhase buildPhase = original.getPhases().stream().filter(p -> PipelinePhase.TypeEnum.BUILD == p.getType()).findFirst().orElseThrow(() -> new CloudManagerApiException(CloudManagerApiException.ErrorType.NO_BUILD_PHASE, original.getId()));
        if (updates.getBranch() != null) {
            buildPhase.setBranch(updates.getBranch());
        }
        if (updates.getRepositoryId() != null) {
            buildPhase.setRepositoryId(updates.getRepositoryId());
        }
        toUpdate.getPhases().add(buildPhase);
        String pipelinePath = original.getLinks().getSelf().getHref();
        try {
            Pipeline result = this.patch(pipelinePath, toUpdate, new GenericType<Pipeline>(){});
            return new io.adobe.cloudmanager.model.Pipeline(result, this);
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.UPDATE_PIPELINE, this.baseUrl, pipelinePath, e);
        }
    }

    @Override
    public List<Variable> getEnvironmentVariables(String programId, String environmentId) throws CloudManagerApiException {
        return this.getEnvironmentVariables(this.getEnvironment(programId, environmentId));
    }

    @Override
    public List<Variable> getEnvironmentVariables(io.adobe.cloudmanager.model.Environment environment) throws CloudManagerApiException {
        HalLink variableLink = environment.getLinks().getHttpnsAdobeComadobecloudrelvariables();
        if (variableLink == null) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_VARIABLES_LINK_ENVIRONMENT, environment.getId(), environment.getProgramId());
        }
        return this.getVariables(variableLink);
    }

    @Override
    public List<Variable> setEnvironmentVariables(String programId, String environmentId, Variable ... variables) throws CloudManagerApiException {
        return this.setEnvironmentVariables(this.getEnvironment(programId, environmentId), variables);
    }

    @Override
    public List<Variable> setEnvironmentVariables(io.adobe.cloudmanager.model.Environment environment, Variable ... variables) throws CloudManagerApiException {
        HalLink variableLInk = environment.getLinks().getHttpnsAdobeComadobecloudrelvariables();
        if (variableLInk == null) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_VARIABLES_LINK_ENVIRONMENT, environment.getId(), environment.getProgramId());
        }
        return this.setVariables(variableLInk, variables);
    }

    @Override
    public List<Variable> getPipelineVariables(String programId, String pipelineId) throws CloudManagerApiException {
        return this.getPipelineVariables(this.getPipeline(programId, pipelineId));
    }

    @Override
    public List<Variable> getPipelineVariables(io.adobe.cloudmanager.model.Pipeline pipeline) throws CloudManagerApiException {
        HalLink variableLink = pipeline.getLinks().getHttpnsAdobeComadobecloudrelvariables();
        if (variableLink == null) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_VARIABLES_LINK_PIPELINE, pipeline.getId(), pipeline.getProgramId());
        }
        return this.getVariables(variableLink);
    }

    @Override
    public List<Variable> setPipelineVariables(String programId, String pipelineId, Variable ... variables) throws CloudManagerApiException {
        return this.setPipelineVariables(this.getPipeline(programId, pipelineId), variables);
    }

    @Override
    public List<Variable> setPipelineVariables(io.adobe.cloudmanager.model.Pipeline pipeline, Variable ... variables) throws CloudManagerApiException {
        HalLink variableLink = pipeline.getLinks().getHttpnsAdobeComadobecloudrelvariables();
        if (variableLink == null) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_VARIABLES_LINK_PIPELINE, pipeline.getId(), pipeline.getProgramId());
        }
        return this.setVariables(variableLink, variables);
    }

    @Override
    public io.adobe.cloudmanager.model.PipelineExecution getCurrentExecution(String programId, String pipelineId) throws CloudManagerApiException {
        io.adobe.cloudmanager.model.Pipeline pipeline = this.getPipeline(programId, pipelineId);
        String executionHref = pipeline.getLinks().getHttpnsAdobeComadobecloudrelexecution().getHref();
        try {
            PipelineExecution execution = this.get(executionHref, new GenericType<PipelineExecution>(){});
            return new io.adobe.cloudmanager.model.PipelineExecution(execution, this);
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.GET_EXECUTION, this.baseUrl, executionHref, e);
        }
    }

    @Override
    public void cancelCurrentExecution(String programId, String pipelineId) throws CloudManagerApiException {
        this.cancelExecution(this.getCurrentExecution(programId, pipelineId));
    }

    @Override
    public void advanceCurrentExecution(String programId, String pipelineId) throws CloudManagerApiException {
        this.advanceExecution(this.getCurrentExecution(programId, pipelineId));
    }

    @Override
    public io.adobe.cloudmanager.model.PipelineExecution getExecution(String programId, String pipelineId, String executionId) throws CloudManagerApiException {
        io.adobe.cloudmanager.model.Pipeline pipeline = this.getPipeline(programId, pipelineId);
        return this.getExecution(pipeline, executionId);
    }

    @Override
    public io.adobe.cloudmanager.model.PipelineExecution getExecution(io.adobe.cloudmanager.model.Pipeline pipeline, String executionId) throws CloudManagerApiException {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("executionId", executionId);
        String executionHref = CloudManagerApiImpl.processTemplate(pipeline.getLinks().getHttpnsAdobeComadobecloudrelexecutionid().getHref(), values);
        try {
            PipelineExecution execution = this.get(executionHref, new GenericType<PipelineExecution>(){});
            return new io.adobe.cloudmanager.model.PipelineExecution(execution, this);
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.GET_EXECUTION, this.baseUrl, executionHref, e);
        }
    }

    @Override
    public void cancelExecution(String programId, String pipelineId, String executionId) throws CloudManagerApiException {
        this.cancelExecution(this.getExecution(programId, pipelineId, executionId));
    }

    @Override
    public void cancelExecution(io.adobe.cloudmanager.model.PipelineExecution execution) throws CloudManagerApiException {
        String href = execution.getCancelLink();
        try {
            this.put(href, execution.getCancelBody());
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.CANCEL_EXECUTION, this.baseUrl, href, e);
        }
    }

    @Override
    public void advanceExecution(String programId, String pipelineId, String executionId) throws CloudManagerApiException {
        this.advanceExecution(this.getExecution(programId, pipelineId, executionId));
    }

    @Override
    public void advanceExecution(io.adobe.cloudmanager.model.PipelineExecution execution) throws CloudManagerApiException {
        String href = execution.getAdvanceLink();
        try {
            this.put(href, execution.getAdvanceBody());
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.ADVANCE_EXECUTION, this.baseUrl, href, e);
        }
    }

    @Override
    public io.adobe.cloudmanager.model.PipelineExecutionStepState getExecutionStepState(io.adobe.cloudmanager.model.PipelineExecution execution, String action) throws CloudManagerApiException {
        PipelineExecutionStepState stepState = execution.getEmbedded().getStepStates().stream().filter(s -> s.getAction().equals(action)).findFirst().orElseThrow(() -> new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_STEP_STATE, action, execution.getId()));
        return new io.adobe.cloudmanager.model.PipelineExecutionStepState(stepState, this);
    }

    @Override
    public void deletePipeline(io.adobe.cloudmanager.model.Pipeline pipeline) throws CloudManagerApiException {
        String pipelinePath = pipeline.getLinks().getSelf().getHref();
        try {
            this.delete(pipelinePath);
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.DELETE_PIPELINE, this.baseUrl, pipelinePath, e);
        }
    }

    @Override
    public void deletePipeline(String programId, String pipelineId) throws CloudManagerApiException {
        io.adobe.cloudmanager.model.Pipeline original = this.getPipeline(programId, pipelineId);
        this.deletePipeline(original);
    }

    @Override
    public void deleteProgram(String programId) throws CloudManagerApiException {
        List<EmbeddedProgram> programs = this.listPrograms();
        EmbeddedProgram program = programs.stream().filter(p -> programId.equals(p.getId())).findFirst().orElseThrow(() -> new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_PROGRAM, programId));
        this.deleteProgram(program);
    }

    @Override
    public void deleteProgram(EmbeddedProgram program) throws CloudManagerApiException {
        String href = program.getLinks().getSelf().getHref();
        try {
            this.delete(href);
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.DELETE_PROGRAM, this.baseUrl, href, e);
        }
    }

    @Override
    public List<io.adobe.cloudmanager.model.Environment> listEnvironments(String programId) throws CloudManagerApiException {
        EnvironmentList environmentList;
        EmbeddedProgram embeddedProgram = this.listPrograms().stream().filter(p -> programId.equals(p.getId())).findFirst().orElseThrow(() -> new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_PROGRAM, programId));
        Program program = this.getProgram(embeddedProgram.getSelfLink());
        String environmentsHref = program.getLinks().getHttpnsAdobeComadobecloudrelenvironments().getHref();
        try {
            environmentList = this.get(environmentsHref, new GenericType<EnvironmentList>(){});
        }
        catch (ApiException e2) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.RETRIEVE_ENVIRONMENTS, this.baseUrl, environmentsHref, e2);
        }
        if (environmentList == null || environmentList.getEmbedded() == null || environmentList.getEmbedded().getEnvironments() == null) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_ENVIRONMENTS, programId);
        }
        return environmentList.getEmbedded().getEnvironments().stream().map(e -> new io.adobe.cloudmanager.model.Environment((Environment)e, this)).collect(Collectors.toList());
    }

    @Override
    public void deleteEnvironment(io.adobe.cloudmanager.model.Environment environment) throws CloudManagerApiException {
        String environmentPath = environment.getLinks().getSelf().getHref();
        try {
            this.delete(environmentPath);
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.DELETE_ENVIRONMENT, this.baseUrl, environmentPath, e);
        }
    }

    @Override
    public void deleteEnvironment(String programId, String environmentId) throws CloudManagerApiException {
        this.deleteEnvironment(this.getEnvironment(programId, environmentId));
    }

    @Override
    public io.adobe.cloudmanager.model.PipelineExecutionStepState getCurrentStep(io.adobe.cloudmanager.model.PipelineExecution execution) throws CloudManagerApiException {
        PipelineExecutionEmbedded embeddeds = execution.getEmbedded();
        if (embeddeds == null || embeddeds.getStepStates().isEmpty()) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_CURRENT_STEP, execution.getPipelineId());
        }
        PipelineExecutionStepState step = embeddeds.getStepStates().stream().filter(Predicates.IS_CURRENT).findFirst().orElseThrow(() -> new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_CURRENT_STEP, execution.getPipelineId()));
        return new io.adobe.cloudmanager.model.PipelineExecutionStepState(step, this);
    }

    @Override
    public io.adobe.cloudmanager.model.PipelineExecutionStepState getWaitingStep(io.adobe.cloudmanager.model.PipelineExecution execution) throws CloudManagerApiException {
        PipelineExecutionEmbedded embeddeds = execution.getEmbedded();
        if (embeddeds == null || embeddeds.getStepStates().isEmpty()) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_WAITING_STEP, execution.getPipelineId());
        }
        PipelineExecutionStepState step = embeddeds.getStepStates().stream().filter(Predicates.IS_WAITING).findFirst().orElseThrow(() -> new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_WAITING_STEP, execution.getPipelineId()));
        return new io.adobe.cloudmanager.model.PipelineExecutionStepState(step, this);
    }

    @Override
    public PipelineStepMetrics getQualityGateResults(io.adobe.cloudmanager.model.PipelineExecutionStepState step) throws CloudManagerApiException {
        String href = step.getLinks().getHttpnsAdobeComadobecloudrelpipelinemetrics().getHref();
        try {
            return this.get(href, new GenericType<PipelineStepMetrics>(){});
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.GET_METRICS, this.baseUrl, href, e);
        }
    }

    @Override
    public List<EnvironmentLog> downloadLogs(String programId, String environmentId, String service, String name, int days, File dir) throws CloudManagerApiException {
        return this.downloadLogs(this.getEnvironment(programId, environmentId), service, name, days, dir);
    }

    @Override
    public List<EnvironmentLog> downloadLogs(io.adobe.cloudmanager.model.Environment environment, String service, String name, int days, File dir) throws CloudManagerApiException {
        HalLink logLink = environment.getLinks().getHttpnsAdobeComadobecloudrellogs();
        if (logLink == null) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_LOGS_LINK_ENVIRONMENT, environment.getId(), environment.getProgramId());
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("service", service);
        values.put("name", name);
        values.put("days", Integer.toString(days));
        String logHref = CloudManagerApiImpl.processTemplate(logLink.getHref(), values);
        EnvironmentLogs logs = this.getLogs(logHref);
        List<io.adobe.cloudmanager.swagger.model.EnvironmentLog> downloads = logs.getEmbedded().getDownloads();
        ArrayList<EnvironmentLog> downloaded = new ArrayList<EnvironmentLog>();
        if (downloads == null || downloads.isEmpty()) {
            return Collections.emptyList();
        }
        for (io.adobe.cloudmanager.swagger.model.EnvironmentLog d : downloads) {
            EnvironmentLog log = new EnvironmentLog(d);
            String logfileName = String.format("%d-%s-%s-%s.log.gz", log.getEnvironmentId(), log.getService(), log.getName(), log.getDate());
            log.setPath(dir.getPath() + "/" + logfileName);
            log.setUrl(log.getLinks().getHttpnsAdobeComadobecloudrellogsdownload().getHref());
            this.downloadLog(log);
            downloaded.add(log);
        }
        return downloaded;
    }

    @Override
    public void getExecutionStepLog(String programId, String pipelineId, String executionId, String action, OutputStream outputStream) throws CloudManagerApiException {
        this.getExecutionStepLog(programId, pipelineId, executionId, action, null, outputStream);
    }

    @Override
    public void getExecutionStepLog(String programId, String pipelineId, String executionId, String action, String name, OutputStream outputStream) throws CloudManagerApiException {
        io.adobe.cloudmanager.model.PipelineExecution execution = this.getExecution(programId, pipelineId, executionId);
        io.adobe.cloudmanager.model.PipelineExecutionStepState stepState = this.getExecutionStepState(execution, action);
        this.getExecutionStepLog(stepState, name, outputStream);
    }

    @Override
    public void getExecutionStepLog(io.adobe.cloudmanager.model.PipelineExecutionStepState action, OutputStream outputStream) throws CloudManagerApiException {
        HalLink link = action.getLinks().getHttpnsAdobeComadobecloudrelpipelinelogs();
        if (link == null) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_LOGS_LINK_EXECUTION, action.getAction());
        }
        String url = this.getLogRedirect(link, null);
        this.streamLog(outputStream, url);
    }

    @Override
    public void getExecutionStepLog(io.adobe.cloudmanager.model.PipelineExecutionStepState action, String name, OutputStream outputStream) throws CloudManagerApiException {
        HalLink link = action.getLinks().getHttpnsAdobeComadobecloudrelpipelinelogs();
        if (link == null) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_LOGS_LINK_EXECUTION, action.getAction());
        }
        String url = this.getLogRedirect(link, name);
        this.streamLog(outputStream, url);
    }

    private String getLogRedirect(HalLink link, String name) throws CloudManagerApiException {
        String url;
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            params.add(new Pair("file", name));
        }
        try {
            url = this.get(link.getHref(), params, new GenericType<Redirect>(){}).getRedirect();
            if (StringUtils.isBlank((CharSequence)url)) {
                throw new CloudManagerApiException(CloudManagerApiException.ErrorType.NO_LOG_REDIRECT, String.format("%s%s", this.baseUrl, link.getHref()), url);
            }
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.GET_LOGS, this.baseUrl, link.getHref(), e);
        }
        return url;
    }

    private void streamLog(OutputStream outputStream, String url) throws CloudManagerApiException {
        try (InputStream is = new URL(url).openStream();){
            IOUtils.copy((InputStream)is, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.GET_LOGS, e.getMessage());
        }
        finally {
            try {
                IOUtils.close((Closeable)outputStream);
            }
            catch (IOException iOException) {}
        }
    }

    private Program getProgram(String path) throws CloudManagerApiException {
        try {
            return this.get(path, new GenericType<Program>(){});
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.GET_PROGRAM, this.baseUrl, path, e);
        }
    }

    private io.adobe.cloudmanager.model.Environment getEnvironment(String programId, String environmentId) throws CloudManagerApiException {
        List<io.adobe.cloudmanager.model.Environment> environments = this.listEnvironments(programId);
        return environments.stream().filter(e -> environmentId.equals(e.getId())).findFirst().orElseThrow(() -> new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_ENVIRONMENT, environmentId, programId));
    }

    private io.adobe.cloudmanager.model.Pipeline getPipeline(String programId, String pipelineId, CloudManagerApiException.ErrorType errorType) throws CloudManagerApiException {
        return this.listPipelines(programId).stream().filter(p -> pipelineId.equals(p.getId())).findFirst().orElseThrow(() -> new CloudManagerApiException(errorType, pipelineId, programId));
    }

    private io.adobe.cloudmanager.model.Pipeline getPipeline(String programId, String pipelineId) throws CloudManagerApiException {
        return this.getPipeline(programId, pipelineId, CloudManagerApiException.ErrorType.FIND_PIPELINE);
    }

    private List<Variable> getVariables(HalLink variableLink) throws CloudManagerApiException {
        VariableList list;
        try {
            list = this.get(variableLink.getHref(), new GenericType<VariableList>(){});
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.GET_VARIABLES, this.baseUrl, variableLink.getHref(), e);
        }
        if (list.getTotalNumberOfItems().equals(0)) {
            return Collections.emptyList();
        }
        return list.getEmbedded().getVariables().stream().map(Variable::new).collect(Collectors.toList());
    }

    private List<Variable> setVariables(HalLink variableLInk, Variable[] variables) throws CloudManagerApiException {
        VariableList list;
        try {
            list = this.patch(variableLInk.getHref(), variables, new GenericType<VariableList>(){});
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.SET_VARIABLES, this.baseUrl, variableLInk.getHref(), e);
        }
        if (list.getTotalNumberOfItems().equals(0)) {
            return Collections.emptyList();
        }
        return list.getEmbedded().getVariables().stream().map(Variable::new).collect(Collectors.toList());
    }

    private EnvironmentLogs getLogs(String path) throws CloudManagerApiException {
        try {
            return this.get(path, new GenericType<EnvironmentLogs>(){});
        }
        catch (ApiException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.GET_LOGS, this.baseUrl, path, e);
        }
    }

    private void downloadLog(EnvironmentLog log) throws CloudManagerApiException {
        try {
            Redirect redirect = this.get(log.getUrl(), new GenericType<Redirect>(){});
            File downloadedFile = new File(log.getPath());
            FileUtils.copyInputStreamToFile((InputStream)new URL(redirect.getRedirect()).openStream(), (File)downloadedFile);
        }
        catch (ApiException | MalformedURLException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.NO_LOG_REDIRECT, log.getUrl(), e.getMessage());
        }
        catch (IOException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.LOG_DOWNLOAD, e.getMessage(), log.getPath(), e.getMessage());
        }
    }

    private <T> T get(String path, GenericType<T> returnType) throws ApiException {
        return this.doRequest(path, "GET", Collections.emptyList(), null, returnType);
    }

    private <T> T get(String path, List<Pair> queryParams, GenericType<T> returnType) throws ApiException {
        return this.doRequest(path, "GET", queryParams, null, returnType);
    }

    private <T> T put(String path, Object body) throws ApiException {
        return this.put(path, body, null);
    }

    private <T> T put(String path, GenericType<T> returnType) throws ApiException {
        return this.put(path, "", returnType);
    }

    private <T> T put(String path, Object body, GenericType<T> returnType) throws ApiException {
        return this.doRequest(path, "PUT", Collections.emptyList(), body, returnType);
    }

    private <T> T patch(String path, Object body, GenericType<T> returnType) throws ApiException {
        return this.doRequest(path, "PATCH", Collections.emptyList(), body, returnType);
    }

    private <T> T delete(String path) throws ApiException {
        return this.doRequest(path, "DELETE", Collections.emptyList(), null, null);
    }

    private <T> T doRequest(String path, String method, List<Pair> queryParams, Object body, GenericType<T> returnType) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-gw-ims-org-id", this.orgId);
        headers.put("Authorization", String.format("Bearer %s", this.accessToken));
        headers.put("x-api-key", this.apiKey);
        return this.apiClient.invokeAPI(path, method, queryParams, body, headers, Collections.emptyMap(), "application/json", "application/json", new String[0], returnType);
    }
}

