/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.impl;

import io.adobe.cloudmanager.AdobeClientCredentials;
import io.adobe.cloudmanager.IdentityManagementApi;
import io.adobe.cloudmanager.IdentityManagementApiException;
import io.adobe.cloudmanager.jwt.swagger.api.JwtApi;
import io.adobe.cloudmanager.jwt.swagger.invoker.ApiClient;
import io.adobe.cloudmanager.jwt.swagger.invoker.ApiException;
import io.adobe.cloudmanager.jwt.swagger.model.Token;
import io.jsonwebtoken.Jwts;
import java.security.Key;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class IdentityManagementApiImpl
implements IdentityManagementApi {
    private final ApiClient apiClient = new ApiClient();

    public IdentityManagementApiImpl() {
    }

    public IdentityManagementApiImpl(String baseUrl) {
        this.apiClient.setBasePath(baseUrl);
    }

    @Override
    public String authenticate(AdobeClientCredentials org) throws IdentityManagementApiException {
        Calendar expires = Calendar.getInstance();
        expires.add(12, 5);
        String jws = Jwts.builder().setHeaderParam("alg", (Object)"RS256").setHeaderParam("typ", (Object)"jwt").setExpiration(expires.getTime()).setIssuer(org.getOrgId()).setSubject(org.getTechnicalAccountId()).setAudience(String.format("%s/c/%s", this.apiClient.getBasePath(), org.getApiKey())).addClaims(this.buildClaims()).signWith((Key)org.getPrivateKey()).compact();
        Token token = this.authenticate(org, jws);
        return token.getAccessToken();
    }

    private Token authenticate(AdobeClientCredentials org, String jwts) throws IdentityManagementApiException {
        try {
            return new JwtApi(this.apiClient).authenticate(org.getApiKey(), org.getClientSecret(), jwts);
        }
        catch (ApiException e) {
            throw new IdentityManagementApiException("Unable to authenticate to AdobeIO.", e);
        }
    }

    private Map<String, Object> buildClaims() {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("https://ims-na1.adobelogin.com/s/ent_cloudmgr_sdk", true);
        return claims;
    }
}

