/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.jwt.swagger.api;

import io.adobe.cloudmanager.jwt.swagger.invoker.ApiClient;
import io.adobe.cloudmanager.jwt.swagger.invoker.ApiException;
import io.adobe.cloudmanager.jwt.swagger.invoker.Configuration;
import io.adobe.cloudmanager.jwt.swagger.invoker.Pair;
import io.adobe.cloudmanager.jwt.swagger.model.Token;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class JwtApi {
    private ApiClient apiClient;

    public JwtApi() {
        this(Configuration.getDefaultApiClient());
    }

    public JwtApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Token authenticate(String clientId, String clientSecret, String jwtToken) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling authenticate");
        }
        if (clientSecret == null) {
            throw new ApiException(400, "Missing the required parameter 'clientSecret' when calling authenticate");
        }
        if (jwtToken == null) {
            throw new ApiException(400, "Missing the required parameter 'jwtToken' when calling authenticate");
        }
        String localVarPath = "/ims/exchange/jwt";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (clientId != null) {
            localVarFormParams.put("client_id", clientId);
        }
        if (clientSecret != null) {
            localVarFormParams.put("client_secret", clientSecret);
        }
        if (jwtToken != null) {
            localVarFormParams.put("jwt_token", jwtToken);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Token> localVarReturnType = new GenericType<Token>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

