/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.adobe.cloudmanager.CloudManagerApi;
import io.adobe.cloudmanager.CloudManagerApiException;
import io.adobe.cloudmanager.model.PipelineExecutionStepState;
import io.adobe.cloudmanager.swagger.model.HalLink;
import io.adobe.cloudmanager.swagger.model.Metric;
import io.adobe.cloudmanager.swagger.model.PipelineExecution;
import io.adobe.cloudmanager.swagger.model.PipelineExecutionEmbedded;
import io.adobe.cloudmanager.swagger.model.PipelineExecutionLinks;
import io.adobe.cloudmanager.swagger.model.PipelineExecutionStepState;
import io.adobe.cloudmanager.swagger.model.PipelineStepMetrics;
import io.adobe.cloudmanager.util.Predicates;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.joda.time.DateTime;

public class PipelineExecution
extends io.adobe.cloudmanager.swagger.model.PipelineExecution {
    public static final String ACTION_APPROVAL = "approval";
    public static final String ACTION_SCHEDULE = "schedule";
    public static final String ACTION_DEPLOY = "deploy";
    private final io.adobe.cloudmanager.swagger.model.PipelineExecution delegate;
    private final CloudManagerApi client;

    public PipelineExecution(io.adobe.cloudmanager.swagger.model.PipelineExecution delegate, CloudManagerApi client) {
        this.delegate = delegate;
        this.client = client;
    }

    public void advance() throws CloudManagerApiException {
        this.client.advanceExecution(this);
    }

    public void cancel() throws CloudManagerApiException {
        this.client.cancelExecution(this);
    }

    public String getAdvanceLink() throws CloudManagerApiException {
        PipelineExecutionStepState step = this.client.getWaitingStep(this);
        HalLink link = step.getLinks().getHttpnsAdobeComadobecloudrelpipelineadvance();
        if (link == null) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_ADVANCE_LINK, step.getAction());
        }
        return link.getHref();
    }

    public String getAdvanceBody() throws CloudManagerApiException {
        PipelineExecutionStepState step = this.client.getWaitingStep(this);
        StringWriter writer = new StringWriter();
        JsonFactory jsonFactory = new JsonFactory();
        try {
            JsonGenerator gen = jsonFactory.createGenerator((Writer)writer);
            gen.writeStartObject();
            if (ACTION_APPROVAL.equals(step.getAction())) {
                gen.writeBooleanField("approved", true);
            } else {
                ObjectMapper mapper = new ObjectMapper(jsonFactory);
                gen.writeFieldName("metrics");
                gen.writeStartArray();
                this.buildMetricsOverride(mapper, gen, step);
                gen.writeEndArray();
                gen.writeBooleanField("override", true);
            }
            gen.writeEndObject();
            gen.close();
            return writer.toString();
        }
        catch (IOException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.GENERATE_BODY, e.getMessage());
        }
    }

    public String getCancelLink() throws CloudManagerApiException {
        PipelineExecutionStepState step = this.client.getCurrentStep(this);
        HalLink link = PipelineExecutionStepState.StatusEnum.WAITING.equals((Object)step.getStatus()) && ACTION_DEPLOY.equals(step.getAction()) ? step.getLinks().getHttpnsAdobeComadobecloudrelpipelineadvance() : step.getLinks().getHttpnsAdobeComadobecloudrelpipelinecancel();
        if (link == null) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.FIND_CANCEL_LINK, step.getAction());
        }
        return link.getHref();
    }

    public String getCancelBody() throws CloudManagerApiException {
        PipelineExecutionStepState step = this.client.getCurrentStep(this);
        StringWriter writer = new StringWriter();
        JsonFactory jsonFactory = new JsonFactory();
        try {
            JsonGenerator gen = jsonFactory.createGenerator((Writer)writer);
            gen.writeStartObject();
            if (ACTION_APPROVAL.equals(step.getAction())) {
                gen.writeBooleanField("approved", false);
            } else if (PipelineExecutionStepState.StatusEnum.WAITING.equals((Object)step.getStatus()) && !ACTION_SCHEDULE.equals(step.getAction()) && !ACTION_DEPLOY.equals(step.getAction())) {
                gen.writeBooleanField("override", false);
            } else if (PipelineExecutionStepState.StatusEnum.WAITING.equals((Object)step.getStatus()) && ACTION_DEPLOY.equals(step.getAction())) {
                gen.writeBooleanField("resume", false);
            } else {
                gen.writeBooleanField("cancel", true);
            }
            gen.writeEndObject();
            gen.close();
            return writer.toString();
        }
        catch (IOException e) {
            throw new CloudManagerApiException(CloudManagerApiException.ErrorType.GENERATE_BODY, e.getMessage());
        }
    }

    private void buildMetricsOverride(ObjectMapper mapper, JsonGenerator gen, PipelineExecutionStepState step) throws CloudManagerApiException, IOException {
        PipelineStepMetrics metrics = this.client.getQualityGateResults(step);
        List failed = metrics.getMetrics().stream().filter(Predicates.FAILED).collect(Collectors.toList());
        for (Metric m : failed) {
            mapper.writeValue(gen, (Object)m);
        }
    }

    @Override
    @Generated
    public String toString() {
        return "PipelineExecution(delegate=" + this.delegate + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PipelineExecution)) {
            return false;
        }
        PipelineExecution other = (PipelineExecution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        io.adobe.cloudmanager.swagger.model.PipelineExecution this$delegate = this.delegate;
        io.adobe.cloudmanager.swagger.model.PipelineExecution other$delegate = other.delegate;
        return !(this$delegate == null ? other$delegate != null : !((Object)this$delegate).equals(other$delegate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PipelineExecution;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        io.adobe.cloudmanager.swagger.model.PipelineExecution $delegate = this.delegate;
        result = result * 59 + ($delegate == null ? 43 : ((Object)$delegate).hashCode());
        return result;
    }

    @Override
    @Generated
    public io.adobe.cloudmanager.swagger.model.PipelineExecution id(String id) {
        return this.delegate.id(id);
    }

    @Override
    @Generated
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    @Generated
    public void setId(String id) {
        this.delegate.setId(id);
    }

    @Override
    @Generated
    public String getProgramId() {
        return this.delegate.getProgramId();
    }

    @Override
    @Generated
    public String getPipelineId() {
        return this.delegate.getPipelineId();
    }

    @Override
    @Generated
    public io.adobe.cloudmanager.swagger.model.PipelineExecution artifactsVersion(String artifactsVersion) {
        return this.delegate.artifactsVersion(artifactsVersion);
    }

    @Override
    @Generated
    public String getArtifactsVersion() {
        return this.delegate.getArtifactsVersion();
    }

    @Override
    @Generated
    public void setArtifactsVersion(String artifactsVersion) {
        this.delegate.setArtifactsVersion(artifactsVersion);
    }

    @Override
    @Generated
    public io.adobe.cloudmanager.swagger.model.PipelineExecution user(String user) {
        return this.delegate.user(user);
    }

    @Override
    @Generated
    public String getUser() {
        return this.delegate.getUser();
    }

    @Override
    @Generated
    public void setUser(String user) {
        this.delegate.setUser(user);
    }

    @Override
    @Generated
    public io.adobe.cloudmanager.swagger.model.PipelineExecution status(PipelineExecution.StatusEnum status) {
        return this.delegate.status(status);
    }

    @Override
    @Generated
    public PipelineExecution.StatusEnum getStatus() {
        return this.delegate.getStatus();
    }

    @Override
    @Generated
    public void setStatus(PipelineExecution.StatusEnum status) {
        this.delegate.setStatus(status);
    }

    @Override
    @Generated
    public io.adobe.cloudmanager.swagger.model.PipelineExecution trigger(PipelineExecution.TriggerEnum trigger) {
        return this.delegate.trigger(trigger);
    }

    @Override
    @Generated
    public PipelineExecution.TriggerEnum getTrigger() {
        return this.delegate.getTrigger();
    }

    @Override
    @Generated
    public void setTrigger(PipelineExecution.TriggerEnum trigger) {
        this.delegate.setTrigger(trigger);
    }

    @Override
    @Generated
    public io.adobe.cloudmanager.swagger.model.PipelineExecution createdAt(DateTime createdAt) {
        return this.delegate.createdAt(createdAt);
    }

    @Override
    @Generated
    public DateTime getCreatedAt() {
        return this.delegate.getCreatedAt();
    }

    @Override
    @Generated
    public void setCreatedAt(DateTime createdAt) {
        this.delegate.setCreatedAt(createdAt);
    }

    @Override
    @Generated
    public io.adobe.cloudmanager.swagger.model.PipelineExecution updatedAt(DateTime updatedAt) {
        return this.delegate.updatedAt(updatedAt);
    }

    @Override
    @Generated
    public DateTime getUpdatedAt() {
        return this.delegate.getUpdatedAt();
    }

    @Override
    @Generated
    public void setUpdatedAt(DateTime updatedAt) {
        this.delegate.setUpdatedAt(updatedAt);
    }

    @Override
    @Generated
    public io.adobe.cloudmanager.swagger.model.PipelineExecution finishedAt(DateTime finishedAt) {
        return this.delegate.finishedAt(finishedAt);
    }

    @Override
    @Generated
    public DateTime getFinishedAt() {
        return this.delegate.getFinishedAt();
    }

    @Override
    @Generated
    public void setFinishedAt(DateTime finishedAt) {
        this.delegate.setFinishedAt(finishedAt);
    }

    @Override
    @Generated
    public io.adobe.cloudmanager.swagger.model.PipelineExecution _embedded(PipelineExecutionEmbedded _embedded) {
        return this.delegate._embedded(_embedded);
    }

    @Override
    @Generated
    public PipelineExecutionEmbedded getEmbedded() {
        return this.delegate.getEmbedded();
    }

    @Override
    @Generated
    public void setEmbedded(PipelineExecutionEmbedded _embedded) {
        this.delegate.setEmbedded(_embedded);
    }

    @Override
    @Generated
    public io.adobe.cloudmanager.swagger.model.PipelineExecution _links(PipelineExecutionLinks _links) {
        return this.delegate._links(_links);
    }

    @Override
    @Generated
    public PipelineExecutionLinks getLinks() {
        return this.delegate.getLinks();
    }

    @Override
    @Generated
    public void setLinks(PipelineExecutionLinks _links) {
        this.delegate.setLinks(_links);
    }
}

