/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.api;

import io.adobe.cloudmanager.swagger.invoker.ApiClient;
import io.adobe.cloudmanager.swagger.invoker.ApiException;
import io.adobe.cloudmanager.swagger.invoker.Configuration;
import io.adobe.cloudmanager.swagger.invoker.Pair;
import io.adobe.cloudmanager.swagger.model.BranchList;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class BranchesApi {
    private ApiClient apiClient;

    public BranchesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BranchesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BranchList getBranches(String programId, String repositoryId, String xGwImsOrgId, String authorization, String xApiKey) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling getBranches");
        }
        if (repositoryId == null) {
            throw new ApiException(400, "Missing the required parameter 'repositoryId' when calling getBranches");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling getBranches");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getBranches");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling getBranches");
        }
        String localVarPath = "/api/program/{programId}/repository/{repositoryId}/branches".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{repositoryId\\}", this.apiClient.escapeString(repositoryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<BranchList> localVarReturnType = new GenericType<BranchList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

