/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.api;

import io.adobe.cloudmanager.swagger.invoker.ApiClient;
import io.adobe.cloudmanager.swagger.invoker.ApiException;
import io.adobe.cloudmanager.swagger.invoker.Configuration;
import io.adobe.cloudmanager.swagger.invoker.Pair;
import io.adobe.cloudmanager.swagger.model.PipelineExecution;
import io.adobe.cloudmanager.swagger.model.PipelineExecutionListRepresentation;
import io.adobe.cloudmanager.swagger.model.PipelineExecutionStepState;
import io.adobe.cloudmanager.swagger.model.PipelineStepMetrics;
import io.adobe.cloudmanager.swagger.model.Redirect;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class PipelineExecutionApi {
    private ApiClient apiClient;

    public PipelineExecutionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PipelineExecutionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void advancePipelineExecution(Object body, String xGwImsOrgId, String authorization, String xApiKey, String contentType, String programId, String pipelineId, String executionId, String phaseId, String stepId) throws ApiException {
        Object localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling advancePipelineExecution");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling advancePipelineExecution");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling advancePipelineExecution");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling advancePipelineExecution");
        }
        if (contentType == null) {
            throw new ApiException(400, "Missing the required parameter 'contentType' when calling advancePipelineExecution");
        }
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling advancePipelineExecution");
        }
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling advancePipelineExecution");
        }
        if (executionId == null) {
            throw new ApiException(400, "Missing the required parameter 'executionId' when calling advancePipelineExecution");
        }
        if (phaseId == null) {
            throw new ApiException(400, "Missing the required parameter 'phaseId' when calling advancePipelineExecution");
        }
        if (stepId == null) {
            throw new ApiException(400, "Missing the required parameter 'stepId' when calling advancePipelineExecution");
        }
        String localVarPath = "/api/program/{programId}/pipeline/{pipelineId}/execution/{executionId}/phase/{phaseId}/step/{stepId}/advance".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{pipelineId\\}", this.apiClient.escapeString(pipelineId.toString())).replaceAll("\\{executionId\\}", this.apiClient.escapeString(executionId.toString())).replaceAll("\\{phaseId\\}", this.apiClient.escapeString(phaseId.toString())).replaceAll("\\{stepId\\}", this.apiClient.escapeString(stepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.apiClient.parameterToString(contentType));
        }
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void cancelPipelineExecutionStep(Object body, String xGwImsOrgId, String authorization, String xApiKey, String contentType, String programId, String pipelineId, String executionId, String phaseId, String stepId) throws ApiException {
        Object localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling cancelPipelineExecutionStep");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling cancelPipelineExecutionStep");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling cancelPipelineExecutionStep");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling cancelPipelineExecutionStep");
        }
        if (contentType == null) {
            throw new ApiException(400, "Missing the required parameter 'contentType' when calling cancelPipelineExecutionStep");
        }
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling cancelPipelineExecutionStep");
        }
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling cancelPipelineExecutionStep");
        }
        if (executionId == null) {
            throw new ApiException(400, "Missing the required parameter 'executionId' when calling cancelPipelineExecutionStep");
        }
        if (phaseId == null) {
            throw new ApiException(400, "Missing the required parameter 'phaseId' when calling cancelPipelineExecutionStep");
        }
        if (stepId == null) {
            throw new ApiException(400, "Missing the required parameter 'stepId' when calling cancelPipelineExecutionStep");
        }
        String localVarPath = "/api/program/{programId}/pipeline/{pipelineId}/execution/{executionId}/phase/{phaseId}/step/{stepId}/cancel".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{pipelineId\\}", this.apiClient.escapeString(pipelineId.toString())).replaceAll("\\{executionId\\}", this.apiClient.escapeString(executionId.toString())).replaceAll("\\{phaseId\\}", this.apiClient.escapeString(phaseId.toString())).replaceAll("\\{stepId\\}", this.apiClient.escapeString(stepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.apiClient.parameterToString(contentType));
        }
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public PipelineExecution getCurrentExecution(String programId, String pipelineId, String xGwImsOrgId, String authorization, String xApiKey) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling getCurrentExecution");
        }
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling getCurrentExecution");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling getCurrentExecution");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getCurrentExecution");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling getCurrentExecution");
        }
        String localVarPath = "/api/program/{programId}/pipeline/{pipelineId}/execution".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{pipelineId\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PipelineExecution> localVarReturnType = new GenericType<PipelineExecution>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PipelineExecution getExecution(String programId, String pipelineId, String executionId, String xGwImsOrgId, String authorization, String xApiKey) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling getExecution");
        }
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling getExecution");
        }
        if (executionId == null) {
            throw new ApiException(400, "Missing the required parameter 'executionId' when calling getExecution");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling getExecution");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getExecution");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling getExecution");
        }
        String localVarPath = "/api/program/{programId}/pipeline/{pipelineId}/execution/{executionId}".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{pipelineId\\}", this.apiClient.escapeString(pipelineId.toString())).replaceAll("\\{executionId\\}", this.apiClient.escapeString(executionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PipelineExecution> localVarReturnType = new GenericType<PipelineExecution>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PipelineExecutionListRepresentation getExecutions(String programId, String pipelineId, String xGwImsOrgId, String authorization, String xApiKey, String start, Integer limit) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling getExecutions");
        }
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling getExecutions");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling getExecutions");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getExecutions");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling getExecutions");
        }
        String localVarPath = "/api/program/{programId}/pipeline/{pipelineId}/executions".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{pipelineId\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PipelineExecutionListRepresentation> localVarReturnType = new GenericType<PipelineExecutionListRepresentation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Redirect getStepLogs(String programId, String pipelineId, String executionId, String phaseId, String stepId, String xGwImsOrgId, String authorization, String xApiKey, String file, String accept) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling getStepLogs");
        }
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling getStepLogs");
        }
        if (executionId == null) {
            throw new ApiException(400, "Missing the required parameter 'executionId' when calling getStepLogs");
        }
        if (phaseId == null) {
            throw new ApiException(400, "Missing the required parameter 'phaseId' when calling getStepLogs");
        }
        if (stepId == null) {
            throw new ApiException(400, "Missing the required parameter 'stepId' when calling getStepLogs");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling getStepLogs");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getStepLogs");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling getStepLogs");
        }
        String localVarPath = "/api/program/{programId}/pipeline/{pipelineId}/execution/{executionId}/phase/{phaseId}/step/{stepId}/logs".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{pipelineId\\}", this.apiClient.escapeString(pipelineId.toString())).replaceAll("\\{executionId\\}", this.apiClient.escapeString(executionId.toString())).replaceAll("\\{phaseId\\}", this.apiClient.escapeString(phaseId.toString())).replaceAll("\\{stepId\\}", this.apiClient.escapeString(stepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "file", file));
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Redirect> localVarReturnType = new GenericType<Redirect>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PipelineExecution startPipeline(String programId, String pipelineId, String xGwImsOrgId, String authorization, String xApiKey, String contentType) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling startPipeline");
        }
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling startPipeline");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling startPipeline");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling startPipeline");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling startPipeline");
        }
        if (contentType == null) {
            throw new ApiException(400, "Missing the required parameter 'contentType' when calling startPipeline");
        }
        String localVarPath = "/api/program/{programId}/pipeline/{pipelineId}/execution".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{pipelineId\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.apiClient.parameterToString(contentType));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PipelineExecution> localVarReturnType = new GenericType<PipelineExecution>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PipelineStepMetrics stepMetric(String programId, String pipelineId, String executionId, String phaseId, String stepId, String xGwImsOrgId, String authorization, String xApiKey) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling stepMetric");
        }
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling stepMetric");
        }
        if (executionId == null) {
            throw new ApiException(400, "Missing the required parameter 'executionId' when calling stepMetric");
        }
        if (phaseId == null) {
            throw new ApiException(400, "Missing the required parameter 'phaseId' when calling stepMetric");
        }
        if (stepId == null) {
            throw new ApiException(400, "Missing the required parameter 'stepId' when calling stepMetric");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling stepMetric");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling stepMetric");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling stepMetric");
        }
        String localVarPath = "/api/program/{programId}/pipeline/{pipelineId}/execution/{executionId}/phase/{phaseId}/step/{stepId}/metrics".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{pipelineId\\}", this.apiClient.escapeString(pipelineId.toString())).replaceAll("\\{executionId\\}", this.apiClient.escapeString(executionId.toString())).replaceAll("\\{phaseId\\}", this.apiClient.escapeString(phaseId.toString())).replaceAll("\\{stepId\\}", this.apiClient.escapeString(stepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PipelineStepMetrics> localVarReturnType = new GenericType<PipelineStepMetrics>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PipelineExecutionStepState stepState(String programId, String pipelineId, String executionId, String phaseId, String stepId, String xGwImsOrgId, String authorization, String xApiKey) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling stepState");
        }
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling stepState");
        }
        if (executionId == null) {
            throw new ApiException(400, "Missing the required parameter 'executionId' when calling stepState");
        }
        if (phaseId == null) {
            throw new ApiException(400, "Missing the required parameter 'phaseId' when calling stepState");
        }
        if (stepId == null) {
            throw new ApiException(400, "Missing the required parameter 'stepId' when calling stepState");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling stepState");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling stepState");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling stepState");
        }
        String localVarPath = "/api/program/{programId}/pipeline/{pipelineId}/execution/{executionId}/phase/{phaseId}/step/{stepId}".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{pipelineId\\}", this.apiClient.escapeString(pipelineId.toString())).replaceAll("\\{executionId\\}", this.apiClient.escapeString(executionId.toString())).replaceAll("\\{phaseId\\}", this.apiClient.escapeString(phaseId.toString())).replaceAll("\\{stepId\\}", this.apiClient.escapeString(stepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PipelineExecutionStepState> localVarReturnType = new GenericType<PipelineExecutionStepState>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

