/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.api;

import io.adobe.cloudmanager.swagger.invoker.ApiClient;
import io.adobe.cloudmanager.swagger.invoker.ApiException;
import io.adobe.cloudmanager.swagger.invoker.Configuration;
import io.adobe.cloudmanager.swagger.invoker.Pair;
import io.adobe.cloudmanager.swagger.model.Pipeline;
import io.adobe.cloudmanager.swagger.model.PipelineList;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class PipelinesApi {
    private ApiClient apiClient;

    public PipelinesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PipelinesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deletePipeline(String programId, String pipelineId, String xGwImsOrgId, String authorization, String xApiKey) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling deletePipeline");
        }
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling deletePipeline");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling deletePipeline");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling deletePipeline");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling deletePipeline");
        }
        String localVarPath = "/api/program/{programId}/pipeline/{pipelineId}".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{pipelineId\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Pipeline getPipeline(String programId, String pipelineId, String xGwImsOrgId, String authorization, String xApiKey) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling getPipeline");
        }
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling getPipeline");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling getPipeline");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getPipeline");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling getPipeline");
        }
        String localVarPath = "/api/program/{programId}/pipeline/{pipelineId}".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{pipelineId\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Pipeline> localVarReturnType = new GenericType<Pipeline>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PipelineList getPipelines(String programId, String xGwImsOrgId, String authorization, String xApiKey) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling getPipelines");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling getPipelines");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getPipelines");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling getPipelines");
        }
        String localVarPath = "/api/program/{programId}/pipelines".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PipelineList> localVarReturnType = new GenericType<PipelineList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Pipeline patchPipeline(Pipeline body, String xGwImsOrgId, String authorization, String xApiKey, String contentType, String programId, String pipelineId) throws ApiException {
        Pipeline localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling patchPipeline");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling patchPipeline");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling patchPipeline");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling patchPipeline");
        }
        if (contentType == null) {
            throw new ApiException(400, "Missing the required parameter 'contentType' when calling patchPipeline");
        }
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling patchPipeline");
        }
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling patchPipeline");
        }
        String localVarPath = "/api/program/{programId}/pipeline/{pipelineId}".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{pipelineId\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.apiClient.parameterToString(contentType));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Pipeline> localVarReturnType = new GenericType<Pipeline>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

