/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.api;

import io.adobe.cloudmanager.swagger.invoker.ApiClient;
import io.adobe.cloudmanager.swagger.invoker.ApiException;
import io.adobe.cloudmanager.swagger.invoker.Configuration;
import io.adobe.cloudmanager.swagger.invoker.Pair;
import io.adobe.cloudmanager.swagger.model.Repository;
import io.adobe.cloudmanager.swagger.model.RepositoryList;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class RepositoriesApi {
    private ApiClient apiClient;

    public RepositoriesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RepositoriesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RepositoryList getRepositories(String programId, String xGwImsOrgId, String authorization, String xApiKey) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling getRepositories");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling getRepositories");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getRepositories");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling getRepositories");
        }
        String localVarPath = "/api/program/{programId}/repositories".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<RepositoryList> localVarReturnType = new GenericType<RepositoryList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Repository getRepository(String programId, String repositoryId, String xGwImsOrgId, String authorization, String xApiKey) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling getRepository");
        }
        if (repositoryId == null) {
            throw new ApiException(400, "Missing the required parameter 'repositoryId' when calling getRepository");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling getRepository");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getRepository");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling getRepository");
        }
        String localVarPath = "/api/program/{programId}/repository/{repositoryId}".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{repositoryId\\}", this.apiClient.escapeString(repositoryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Repository> localVarReturnType = new GenericType<Repository>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

