/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.api;

import io.adobe.cloudmanager.swagger.invoker.ApiClient;
import io.adobe.cloudmanager.swagger.invoker.ApiException;
import io.adobe.cloudmanager.swagger.invoker.Configuration;
import io.adobe.cloudmanager.swagger.invoker.Pair;
import io.adobe.cloudmanager.swagger.model.Variable;
import io.adobe.cloudmanager.swagger.model.VariableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class VariablesApi {
    private ApiClient apiClient;

    public VariablesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VariablesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public VariableList getEnvironmentVariables(String programId, String environmentId, String xGwImsOrgId, String authorization, String xApiKey) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling getEnvironmentVariables");
        }
        if (environmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'environmentId' when calling getEnvironmentVariables");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling getEnvironmentVariables");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getEnvironmentVariables");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling getEnvironmentVariables");
        }
        String localVarPath = "/api/program/{programId}/environment/{environmentId}/variables".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{environmentId\\}", this.apiClient.escapeString(environmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<VariableList> localVarReturnType = new GenericType<VariableList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public VariableList getPipelineVariables(String programId, String pipelineId, String xGwImsOrgId, String authorization, String xApiKey) throws ApiException {
        Object localVarPostBody = null;
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling getPipelineVariables");
        }
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling getPipelineVariables");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling getPipelineVariables");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getPipelineVariables");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling getPipelineVariables");
        }
        String localVarPath = "/api/program/{programId}/pipeline/{pipelineId}/variables".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{pipelineId\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<VariableList> localVarReturnType = new GenericType<VariableList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public VariableList patchEnvironmentVariables(List<Variable> body, String xGwImsOrgId, String authorization, String xApiKey, String contentType, String programId, String environmentId) throws ApiException {
        List<Variable> localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling patchEnvironmentVariables");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling patchEnvironmentVariables");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling patchEnvironmentVariables");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling patchEnvironmentVariables");
        }
        if (contentType == null) {
            throw new ApiException(400, "Missing the required parameter 'contentType' when calling patchEnvironmentVariables");
        }
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling patchEnvironmentVariables");
        }
        if (environmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'environmentId' when calling patchEnvironmentVariables");
        }
        String localVarPath = "/api/program/{programId}/environment/{environmentId}/variables".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{environmentId\\}", this.apiClient.escapeString(environmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.apiClient.parameterToString(contentType));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<VariableList> localVarReturnType = new GenericType<VariableList>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public VariableList patchPipelineVariables(List<Variable> body, String xGwImsOrgId, String authorization, String xApiKey, String contentType, String programId, String pipelineId) throws ApiException {
        List<Variable> localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling patchPipelineVariables");
        }
        if (xGwImsOrgId == null) {
            throw new ApiException(400, "Missing the required parameter 'xGwImsOrgId' when calling patchPipelineVariables");
        }
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling patchPipelineVariables");
        }
        if (xApiKey == null) {
            throw new ApiException(400, "Missing the required parameter 'xApiKey' when calling patchPipelineVariables");
        }
        if (contentType == null) {
            throw new ApiException(400, "Missing the required parameter 'contentType' when calling patchPipelineVariables");
        }
        if (programId == null) {
            throw new ApiException(400, "Missing the required parameter 'programId' when calling patchPipelineVariables");
        }
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling patchPipelineVariables");
        }
        String localVarPath = "/api/program/{programId}/pipeline/{pipelineId}/variables".replaceAll("\\{programId\\}", this.apiClient.escapeString(programId.toString())).replaceAll("\\{pipelineId\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xGwImsOrgId != null) {
            localVarHeaderParams.put("x-gw-ims-org-id", this.apiClient.parameterToString(xGwImsOrgId));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.apiClient.parameterToString(contentType));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<VariableList> localVarReturnType = new GenericType<VariableList>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

