/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.adobe.cloudmanager.swagger.model.InvalidParameter;
import io.adobe.cloudmanager.swagger.model.MissingParameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="A Bad Request response error.")
public class BadRequestError
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="status")
    private Integer status = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="missingParams")
    private List<MissingParameter> missingParams = null;
    @JsonProperty(value="invalidParams")
    private List<InvalidParameter> invalidParams = null;

    public BadRequestError status(Integer status) {
        this.status = status;
        return this;
    }

    @Schema(description="HTTP status code of the response.")
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public BadRequestError type(String type) {
        this.type = type;
        return this;
    }

    @Schema(example="http://ns.adobe.com/adobecloud/error", description="Error type identifier.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public BadRequestError title(String title) {
        this.title = title;
        return this;
    }

    @Schema(example="Validation failed", description="A short summary of the error.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public BadRequestError missingParams(List<MissingParameter> missingParams) {
        this.missingParams = missingParams;
        return this;
    }

    public BadRequestError addMissingParamsItem(MissingParameter missingParamsItem) {
        if (this.missingParams == null) {
            this.missingParams = new ArrayList<MissingParameter>();
        }
        this.missingParams.add(missingParamsItem);
        return this;
    }

    @Schema(description="Request's missing parameters.")
    public List<MissingParameter> getMissingParams() {
        return this.missingParams;
    }

    public void setMissingParams(List<MissingParameter> missingParams) {
        this.missingParams = missingParams;
    }

    public BadRequestError invalidParams(List<InvalidParameter> invalidParams) {
        this.invalidParams = invalidParams;
        return this;
    }

    public BadRequestError addInvalidParamsItem(InvalidParameter invalidParamsItem) {
        if (this.invalidParams == null) {
            this.invalidParams = new ArrayList<InvalidParameter>();
        }
        this.invalidParams.add(invalidParamsItem);
        return this;
    }

    @Schema(description="Request's invalid parameters.")
    public List<InvalidParameter> getInvalidParams() {
        return this.invalidParams;
    }

    public void setInvalidParams(List<InvalidParameter> invalidParams) {
        this.invalidParams = invalidParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BadRequestError badRequestError = (BadRequestError)o;
        return Objects.equals(this.status, badRequestError.status) && Objects.equals(this.type, badRequestError.type) && Objects.equals(this.title, badRequestError.title) && Objects.equals(this.missingParams, badRequestError.missingParams) && Objects.equals(this.invalidParams, badRequestError.invalidParams);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.type, this.title, this.missingParams, this.invalidParams);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BadRequestError {\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    missingParams: ").append(this.toIndentedString(this.missingParams)).append("\n");
        sb.append("    invalidParams: ").append(this.toIndentedString(this.invalidParams)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

