/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.adobe.cloudmanager.swagger.model.EmbeddedProgramLinks;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="A lightweight representation of a Program")
public class EmbeddedProgram
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = false;
    @JsonProperty(value="tenantId")
    private String tenantId = null;
    @JsonProperty(value="_links")
    private EmbeddedProgramLinks _links = null;

    @Schema(example="14", description="Identifier of the program. Unique within the space.")
    public String getId() {
        return this.id;
    }

    @Schema(example="AcmeCorp Main Site", description="Name of the program")
    public String getName() {
        return this.name;
    }

    @Schema(description="Whether this Program has been enabled for Cloud Manager usage")
    public Boolean isEnabled() {
        return this.enabled;
    }

    @Schema(example="acmeCorp", description="Tenant Id")
    public String getTenantId() {
        return this.tenantId;
    }

    public EmbeddedProgram _links(EmbeddedProgramLinks _links) {
        this._links = _links;
        return this;
    }

    @Schema(description="")
    public EmbeddedProgramLinks getLinks() {
        return this._links;
    }

    public void setLinks(EmbeddedProgramLinks _links) {
        this._links = _links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddedProgram embeddedProgram = (EmbeddedProgram)o;
        return Objects.equals(this.id, embeddedProgram.id) && Objects.equals(this.name, embeddedProgram.name) && Objects.equals(this.enabled, embeddedProgram.enabled) && Objects.equals(this.tenantId, embeddedProgram.tenantId) && Objects.equals(this._links, embeddedProgram._links);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.enabled, this.tenantId, this._links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmbeddedProgram {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    _links: ").append(this.toIndentedString(this._links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

