/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.adobe.cloudmanager.swagger.model.EnvironmentLinks;
import io.adobe.cloudmanager.swagger.model.LogOptionRepresentation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="A representation of an Environment known to Cloud Manager.")
public class Environment
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="programId")
    private String programId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="availableLogOptions")
    private List<LogOptionRepresentation> availableLogOptions = null;
    @JsonProperty(value="_links")
    private EnvironmentLinks _links = null;

    public Environment id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Environment programId(String programId) {
        this.programId = programId;
        return this;
    }

    @Schema(example="14", description="Identifier of the program. Unique within the space.")
    public String getProgramId() {
        return this.programId;
    }

    public void setProgramId(String programId) {
        this.programId = programId;
    }

    public Environment name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="AcmeCorp Dev1 Environment", description="Name of the environment")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Environment description(String description) {
        this.description = description;
        return this;
    }

    @Schema(example="This is our primary development environment", description="Description of the environment")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Environment type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(example="dev", description="Type of the environment")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Environment availableLogOptions(List<LogOptionRepresentation> availableLogOptions) {
        this.availableLogOptions = availableLogOptions;
        return this;
    }

    public Environment addAvailableLogOptionsItem(LogOptionRepresentation availableLogOptionsItem) {
        if (this.availableLogOptions == null) {
            this.availableLogOptions = new ArrayList<LogOptionRepresentation>();
        }
        this.availableLogOptions.add(availableLogOptionsItem);
        return this;
    }

    @Schema(example="custom", description="List of logs available in the environment")
    public List<LogOptionRepresentation> getAvailableLogOptions() {
        return this.availableLogOptions;
    }

    public void setAvailableLogOptions(List<LogOptionRepresentation> availableLogOptions) {
        this.availableLogOptions = availableLogOptions;
    }

    public Environment _links(EnvironmentLinks _links) {
        this._links = _links;
        return this;
    }

    @Schema(description="")
    public EnvironmentLinks getLinks() {
        return this._links;
    }

    public void setLinks(EnvironmentLinks _links) {
        this._links = _links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Environment environment = (Environment)o;
        return Objects.equals(this.id, environment.id) && Objects.equals(this.programId, environment.programId) && Objects.equals(this.name, environment.name) && Objects.equals(this.description, environment.description) && Objects.equals((Object)this.type, (Object)environment.type) && Objects.equals(this.availableLogOptions, environment.availableLogOptions) && Objects.equals(this._links, environment._links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.programId, this.name, this.description, this.type, this.availableLogOptions, this._links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Environment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    programId: ").append(this.toIndentedString(this.programId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    availableLogOptions: ").append(this.toIndentedString(this.availableLogOptions)).append("\n");
        sb.append("    _links: ").append(this.toIndentedString(this._links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        DEV("dev"),
        STAGE("stage"),
        PROD("prod");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

