/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="A representation of a specific metric generated by a CI/CD Pipeline step.")
public class Metric
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="severity")
    private SeverityEnum severity = null;
    @JsonProperty(value="passed")
    private Boolean passed = false;
    @JsonProperty(value="override")
    private Boolean override = false;
    @JsonProperty(value="actualValue")
    private String actualValue = null;
    @JsonProperty(value="expectedValue")
    private String expectedValue = null;
    @JsonProperty(value="comparator")
    private ComparatorEnum comparator = null;
    @JsonProperty(value="kpi")
    private String kpi = null;

    public Metric id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="KPI result identifier")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Metric severity(SeverityEnum severity) {
        this.severity = severity;
        return this;
    }

    @Schema(description="Severity of the metric")
    public SeverityEnum getSeverity() {
        return this.severity;
    }

    public void setSeverity(SeverityEnum severity) {
        this.severity = severity;
    }

    public Metric passed(Boolean passed) {
        this.passed = passed;
        return this;
    }

    @Schema(description="Whether metric is considered passed")
    public Boolean isPassed() {
        return this.passed;
    }

    public void setPassed(Boolean passed) {
        this.passed = passed;
    }

    public Metric override(Boolean override) {
        this.override = override;
        return this;
    }

    @Schema(description="Whether user override the failed metric")
    public Boolean isOverride() {
        return this.override;
    }

    public void setOverride(Boolean override) {
        this.override = override;
    }

    public Metric actualValue(String actualValue) {
        this.actualValue = actualValue;
        return this;
    }

    @Schema(description="Expected value for the metric")
    public String getActualValue() {
        return this.actualValue;
    }

    public void setActualValue(String actualValue) {
        this.actualValue = actualValue;
    }

    public Metric expectedValue(String expectedValue) {
        this.expectedValue = expectedValue;
        return this;
    }

    @Schema(description="Expected value for the metric")
    public String getExpectedValue() {
        return this.expectedValue;
    }

    public void setExpectedValue(String expectedValue) {
        this.expectedValue = expectedValue;
    }

    public Metric comparator(ComparatorEnum comparator) {
        this.comparator = comparator;
        return this;
    }

    @Schema(description="Comparator used for the metric")
    public ComparatorEnum getComparator() {
        return this.comparator;
    }

    public void setComparator(ComparatorEnum comparator) {
        this.comparator = comparator;
    }

    public Metric kpi(String kpi) {
        this.kpi = kpi;
        return this;
    }

    @Schema(description="KPI identifier")
    public String getKpi() {
        return this.kpi;
    }

    public void setKpi(String kpi) {
        this.kpi = kpi;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metric metric = (Metric)o;
        return Objects.equals(this.id, metric.id) && Objects.equals((Object)this.severity, (Object)metric.severity) && Objects.equals(this.passed, metric.passed) && Objects.equals(this.override, metric.override) && Objects.equals(this.actualValue, metric.actualValue) && Objects.equals(this.expectedValue, metric.expectedValue) && Objects.equals((Object)this.comparator, (Object)metric.comparator) && Objects.equals(this.kpi, metric.kpi);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.severity, this.passed, this.override, this.actualValue, this.expectedValue, this.comparator, this.kpi});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Metric {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString((Object)this.severity)).append("\n");
        sb.append("    passed: ").append(this.toIndentedString(this.passed)).append("\n");
        sb.append("    override: ").append(this.toIndentedString(this.override)).append("\n");
        sb.append("    actualValue: ").append(this.toIndentedString(this.actualValue)).append("\n");
        sb.append("    expectedValue: ").append(this.toIndentedString(this.expectedValue)).append("\n");
        sb.append("    comparator: ").append(this.toIndentedString((Object)this.comparator)).append("\n");
        sb.append("    kpi: ").append(this.toIndentedString(this.kpi)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ComparatorEnum {
        GT("GT"),
        GTE("GTE"),
        LT("LT"),
        LTE("LTE"),
        EQ("EQ"),
        NEQ("NEQ");

        private String value;

        private ComparatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ComparatorEnum fromValue(String text) {
            for (ComparatorEnum b : ComparatorEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum SeverityEnum {
        CRITICAL("critical"),
        IMPORTANT("important"),
        INFORMATIONAL("informational");

        private String value;

        private SeverityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SeverityEnum fromValue(String text) {
            for (SeverityEnum b : SeverityEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

