/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.adobe.cloudmanager.swagger.model.PipelineLinks;
import io.adobe.cloudmanager.swagger.model.PipelinePhase;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="A representation of a CI/CD Pipeline")
public class Pipeline
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="programId")
    private String programId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="trigger")
    private TriggerEnum trigger = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="createdAt")
    private DateTime createdAt = null;
    @JsonProperty(value="updatedAt")
    private DateTime updatedAt = null;
    @JsonProperty(value="lastStartedAt")
    private DateTime lastStartedAt = null;
    @JsonProperty(value="lastFinishedAt")
    private DateTime lastFinishedAt = null;
    @JsonProperty(value="phases")
    private List<PipelinePhase> phases = new ArrayList<PipelinePhase>();
    @JsonProperty(value="_links")
    private PipelineLinks _links = null;

    public Pipeline id(String id) {
        this.id = id;
        return this;
    }

    @Schema(example="29", description="Identifier of the pipeline. Unique within the program.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Pipeline programId(String programId) {
        this.programId = programId;
        return this;
    }

    @Schema(example="14", description="Identifier of the program. Unique within the space.")
    public String getProgramId() {
        return this.programId;
    }

    public void setProgramId(String programId) {
        this.programId = programId;
    }

    public Pipeline name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="AcmeCorp Main Pipeline", required=true, description="Name of the pipeline")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Pipeline trigger(TriggerEnum trigger) {
        this.trigger = trigger;
        return this;
    }

    @Schema(example="MANUAL", description="How should the execution be triggered. ON_COMMIT: each time one or more commits are pushed and the Pipeline is idle then a execution is triggered. MANUAL: triggerd through UI or API.")
    public TriggerEnum getTrigger() {
        return this.trigger;
    }

    public void setTrigger(TriggerEnum trigger) {
        this.trigger = trigger;
    }

    public Pipeline status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(example="RUNNING,FAILED", description="Pipeline status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @Schema(description="Create date")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @Schema(description="Update date")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Schema(description="Last pipeline execution start")
    public DateTime getLastStartedAt() {
        return this.lastStartedAt;
    }

    @Schema(description="Last pipeline execution end")
    public DateTime getLastFinishedAt() {
        return this.lastFinishedAt;
    }

    public Pipeline phases(List<PipelinePhase> phases) {
        this.phases = phases;
        return this;
    }

    public Pipeline addPhasesItem(PipelinePhase phasesItem) {
        this.phases.add(phasesItem);
        return this;
    }

    @Schema(required=true, description="Pipeline phases in execution order")
    public List<PipelinePhase> getPhases() {
        return this.phases;
    }

    public void setPhases(List<PipelinePhase> phases) {
        this.phases = phases;
    }

    public Pipeline _links(PipelineLinks _links) {
        this._links = _links;
        return this;
    }

    @Schema(description="")
    public PipelineLinks getLinks() {
        return this._links;
    }

    public void setLinks(PipelineLinks _links) {
        this._links = _links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pipeline pipeline = (Pipeline)o;
        return Objects.equals(this.id, pipeline.id) && Objects.equals(this.programId, pipeline.programId) && Objects.equals(this.name, pipeline.name) && Objects.equals((Object)this.trigger, (Object)pipeline.trigger) && Objects.equals((Object)this.status, (Object)pipeline.status) && Objects.equals(this.createdAt, pipeline.createdAt) && Objects.equals(this.updatedAt, pipeline.updatedAt) && Objects.equals(this.lastStartedAt, pipeline.lastStartedAt) && Objects.equals(this.lastFinishedAt, pipeline.lastFinishedAt) && Objects.equals(this.phases, pipeline.phases) && Objects.equals(this._links, pipeline._links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.programId, this.name, this.trigger, this.status, this.createdAt, this.updatedAt, this.lastStartedAt, this.lastFinishedAt, this.phases, this._links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pipeline {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    programId: ").append(this.toIndentedString(this.programId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    trigger: ").append(this.toIndentedString((Object)this.trigger)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    lastStartedAt: ").append(this.toIndentedString(this.lastStartedAt)).append("\n");
        sb.append("    lastFinishedAt: ").append(this.toIndentedString(this.lastFinishedAt)).append("\n");
        sb.append("    phases: ").append(this.toIndentedString(this.phases)).append("\n");
        sb.append("    _links: ").append(this.toIndentedString(this._links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        IDLE("IDLE"),
        BUSY("BUSY"),
        WAITING("WAITING");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TriggerEnum {
        ON_COMMIT("ON_COMMIT"),
        MANUAL("MANUAL");

        private String value;

        private TriggerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TriggerEnum fromValue(String text) {
            for (TriggerEnum b : TriggerEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

