/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.adobe.cloudmanager.swagger.model.PipelineExecutionEmbedded;
import io.adobe.cloudmanager.swagger.model.PipelineExecutionLinks;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="A representation of an execution of a CI/CD Pipeline.")
public class PipelineExecution
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="programId")
    private String programId = null;
    @JsonProperty(value="pipelineId")
    private String pipelineId = null;
    @JsonProperty(value="artifactsVersion")
    private String artifactsVersion = null;
    @JsonProperty(value="user")
    private String user = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="trigger")
    private TriggerEnum trigger = null;
    @JsonProperty(value="createdAt")
    private DateTime createdAt = null;
    @JsonProperty(value="updatedAt")
    private DateTime updatedAt = null;
    @JsonProperty(value="finishedAt")
    private DateTime finishedAt = null;
    @JsonProperty(value="_embedded")
    private PipelineExecutionEmbedded _embedded = null;
    @JsonProperty(value="_links")
    private PipelineExecutionLinks _links = null;

    public PipelineExecution id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Pipeline execution identifier")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Schema(example="14", description="Identifier of the program. Unique within the space.")
    public String getProgramId() {
        return this.programId;
    }

    @Schema(example="10", description="Identifier of the pipeline. Unique within the space.")
    public String getPipelineId() {
        return this.pipelineId;
    }

    public PipelineExecution artifactsVersion(String artifactsVersion) {
        this.artifactsVersion = artifactsVersion;
        return this;
    }

    @Schema(description="Version of the artifacts generated during this execution")
    public String getArtifactsVersion() {
        return this.artifactsVersion;
    }

    public void setArtifactsVersion(String artifactsVersion) {
        this.artifactsVersion = artifactsVersion;
    }

    public PipelineExecution user(String user) {
        this.user = user;
        return this;
    }

    @Schema(example="0123456789ABCDE@AdobeID", description="AdobeID who started the pipeline. Empty for auto triggered builds")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public PipelineExecution status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(description="Status of the execution")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public PipelineExecution trigger(TriggerEnum trigger) {
        this.trigger = trigger;
        return this;
    }

    @Schema(description="How the execution was triggered.")
    public TriggerEnum getTrigger() {
        return this.trigger;
    }

    public void setTrigger(TriggerEnum trigger) {
        this.trigger = trigger;
    }

    public PipelineExecution createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Start time")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public PipelineExecution updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="Date of last status change")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public PipelineExecution finishedAt(DateTime finishedAt) {
        this.finishedAt = finishedAt;
        return this;
    }

    @Schema(description="Date the execution reached a final state")
    public DateTime getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(DateTime finishedAt) {
        this.finishedAt = finishedAt;
    }

    public PipelineExecution _embedded(PipelineExecutionEmbedded _embedded) {
        this._embedded = _embedded;
        return this;
    }

    @Schema(description="")
    public PipelineExecutionEmbedded getEmbedded() {
        return this._embedded;
    }

    public void setEmbedded(PipelineExecutionEmbedded _embedded) {
        this._embedded = _embedded;
    }

    public PipelineExecution _links(PipelineExecutionLinks _links) {
        this._links = _links;
        return this;
    }

    @Schema(description="")
    public PipelineExecutionLinks getLinks() {
        return this._links;
    }

    public void setLinks(PipelineExecutionLinks _links) {
        this._links = _links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineExecution pipelineExecution = (PipelineExecution)o;
        return Objects.equals(this.id, pipelineExecution.id) && Objects.equals(this.programId, pipelineExecution.programId) && Objects.equals(this.pipelineId, pipelineExecution.pipelineId) && Objects.equals(this.artifactsVersion, pipelineExecution.artifactsVersion) && Objects.equals(this.user, pipelineExecution.user) && Objects.equals((Object)this.status, (Object)pipelineExecution.status) && Objects.equals((Object)this.trigger, (Object)pipelineExecution.trigger) && Objects.equals(this.createdAt, pipelineExecution.createdAt) && Objects.equals(this.updatedAt, pipelineExecution.updatedAt) && Objects.equals(this.finishedAt, pipelineExecution.finishedAt) && Objects.equals(this._embedded, pipelineExecution._embedded) && Objects.equals(this._links, pipelineExecution._links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.programId, this.pipelineId, this.artifactsVersion, this.user, this.status, this.trigger, this.createdAt, this.updatedAt, this.finishedAt, this._embedded, this._links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PipelineExecution {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    programId: ").append(this.toIndentedString(this.programId)).append("\n");
        sb.append("    pipelineId: ").append(this.toIndentedString(this.pipelineId)).append("\n");
        sb.append("    artifactsVersion: ").append(this.toIndentedString(this.artifactsVersion)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    trigger: ").append(this.toIndentedString((Object)this.trigger)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    finishedAt: ").append(this.toIndentedString(this.finishedAt)).append("\n");
        sb.append("    _embedded: ").append(this.toIndentedString(this._embedded)).append("\n");
        sb.append("    _links: ").append(this.toIndentedString(this._links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TriggerEnum {
        ON_COMMIT("ON_COMMIT"),
        MANUAL("MANUAL"),
        PUSH_UPGRADES("PUSH_UPGRADES");

        private String value;

        private TriggerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TriggerEnum fromValue(String text) {
            for (TriggerEnum b : TriggerEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum StatusEnum {
        NOT_STARTED("NOT_STARTED"),
        RUNNING("RUNNING"),
        CANCELLING("CANCELLING"),
        CANCELLED("CANCELLED"),
        FINISHED("FINISHED"),
        ERROR("ERROR"),
        FAILED("FAILED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

