/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.adobe.cloudmanager.swagger.model.PipelineExecutionStepStateLinks;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Describes the status of a particular pipeline execution step for display purposes")
public class PipelineExecutionStepState
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="stepId")
    private String stepId = null;
    @JsonProperty(value="phaseId")
    private String phaseId = null;
    @JsonProperty(value="action")
    private String action = null;
    @JsonProperty(value="repository")
    private String repository = null;
    @JsonProperty(value="branch")
    private String branch = null;
    @JsonProperty(value="environment")
    private String environment = null;
    @JsonProperty(value="environmentId")
    private String environmentId = null;
    @JsonProperty(value="environmentType")
    private String environmentType = null;
    @JsonProperty(value="startedAt")
    private DateTime startedAt = null;
    @JsonProperty(value="finishedAt")
    private DateTime finishedAt = null;
    @JsonProperty(value="details")
    private Map<String, Object> details = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="_links")
    private PipelineExecutionStepStateLinks _links = null;

    public PipelineExecutionStepState id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PipelineExecutionStepState stepId(String stepId) {
        this.stepId = stepId;
        return this;
    }

    @Schema(description="")
    public String getStepId() {
        return this.stepId;
    }

    public void setStepId(String stepId) {
        this.stepId = stepId;
    }

    public PipelineExecutionStepState phaseId(String phaseId) {
        this.phaseId = phaseId;
        return this;
    }

    @Schema(description="")
    public String getPhaseId() {
        return this.phaseId;
    }

    public void setPhaseId(String phaseId) {
        this.phaseId = phaseId;
    }

    public PipelineExecutionStepState action(String action) {
        this.action = action;
        return this;
    }

    @Schema(example="build", description="Name of the action")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public PipelineExecutionStepState repository(String repository) {
        this.repository = repository;
        return this;
    }

    @Schema(description="Target repository")
    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public PipelineExecutionStepState branch(String branch) {
        this.branch = branch;
        return this;
    }

    @Schema(description="Target branch")
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public PipelineExecutionStepState environment(String environment) {
        this.environment = environment;
        return this;
    }

    @Schema(description="Target environment")
    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public PipelineExecutionStepState environmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    @Schema(description="Target environment id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public PipelineExecutionStepState environmentType(String environmentType) {
        this.environmentType = environmentType;
        return this;
    }

    @Schema(description="Target environment type")
    public String getEnvironmentType() {
        return this.environmentType;
    }

    public void setEnvironmentType(String environmentType) {
        this.environmentType = environmentType;
    }

    public PipelineExecutionStepState startedAt(DateTime startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Schema(description="Start time")
    public DateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(DateTime startedAt) {
        this.startedAt = startedAt;
    }

    public PipelineExecutionStepState finishedAt(DateTime finishedAt) {
        this.finishedAt = finishedAt;
        return this;
    }

    @Schema(description="Date the execution reached a final state")
    public DateTime getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(DateTime finishedAt) {
        this.finishedAt = finishedAt;
    }

    public PipelineExecutionStepState details(Map<String, Object> details) {
        this.details = details;
        return this;
    }

    public PipelineExecutionStepState putDetailsItem(String key, Object detailsItem) {
        if (this.details == null) {
            this.details = new HashMap<String, Object>();
        }
        this.details.put(key, detailsItem);
        return this;
    }

    @Schema(example="scheduled time", description="Information about step result")
    public Map<String, Object> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, Object> details) {
        this.details = details;
    }

    public PipelineExecutionStepState status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(example="NOT_STARTED", description="Action status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public PipelineExecutionStepState _links(PipelineExecutionStepStateLinks _links) {
        this._links = _links;
        return this;
    }

    @Schema(description="")
    public PipelineExecutionStepStateLinks getLinks() {
        return this._links;
    }

    public void setLinks(PipelineExecutionStepStateLinks _links) {
        this._links = _links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineExecutionStepState pipelineExecutionStepState = (PipelineExecutionStepState)o;
        return Objects.equals(this.id, pipelineExecutionStepState.id) && Objects.equals(this.stepId, pipelineExecutionStepState.stepId) && Objects.equals(this.phaseId, pipelineExecutionStepState.phaseId) && Objects.equals(this.action, pipelineExecutionStepState.action) && Objects.equals(this.repository, pipelineExecutionStepState.repository) && Objects.equals(this.branch, pipelineExecutionStepState.branch) && Objects.equals(this.environment, pipelineExecutionStepState.environment) && Objects.equals(this.environmentId, pipelineExecutionStepState.environmentId) && Objects.equals(this.environmentType, pipelineExecutionStepState.environmentType) && Objects.equals(this.startedAt, pipelineExecutionStepState.startedAt) && Objects.equals(this.finishedAt, pipelineExecutionStepState.finishedAt) && Objects.equals(this.details, pipelineExecutionStepState.details) && Objects.equals((Object)this.status, (Object)pipelineExecutionStepState.status) && Objects.equals(this._links, pipelineExecutionStepState._links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.stepId, this.phaseId, this.action, this.repository, this.branch, this.environment, this.environmentId, this.environmentType, this.startedAt, this.finishedAt, this.details, this.status, this._links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PipelineExecutionStepState {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    stepId: ").append(this.toIndentedString(this.stepId)).append("\n");
        sb.append("    phaseId: ").append(this.toIndentedString(this.phaseId)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    repository: ").append(this.toIndentedString(this.repository)).append("\n");
        sb.append("    branch: ").append(this.toIndentedString(this.branch)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    environmentId: ").append(this.toIndentedString(this.environmentId)).append("\n");
        sb.append("    environmentType: ").append(this.toIndentedString(this.environmentType)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    finishedAt: ").append(this.toIndentedString(this.finishedAt)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    _links: ").append(this.toIndentedString(this._links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        NOT_STARTED("NOT_STARTED"),
        RUNNING("RUNNING"),
        FINISHED("FINISHED"),
        ERROR("ERROR"),
        ROLLING_BACK("ROLLING_BACK"),
        ROLLED_BACK("ROLLED_BACK"),
        WAITING("WAITING"),
        CANCELLED("CANCELLED"),
        FAILED("FAILED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

