/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="Describes a phase of a pipeline")
public class PipelinePhase
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="repositoryId")
    private String repositoryId = null;
    @JsonProperty(value="branch")
    private String branch = null;
    @JsonProperty(value="environmentId")
    private String environmentId = null;

    public PipelinePhase name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="DEV Build", description="Name of the phase")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PipelinePhase type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(example="DEPLOY", required=true, description="Type of the phase")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PipelinePhase repositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
        return this;
    }

    @Schema(description="Identifier of the source repository. The code from this repository will be build at the start of this phase.  Mandatory if type=BUILD")
    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public PipelinePhase branch(String branch) {
        this.branch = branch;
        return this;
    }

    @Schema(description="Name of the tracked branch or a fully qualified git tag (e.g. refs/tags/v1).   Assumed to be `master` if missing.")
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public PipelinePhase environmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    @Schema(description="Identifier of the target environment. Mandatory if type=DEPLOY")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelinePhase pipelinePhase = (PipelinePhase)o;
        return Objects.equals(this.name, pipelinePhase.name) && Objects.equals((Object)this.type, (Object)pipelinePhase.type) && Objects.equals(this.repositoryId, pipelinePhase.repositoryId) && Objects.equals(this.branch, pipelinePhase.branch) && Objects.equals(this.environmentId, pipelinePhase.environmentId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.repositoryId, this.branch, this.environmentId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PipelinePhase {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    repositoryId: ").append(this.toIndentedString(this.repositoryId)).append("\n");
        sb.append("    branch: ").append(this.toIndentedString(this.branch)).append("\n");
        sb.append("    environmentId: ").append(this.toIndentedString(this.environmentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        VALIDATE("VALIDATE"),
        BUILD("BUILD"),
        DEPLOY("DEPLOY");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

