/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.adobe.cloudmanager.swagger.model.ProgramLinks;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="A representation of a Program")
public class Program
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = false;
    @JsonProperty(value="tenantId")
    private String tenantId = null;
    @JsonProperty(value="imsOrgId")
    private String imsOrgId = null;
    @JsonProperty(value="_links")
    private ProgramLinks _links = null;

    public Program id(String id) {
        this.id = id;
        return this;
    }

    @Schema(example="14", description="Identifier of the program. Unique within the space.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Program name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="AcmeCorp Main Site", required=true, description="Name of the program")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Program enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(description="Whether this Program has been enabled for Cloud Manager usage")
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Program tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(example="acmeCorp", description="Tenant Id")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Program imsOrgId(String imsOrgId) {
        this.imsOrgId = imsOrgId;
        return this;
    }

    @Schema(example="6522A55453334E247F120101@AdobeOrg", description="Organisation Id")
    public String getImsOrgId() {
        return this.imsOrgId;
    }

    public void setImsOrgId(String imsOrgId) {
        this.imsOrgId = imsOrgId;
    }

    public Program _links(ProgramLinks _links) {
        this._links = _links;
        return this;
    }

    @Schema(description="")
    public ProgramLinks getLinks() {
        return this._links;
    }

    public void setLinks(ProgramLinks _links) {
        this._links = _links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Program program = (Program)o;
        return Objects.equals(this.id, program.id) && Objects.equals(this.name, program.name) && Objects.equals(this.enabled, program.enabled) && Objects.equals(this.tenantId, program.tenantId) && Objects.equals(this.imsOrgId, program.imsOrgId) && Objects.equals(this._links, program._links);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.enabled, this.tenantId, this.imsOrgId, this._links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Program {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    imsOrgId: ").append(this.toIndentedString(this.imsOrgId)).append("\n");
        sb.append("    _links: ").append(this.toIndentedString(this._links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

