/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.swagger.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="A named value than can be set on an Environment or Pipeline")
public class Variable
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="value")
    private String value = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;

    public Variable name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="MY_VAR1", description="Name of the variable. Of a-z, A-Z, _ and 0-9 Cannot begin with a number.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Variable value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="myValue", description="Value of the variable. Read-Write for non-secrets, write-only for secrets.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Variable type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(example="string", description="Type of the variable. Default `string` if missing. `secretString` variables are encrypted at rest. The type of a variable be changed after creation; the variable must be deleted and recreated.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variable variable = (Variable)o;
        return Objects.equals(this.name, variable.name) && Objects.equals(this.value, variable.value) && Objects.equals((Object)this.type, (Object)variable.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.value, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Variable {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        STRING("string"),
        SECRETSTRING("secretString");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

