/*
 * Decompiled with CFR 0.152.
 */
package io.adobe.cloudmanager.util;

import io.adobe.cloudmanager.model.Pipeline;
import io.adobe.cloudmanager.swagger.model.Metric;
import io.adobe.cloudmanager.swagger.model.Pipeline;
import io.adobe.cloudmanager.swagger.model.PipelineExecutionStepState;
import java.util.function.Predicate;

public class Predicates {
    public static final Predicate<Pipeline> IS_BUSY = pipeline -> Pipeline.StatusEnum.BUSY == pipeline.getStatus();
    public static final Predicate<PipelineExecutionStepState> IS_CURRENT = stepState -> stepState.getStatus() != PipelineExecutionStepState.StatusEnum.FINISHED;
    public static final Predicate<PipelineExecutionStepState> IS_WAITING = stepState -> stepState.getStatus() == PipelineExecutionStepState.StatusEnum.WAITING;
    public static final Predicate<Metric> PASSED = Metric::isPassed;
    public static final Predicate<Metric> FAILED = m -> m.isPassed() == false;
    public static final Predicate<Metric> CRITICAL = m -> Metric.SeverityEnum.CRITICAL.equals((Object)m.getSeverity());
    public static final Predicate<Metric> IMPORTANT = m -> Metric.SeverityEnum.IMPORTANT.equals((Object)m.getSeverity());
}

