/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.status.AtomicCounter;

public class AeronClient
implements DriverManagedResource {
    private final long clientId;
    private final long clientLivenessTimeoutMs;
    private final AtomicCounter clientTimeouts;
    private final AtomicCounter heartbeatTimestamp;
    private boolean reachedEndOfLife = false;
    private boolean closedByCommand = false;

    public AeronClient(long clientId, long clientLivenessTimeoutNs, long nowMs, AtomicCounter clientTimeouts, AtomicCounter heartbeatTimestamp) {
        this.clientId = clientId;
        this.clientLivenessTimeoutMs = Math.max(1L, TimeUnit.NANOSECONDS.toMillis(clientLivenessTimeoutNs));
        this.clientTimeouts = clientTimeouts;
        this.heartbeatTimestamp = heartbeatTimestamp;
        heartbeatTimestamp.setOrdered(nowMs);
    }

    @Override
    public void close() {
        if (!this.heartbeatTimestamp.isClosed()) {
            this.heartbeatTimestamp.close();
        }
    }

    public long clientId() {
        return this.clientId;
    }

    public void timeOfLastKeepaliveMs(long nowMs) {
        this.heartbeatTimestamp.setOrdered(nowMs);
    }

    public boolean hasTimedOut() {
        return this.reachedEndOfLife;
    }

    @Override
    public void onTimeEvent(long timeNs, long timeMs, DriverConductor conductor) {
        if (timeMs > this.heartbeatTimestamp.get() + this.clientLivenessTimeoutMs) {
            this.reachedEndOfLife = true;
            if (!this.closedByCommand) {
                this.clientTimeouts.incrementOrdered();
                conductor.clientTimeout(this.clientId);
            }
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    void onClosedByCommand() {
        this.closedByCommand = true;
        this.heartbeatTimestamp.set(0L);
    }
}

