/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.CongestionControl;
import io.aeron.driver.CongestionControlSupplier;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.StaticWindowCongestionControl;
import io.aeron.driver.ext.CubicCongestionControl;
import io.aeron.driver.media.UdpChannel;
import java.net.InetSocketAddress;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.status.CountersManager;

public class DefaultCongestionControlSupplier
implements CongestionControlSupplier {
    @Override
    public CongestionControl newInstance(long registrationId, UdpChannel udpChannel, int streamId, int sessionId, int termLength, int senderMtuLength, InetSocketAddress controlAddress, InetSocketAddress sourceAddress, NanoClock nanoClock, MediaDriver.Context context, CountersManager countersManager) {
        String ccStr = udpChannel.channelUri().get("cc");
        if (null == ccStr || "static".equals(ccStr)) {
            return new StaticWindowCongestionControl(registrationId, udpChannel, streamId, sessionId, termLength, senderMtuLength, controlAddress, sourceAddress, nanoClock, context, countersManager);
        }
        if ("cubic".equals(ccStr)) {
            return new CubicCongestionControl(registrationId, udpChannel, streamId, sessionId, termLength, senderMtuLength, controlAddress, sourceAddress, nanoClock, context, countersManager);
        }
        throw new IllegalArgumentException("unsupported congestion control : cc=" + ccStr);
    }
}

