/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.ErrorCode;
import io.aeron.driver.AeronClient;
import io.aeron.driver.ClientCommandAdapter;
import io.aeron.driver.ClientProxy;
import io.aeron.driver.Configuration;
import io.aeron.driver.CongestionControl;
import io.aeron.driver.CounterLink;
import io.aeron.driver.DataPacketDispatcher;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.FlowControl;
import io.aeron.driver.IpcPublication;
import io.aeron.driver.IpcSubscriptionLink;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.NetworkPublicationThreadLocals;
import io.aeron.driver.NetworkSubscriptionLink;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.PublicationLink;
import io.aeron.driver.PublicationParams;
import io.aeron.driver.ReceiverProxy;
import io.aeron.driver.RetransmitHandler;
import io.aeron.driver.SenderProxy;
import io.aeron.driver.SpySubscriptionLink;
import io.aeron.driver.SubscriberPosition;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.SubscriptionParams;
import io.aeron.driver.buffer.LogFactory;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationUdpTransport;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.status.ClientHeartbeatTimestamp;
import io.aeron.driver.status.PublisherLimit;
import io.aeron.driver.status.PublisherPos;
import io.aeron.driver.status.ReceiveChannelStatus;
import io.aeron.driver.status.ReceiverHwm;
import io.aeron.driver.status.ReceiverPos;
import io.aeron.driver.status.SendChannelStatus;
import io.aeron.driver.status.SenderBpe;
import io.aeron.driver.status.SenderLimit;
import io.aeron.driver.status.SenderPos;
import io.aeron.driver.status.SubscriberPos;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.exceptions.ControlProtocolException;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.Object2ObjectHashMap;
import org.agrona.collections.ObjectHashSet;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.CachedEpochClock;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;
import org.agrona.concurrent.status.UnsafeBufferPosition;

public class DriverConductor
implements Agent {
    private static final long CLOCK_UPDATE_DURATION_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    private int nextSessionId = BitUtil.generateRandomisedId();
    private final long timerIntervalNs;
    private final long clientLivenessTimeoutNs;
    private final long statusMessageTimeoutNs;
    private long timeOfLastToDriverPositionChangeNs;
    private long lastConsumerCommandPosition;
    private long timeOfLastTimerCheckNs;
    private long clockUpdateDeadlineNs;
    private final MediaDriver.Context ctx;
    private final LogFactory logFactory;
    private final ReceiverProxy receiverProxy;
    private final SenderProxy senderProxy;
    private final ClientProxy clientProxy;
    private final RingBuffer toDriverCommands;
    private final ClientCommandAdapter clientCommandAdapter;
    private final ManyToOneConcurrentArrayQueue<Runnable> driverCmdQueue;
    private final Object2ObjectHashMap<String, SendChannelEndpoint> sendChannelEndpointByChannelMap = new Object2ObjectHashMap();
    private final Object2ObjectHashMap<String, ReceiveChannelEndpoint> receiveChannelEndpointByChannelMap = new Object2ObjectHashMap();
    private final ArrayList<NetworkPublication> networkPublications = new ArrayList();
    private final ArrayList<IpcPublication> ipcPublications = new ArrayList();
    private final ArrayList<PublicationImage> publicationImages = new ArrayList();
    private final ArrayList<PublicationLink> publicationLinks = new ArrayList();
    private final ArrayList<SubscriptionLink> subscriptionLinks = new ArrayList();
    private final ArrayList<CounterLink> counterLinks = new ArrayList();
    private final ArrayList<AeronClient> clients = new ArrayList();
    private final ObjectHashSet<SessionKey> activeSessionSet = new ObjectHashSet();
    private final EpochClock epochClock;
    private final NanoClock nanoClock;
    private final CachedEpochClock cachedEpochClock;
    private final CachedNanoClock cachedNanoClock;
    private final CountersManager countersManager;
    private final NetworkPublicationThreadLocals networkPublicationThreadLocals = new NetworkPublicationThreadLocals();
    private final MutableDirectBuffer tempBuffer;
    private final DataHeaderFlyweight defaultDataHeader = new DataHeaderFlyweight(DataHeaderFlyweight.createDefaultHeader((int)0, (int)0, (int)0));

    public DriverConductor(MediaDriver.Context ctx) {
        this.ctx = ctx;
        this.timerIntervalNs = ctx.timerIntervalNs();
        this.clientLivenessTimeoutNs = ctx.clientLivenessTimeoutNs();
        this.statusMessageTimeoutNs = ctx.statusMessageTimeoutNs();
        this.driverCmdQueue = ctx.driverCommandQueue();
        this.receiverProxy = ctx.receiverProxy();
        this.senderProxy = ctx.senderProxy();
        this.logFactory = ctx.logFactory();
        this.epochClock = ctx.epochClock();
        this.nanoClock = ctx.nanoClock();
        this.cachedEpochClock = ctx.cachedEpochClock();
        this.cachedNanoClock = ctx.cachedNanoClock();
        this.toDriverCommands = ctx.toDriverCommands();
        this.clientProxy = ctx.clientProxy();
        this.tempBuffer = ctx.tempBuffer();
        this.countersManager = ctx.countersManager();
        this.clientCommandAdapter = new ClientCommandAdapter(ctx.systemCounters().get(SystemCounterDescriptor.ERRORS), ctx.errorHandler(), this.toDriverCommands, this.clientProxy, this);
        long nowNs = this.nanoClock.nanoTime();
        this.cachedNanoClock.update(nowNs);
        this.cachedEpochClock.update(this.epochClock.time());
        this.timeOfLastTimerCheckNs = nowNs;
        this.timeOfLastToDriverPositionChangeNs = nowNs;
        this.lastConsumerCommandPosition = this.toDriverCommands.consumerPosition();
    }

    public void onClose() {
        this.publicationImages.forEach(PublicationImage::free);
        this.networkPublications.forEach(NetworkPublication::free);
        this.ipcPublications.forEach(IpcPublication::free);
        this.ctx.close();
    }

    public String roleName() {
        return "driver-conductor";
    }

    public int doWork() {
        int workCount = 0;
        long nowNs = this.nanoClock.nanoTime();
        this.updateClocks(nowNs);
        workCount += this.processTimers(nowNs);
        workCount += this.clientCommandAdapter.receive();
        workCount += this.driverCmdQueue.drain(Runnable::run, 10);
        ArrayList<PublicationImage> publicationImages = this.publicationImages;
        int size = publicationImages.size();
        for (int i = 0; i < size; ++i) {
            PublicationImage image = publicationImages.get(i);
            if (!image.isTrackingRebuild()) continue;
            image.trackRebuild(nowNs, this.statusMessageTimeoutNs);
        }
        ArrayList<NetworkPublication> networkPublications = this.networkPublications;
        int size2 = networkPublications.size();
        for (int i = 0; i < size2; ++i) {
            NetworkPublication publication = networkPublications.get(i);
            if (publication.state() != NetworkPublication.State.ACTIVE) continue;
            workCount += publication.updatePublisherLimit();
        }
        ArrayList<IpcPublication> ipcPublications = this.ipcPublications;
        int size3 = ipcPublications.size();
        for (int i = 0; i < size3; ++i) {
            IpcPublication publication = ipcPublications.get(i);
            if (publication.state() != IpcPublication.State.ACTIVE) continue;
            workCount += publication.updatePublisherLimit();
        }
        return workCount;
    }

    public void onCreatePublicationImage(int sessionId, int streamId, int initialTermId, int activeTermId, int initialTermOffset, int termBufferLength, int senderMtuLength, int transportIndex, InetSocketAddress controlAddress, InetSocketAddress sourceAddress, ReceiveChannelEndpoint channelEndpoint) {
        Configuration.validateMtuLength(senderMtuLength);
        Configuration.validateInitialWindowLength(this.ctx.initialWindowLength(), senderMtuLength);
        long joinPosition = LogBufferDescriptor.computePosition((int)activeTermId, (int)initialTermOffset, (int)LogBufferDescriptor.positionBitsToShift((int)termBufferLength), (int)initialTermId);
        ArrayList<SubscriberPosition> subscriberPositions = this.createSubscriberPositions(sessionId, streamId, channelEndpoint, joinPosition);
        if (subscriberPositions.size() > 0) {
            UdpChannel udpChannel = channelEndpoint.udpChannel();
            String channel = udpChannel.originalUriString();
            long registrationId = this.toDriverCommands.nextCorrelationId();
            RawLog rawLog = this.newPublicationImageLog(sessionId, streamId, initialTermId, termBufferLength, DriverConductor.isOldestSubscriptionSparse(subscriberPositions), senderMtuLength, udpChannel, registrationId);
            CongestionControl congestionControl = this.ctx.congestionControlSupplier().newInstance(registrationId, udpChannel, streamId, sessionId, termBufferLength, senderMtuLength, controlAddress, sourceAddress, (NanoClock)this.cachedNanoClock, this.ctx, this.countersManager);
            CommonContext.InferableBoolean groupSubscription = subscriberPositions.get(0).subscription().group();
            boolean treatAsMulticast = groupSubscription == CommonContext.InferableBoolean.INFER ? udpChannel.isMulticast() : groupSubscription == CommonContext.InferableBoolean.FORCE_TRUE;
            FeedbackDelayGenerator feedbackDelayGenerator = treatAsMulticast ? this.ctx.multicastFeedbackDelayGenerator() : this.ctx.unicastFeedbackDelayGenerator();
            PublicationImage image = new PublicationImage(registrationId, this.ctx.imageLivenessTimeoutNs(), this.ctx.untetheredWindowLimitTimeoutNs(), this.ctx.untetheredRestingTimeoutNs(), channelEndpoint, transportIndex, controlAddress, sessionId, streamId, initialTermId, activeTermId, initialTermOffset, rawLog, feedbackDelayGenerator, subscriberPositions, (Position)ReceiverHwm.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel), (Position)ReceiverPos.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel), this.nanoClock, (NanoClock)this.cachedNanoClock, (EpochClock)this.cachedEpochClock, this.ctx.systemCounters(), sourceAddress, congestionControl, this.ctx.lossReport());
            this.publicationImages.add(image);
            this.receiverProxy.newPublicationImage(channelEndpoint, image);
            String sourceIdentity = Configuration.sourceIdentity(sourceAddress);
            int size = subscriberPositions.size();
            for (int i = 0; i < size; ++i) {
                SubscriberPosition position = subscriberPositions.get(i);
                position.addLink(image);
                this.clientProxy.onAvailableImage(registrationId, streamId, sessionId, position.subscription().registrationId(), position.positionCounterId(), rawLog.fileName(), sourceIdentity);
            }
        }
    }

    void onChannelEndpointError(long statusIndicatorId, Exception error) {
        String errorMessage = error.getClass().getSimpleName() + " : " + error.getMessage();
        this.clientProxy.onError(statusIndicatorId, ErrorCode.CHANNEL_ENDPOINT_ERROR, errorMessage);
    }

    void closeChannelEndpoints() {
        this.receiveChannelEndpointByChannelMap.values().forEach(UdpChannelTransport::close);
        this.sendChannelEndpointByChannelMap.values().forEach(UdpChannelTransport::close);
    }

    SendChannelEndpoint senderChannelEndpoint(UdpChannel channel) {
        return (SendChannelEndpoint)this.sendChannelEndpointByChannelMap.get((Object)channel.canonicalForm());
    }

    ReceiveChannelEndpoint receiverChannelEndpoint(UdpChannel channel) {
        return (ReceiveChannelEndpoint)this.receiveChannelEndpointByChannelMap.get((Object)channel.canonicalForm());
    }

    IpcPublication getSharedIpcPublication(long streamId) {
        return DriverConductor.findSharedIpcPublication(this.ipcPublications, streamId);
    }

    IpcPublication getIpcPublication(long registrationId) {
        int size = this.ipcPublications.size();
        for (int i = 0; i < size; ++i) {
            IpcPublication publication = this.ipcPublications.get(i);
            if (publication.registrationId() != registrationId) continue;
            return publication;
        }
        return null;
    }

    NetworkPublication findNetworkPublicationByTag(long tag) {
        int size = this.networkPublications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            long publicationTag = publication.tag();
            if (publicationTag != tag || publicationTag == -1L) continue;
            return publication;
        }
        return null;
    }

    IpcPublication findIpcPublicationByTag(long tag) {
        int size = this.ipcPublications.size();
        for (int i = 0; i < size; ++i) {
            IpcPublication publication = this.ipcPublications.get(i);
            long publicationTag = publication.tag();
            if (publicationTag != tag || publicationTag == -1L) continue;
            return publication;
        }
        return null;
    }

    void onAddNetworkPublication(String channel, int streamId, long correlationId, long clientId, boolean isExclusive) {
        UdpChannel udpChannel = UdpChannel.parse(channel);
        ChannelUri channelUri = udpChannel.channelUri();
        PublicationParams params = PublicationParams.getPublicationParams(this.ctx, channelUri, this, isExclusive, false);
        PublicationParams.validateMtuForMaxMessage(params);
        SendChannelEndpoint channelEndpoint = this.getOrCreateSendChannelEndpoint(udpChannel);
        NetworkPublication publication = null;
        if (!isExclusive) {
            publication = DriverConductor.findPublication(this.networkPublications, streamId, channelEndpoint);
        }
        if (null == publication) {
            if (params.hasSessionId) {
                this.checkForSessionClash(params.sessionId, streamId, udpChannel.canonicalForm());
            }
            publication = this.newNetworkPublication(correlationId, streamId, channel, udpChannel, channelEndpoint, params, isExclusive);
        } else {
            PublicationParams.confirmMatch(channelUri, params, publication.rawLog(), publication.sessionId());
        }
        this.publicationLinks.add(new PublicationLink(correlationId, this.getOrAddClient(clientId), publication));
        this.clientProxy.onPublicationReady(correlationId, publication.registrationId(), streamId, publication.sessionId(), publication.rawLog().fileName(), publication.publisherLimitId(), channelEndpoint.statusIndicatorCounterId(), isExclusive);
    }

    void cleanupSpies(NetworkPublication publication) {
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink link = this.subscriptionLinks.get(i);
            if (!link.isLinked(publication)) continue;
            this.clientProxy.onUnavailableImage(publication.registrationId(), link.registrationId(), publication.streamId(), publication.channel());
            this.subscriptionLinks.get(i).unlink(publication);
        }
    }

    void notifyUnavailableImageLink(long resourceId, SubscriptionLink link) {
        this.clientProxy.onUnavailableImage(resourceId, link.registrationId(), link.streamId(), link.channel());
    }

    void notifyAvailableImageLink(long resourceId, int sessionId, SubscriptionLink link, int positionCounterId, long joinPosition, String logFileName, String sourceIdentity) {
        this.countersManager.setCounterValue(positionCounterId, joinPosition);
        int streamId = link.streamId();
        this.clientProxy.onAvailableImage(resourceId, streamId, sessionId, link.registrationId(), positionCounterId, logFileName, sourceIdentity);
    }

    void cleanupPublication(NetworkPublication publication) {
        String channel = publication.channelEndpoint().udpChannel().canonicalForm();
        this.activeSessionSet.remove((Object)new SessionKey(publication.sessionId(), publication.streamId(), channel));
        this.senderProxy.removeNetworkPublication(publication);
        SendChannelEndpoint channelEndpoint = publication.channelEndpoint();
        if (channelEndpoint.shouldBeClosed()) {
            channelEndpoint.closeStatusIndicator();
            this.sendChannelEndpointByChannelMap.remove((Object)channelEndpoint.udpChannel().canonicalForm());
            this.senderProxy.closeSendChannelEndpoint(channelEndpoint);
        }
    }

    void cleanupSubscriptionLink(SubscriptionLink subscription) {
        ReceiveChannelEndpoint channelEndpoint = subscription.channelEndpoint();
        if (null != channelEndpoint) {
            if (subscription.hasSessionId()) {
                if (0L == channelEndpoint.decRefToStreamAndSession(subscription.streamId(), subscription.sessionId())) {
                    this.receiverProxy.removeSubscription(channelEndpoint, subscription.streamId());
                }
            } else if (0 == channelEndpoint.decRefToStream(subscription.streamId())) {
                this.receiverProxy.removeSubscription(channelEndpoint, subscription.streamId());
            }
            if (channelEndpoint.shouldBeClosed()) {
                channelEndpoint.closeStatusIndicator();
                this.receiveChannelEndpointByChannelMap.remove((Object)channelEndpoint.udpChannel().canonicalForm());
                this.receiverProxy.closeReceiveChannelEndpoint(channelEndpoint);
            }
        }
    }

    void transitionToLinger(PublicationImage image) {
        boolean rejoin = true;
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink link = this.subscriptionLinks.get(i);
            if (!link.isLinked(image)) continue;
            rejoin = link.isRejoin();
            this.clientProxy.onUnavailableImage(image.correlationId(), link.registrationId(), image.streamId(), image.channel());
        }
        if (rejoin) {
            this.receiverProxy.removeCoolDown(image.channelEndpoint(), image.sessionId(), image.streamId());
        }
    }

    void transitionToLinger(IpcPublication publication) {
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink link = this.subscriptionLinks.get(i);
            if (!link.isLinked(publication)) continue;
            this.clientProxy.onUnavailableImage(publication.registrationId(), link.registrationId(), publication.streamId(), "aeron:ipc");
        }
    }

    void cleanupImage(PublicationImage image) {
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            this.subscriptionLinks.get(i).unlink(image);
        }
    }

    void cleanupIpcPublication(IpcPublication publication) {
        this.activeSessionSet.remove((Object)new SessionKey(publication.sessionId(), publication.streamId(), "ipc"));
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            this.subscriptionLinks.get(i).unlink(publication);
        }
    }

    void clientTimeout(long clientId) {
        this.clientProxy.onClientTimeout(clientId);
    }

    void onAddIpcPublication(String channel, int streamId, long correlationId, long clientId, boolean isExclusive) {
        IpcPublication ipcPublication = this.getOrAddIpcPublication(correlationId, streamId, channel, isExclusive);
        this.publicationLinks.add(new PublicationLink(correlationId, this.getOrAddClient(clientId), ipcPublication));
        ArrayList<SubscriberPosition> subscriberPositions = this.linkIpcSubscriptions(ipcPublication);
        this.clientProxy.onPublicationReady(correlationId, ipcPublication.registrationId(), streamId, ipcPublication.sessionId(), ipcPublication.rawLog().fileName(), ipcPublication.publisherLimitId(), -1, isExclusive);
        int size = subscriberPositions.size();
        for (int i = 0; i < size; ++i) {
            SubscriberPosition subscriberPosition = subscriberPositions.get(i);
            this.clientProxy.onAvailableImage(ipcPublication.registrationId(), streamId, ipcPublication.sessionId(), subscriberPosition.subscription().registrationId, subscriberPosition.position().id(), ipcPublication.rawLog().fileName(), channel);
        }
    }

    void onRemovePublication(long registrationId, long correlationId) {
        PublicationLink publicationLink = null;
        ArrayList<PublicationLink> publicationLinks = this.publicationLinks;
        int size = publicationLinks.size();
        for (int i = 0; i < size; ++i) {
            PublicationLink publication = publicationLinks.get(i);
            if (registrationId != publication.registrationId()) continue;
            publicationLink = publication;
            ArrayListUtil.fastUnorderedRemove(publicationLinks, (int)i);
            break;
        }
        if (null == publicationLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "unknown publication: " + registrationId);
        }
        publicationLink.close();
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onAddSendDestination(long registrationId, String destinationChannel, long correlationId) {
        SendChannelEndpoint sendChannelEndpoint = null;
        int size = this.networkPublications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            if (registrationId != publication.registrationId()) continue;
            sendChannelEndpoint = publication.channelEndpoint();
            break;
        }
        if (null == sendChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "unknown publication: " + registrationId);
        }
        sendChannelEndpoint.validateAllowsManualControl();
        ChannelUri channelUri = ChannelUri.parse((CharSequence)destinationChannel);
        InetSocketAddress dstAddress = UdpChannel.destinationAddress(channelUri);
        this.senderProxy.addDestination(sendChannelEndpoint, dstAddress);
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onRemoveSendDestination(long registrationId, String destinationChannel, long correlationId) {
        SendChannelEndpoint sendChannelEndpoint = null;
        int size = this.networkPublications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            if (registrationId != publication.registrationId()) continue;
            sendChannelEndpoint = publication.channelEndpoint();
            break;
        }
        if (null == sendChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "unknown publication: " + registrationId);
        }
        sendChannelEndpoint.validateAllowsManualControl();
        ChannelUri channelUri = ChannelUri.parse((CharSequence)destinationChannel);
        InetSocketAddress dstAddress = UdpChannel.destinationAddress(channelUri);
        this.senderProxy.removeDestination(sendChannelEndpoint, dstAddress);
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onAddNetworkSubscription(String channel, int streamId, long registrationId, long clientId) {
        UdpChannel udpChannel = UdpChannel.parse(channel);
        SubscriptionParams params = SubscriptionParams.getSubscriptionParams(udpChannel.channelUri(), this.ctx);
        this.checkForClashingSubscription(params, udpChannel, streamId);
        ReceiveChannelEndpoint channelEndpoint = this.getOrCreateReceiveChannelEndpoint(udpChannel);
        if (params.hasSessionId) {
            if (1L == channelEndpoint.incRefToStreamAndSession(streamId, params.sessionId)) {
                this.receiverProxy.addSubscription(channelEndpoint, streamId, params.sessionId);
            }
        } else if (1 == channelEndpoint.incRefToStream(streamId)) {
            this.receiverProxy.addSubscription(channelEndpoint, streamId);
        }
        AeronClient client = this.getOrAddClient(clientId);
        NetworkSubscriptionLink subscription = new NetworkSubscriptionLink(registrationId, channelEndpoint, streamId, channel, client, params);
        this.subscriptionLinks.add(subscription);
        this.clientProxy.onSubscriptionReady(registrationId, channelEndpoint.statusIndicatorCounterId());
        this.linkMatchingImages(subscription);
    }

    void onAddIpcSubscription(String channel, int streamId, long registrationId, long clientId) {
        int i;
        SubscriptionParams params = SubscriptionParams.getSubscriptionParams(ChannelUri.parse((CharSequence)channel), this.ctx);
        IpcSubscriptionLink subscriptionLink = new IpcSubscriptionLink(registrationId, streamId, channel, this.getOrAddClient(clientId), params);
        ArrayList<SubscriberPosition> subscriberPositions = new ArrayList<SubscriberPosition>();
        this.subscriptionLinks.add(subscriptionLink);
        int size = this.ipcPublications.size();
        for (i = 0; i < size; ++i) {
            IpcPublication publication = this.ipcPublications.get(i);
            if (IpcPublication.State.ACTIVE != publication.state() || !subscriptionLink.matches(publication)) continue;
            Position subPos = this.linkIpcSubscription(publication, subscriptionLink);
            subscriberPositions.add(new SubscriberPosition(subscriptionLink, publication, subPos));
        }
        this.clientProxy.onSubscriptionReady(registrationId, -1);
        size = subscriberPositions.size();
        for (i = 0; i < size; ++i) {
            SubscriberPosition subscriberPosition = (SubscriberPosition)subscriberPositions.get(i);
            IpcPublication publication = (IpcPublication)subscriberPosition.subscribable();
            this.clientProxy.onAvailableImage(publication.registrationId(), streamId, publication.sessionId(), registrationId, subscriberPosition.position().id(), publication.rawLog().fileName(), channel);
        }
    }

    void onAddSpySubscription(String channel, int streamId, long registrationId, long clientId) {
        int i;
        UdpChannel udpChannel = UdpChannel.parse(channel);
        AeronClient client = this.getOrAddClient(clientId);
        SubscriptionParams params = SubscriptionParams.getSubscriptionParams(udpChannel.channelUri(), this.ctx);
        ArrayList<SubscriberPosition> subscriberPositions = new ArrayList<SubscriberPosition>();
        SpySubscriptionLink subscriptionLink = new SpySubscriptionLink(registrationId, udpChannel, streamId, client, params);
        this.subscriptionLinks.add(subscriptionLink);
        int size = this.networkPublications.size();
        for (i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            if (NetworkPublication.State.ACTIVE != publication.state() || !subscriptionLink.matches(publication)) continue;
            Position subPos = this.linkSpy(publication, subscriptionLink);
            subscriberPositions.add(new SubscriberPosition(subscriptionLink, publication, subPos));
        }
        this.clientProxy.onSubscriptionReady(registrationId, -1);
        size = subscriberPositions.size();
        for (i = 0; i < size; ++i) {
            SubscriberPosition subscriberPosition = (SubscriberPosition)subscriberPositions.get(i);
            NetworkPublication publication = (NetworkPublication)subscriberPosition.subscribable();
            this.clientProxy.onAvailableImage(publication.registrationId(), streamId, publication.sessionId(), registrationId, subscriberPosition.position().id(), publication.rawLog().fileName(), "aeron:ipc");
        }
    }

    void onRemoveSubscription(long registrationId, long correlationId) {
        SubscriptionLink subscription = DriverConductor.removeSubscriptionLink(this.subscriptionLinks, registrationId);
        if (null == subscription) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown subscription: " + registrationId);
        }
        subscription.close();
        ReceiveChannelEndpoint channelEndpoint = subscription.channelEndpoint();
        if (null != channelEndpoint) {
            if (subscription.hasSessionId()) {
                if (0L == channelEndpoint.decRefToStreamAndSession(subscription.streamId(), subscription.sessionId())) {
                    this.receiverProxy.removeSubscription(channelEndpoint, subscription.streamId(), subscription.sessionId());
                }
            } else if (0 == channelEndpoint.decRefToStream(subscription.streamId())) {
                this.receiverProxy.removeSubscription(channelEndpoint, subscription.streamId());
            }
            if (channelEndpoint.shouldBeClosed()) {
                channelEndpoint.closeStatusIndicator();
                this.receiveChannelEndpointByChannelMap.remove((Object)channelEndpoint.udpChannel().canonicalForm());
                this.receiverProxy.closeReceiveChannelEndpoint(channelEndpoint);
            }
        }
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onClientKeepalive(long clientId) {
        AeronClient client = DriverConductor.findClient(this.clients, clientId);
        if (null != client) {
            client.timeOfLastKeepaliveMs(this.cachedEpochClock.time());
        }
    }

    void onAddCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength, long correlationId, long clientId) {
        AeronClient client = this.getOrAddClient(clientId);
        AtomicCounter counter = this.countersManager.newCounter(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength);
        this.counterLinks.add(new CounterLink(counter, correlationId, client));
        this.clientProxy.onCounterReady(correlationId, counter.id());
    }

    void onRemoveCounter(long registrationId, long correlationId) {
        CounterLink counterLink = null;
        ArrayList<CounterLink> counterLinks = this.counterLinks;
        int size = counterLinks.size();
        for (int i = 0; i < size; ++i) {
            CounterLink link = counterLinks.get(i);
            if (registrationId != link.registrationId()) continue;
            counterLink = link;
            ArrayListUtil.fastUnorderedRemove(counterLinks, (int)i);
            break;
        }
        if (null == counterLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_COUNTER, "unknown counter: " + registrationId);
        }
        this.clientProxy.operationSucceeded(correlationId);
        this.clientProxy.onUnavailableCounter(registrationId, counterLink.counterId());
        counterLink.close();
    }

    void onClientClose(long clientId) {
        AeronClient client = DriverConductor.findClient(this.clients, clientId);
        if (null != client) {
            client.onClosedByCommand();
        }
    }

    void onAddRcvDestination(long registrationId, String destinationChannel, long correlationId) {
        ReceiveChannelEndpoint receiveChannelEndpoint = null;
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscriptionLink = this.subscriptionLinks.get(i);
            if (registrationId != subscriptionLink.registrationId()) continue;
            receiveChannelEndpoint = subscriptionLink.channelEndpoint();
            break;
        }
        if (null == receiveChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown subscription: " + registrationId);
        }
        receiveChannelEndpoint.validateAllowsDestinationControl();
        UdpChannel udpChannel = UdpChannel.parse(destinationChannel);
        ReceiveDestinationUdpTransport transport = new ReceiveDestinationUdpTransport(udpChannel, this.ctx);
        this.receiverProxy.addDestination(receiveChannelEndpoint, transport);
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onRemoveRcvDestination(long registrationId, String destinationChannel, long correlationId) {
        ReceiveChannelEndpoint receiveChannelEndpoint = null;
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscriptionLink = this.subscriptionLinks.get(i);
            if (registrationId != subscriptionLink.registrationId()) continue;
            receiveChannelEndpoint = subscriptionLink.channelEndpoint();
            break;
        }
        if (null == receiveChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown subscription: " + registrationId);
        }
        receiveChannelEndpoint.validateAllowsDestinationControl();
        UdpChannel destinationUdpChannel = UdpChannel.parse(destinationChannel);
        this.receiverProxy.removeDestination(receiveChannelEndpoint, destinationUdpChannel);
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onTerminateDriver(DirectBuffer tokenBuffer, int tokenOffset, int tokenLength) {
        if (this.ctx.terminationValidator().allowTermination(this.ctx.aeronDirectory(), tokenBuffer, tokenOffset, tokenLength)) {
            this.ctx.terminationHook().run();
        }
    }

    private void heartbeatAndCheckTimers(long nowNs) {
        long nowMs = this.cachedEpochClock.time();
        this.toDriverCommands.consumerHeartbeatTime(nowMs);
        this.checkManagedResources(this.clients, nowNs, nowMs);
        this.checkManagedResources(this.publicationLinks, nowNs, nowMs);
        this.checkManagedResources(this.networkPublications, nowNs, nowMs);
        this.checkManagedResources(this.subscriptionLinks, nowNs, nowMs);
        this.checkManagedResources(this.publicationImages, nowNs, nowMs);
        this.checkManagedResources(this.ipcPublications, nowNs, nowMs);
        this.checkManagedResources(this.counterLinks, nowNs, nowMs);
    }

    private void checkForBlockedToDriverCommands(long nowNs) {
        long consumerPosition = this.toDriverCommands.consumerPosition();
        if (consumerPosition == this.lastConsumerCommandPosition) {
            if (this.toDriverCommands.producerPosition() > consumerPosition && this.timeOfLastToDriverPositionChangeNs + this.clientLivenessTimeoutNs - nowNs < 0L && this.toDriverCommands.unblock()) {
                this.ctx.systemCounters().get(SystemCounterDescriptor.UNBLOCKED_COMMANDS).incrementOrdered();
            }
        } else {
            this.timeOfLastToDriverPositionChangeNs = nowNs;
            this.lastConsumerCommandPosition = consumerPosition;
        }
    }

    private ArrayList<SubscriberPosition> createSubscriberPositions(int sessionId, int streamId, ReceiveChannelEndpoint channelEndpoint, long joinPosition) {
        ArrayList<SubscriberPosition> subscriberPositions = new ArrayList<SubscriberPosition>();
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = this.subscriptionLinks.get(i);
            if (!subscription.matches(channelEndpoint, streamId, sessionId)) continue;
            UnsafeBufferPosition position = SubscriberPos.allocate(this.tempBuffer, this.countersManager, subscription.registrationId(), sessionId, streamId, subscription.channel(), joinPosition);
            position.setOrdered(joinPosition);
            subscriberPositions.add(new SubscriberPosition(subscription, null, (Position)position));
        }
        return subscriberPositions;
    }

    private static NetworkPublication findPublication(ArrayList<NetworkPublication> publications, int streamId, SendChannelEndpoint channelEndpoint) {
        int size = publications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = publications.get(i);
            if (streamId != publication.streamId() || channelEndpoint != publication.channelEndpoint() || NetworkPublication.State.ACTIVE != publication.state() || publication.isExclusive()) continue;
            return publication;
        }
        return null;
    }

    private NetworkPublication newNetworkPublication(long registrationId, int streamId, String channel, UdpChannel udpChannel, SendChannelEndpoint channelEndpoint, PublicationParams params, boolean isExclusive) {
        String canonicalForm = udpChannel.canonicalForm();
        int sessionId = params.hasSessionId ? params.sessionId : this.nextAvailableSessionId(streamId, canonicalForm);
        int initialTermId = params.isReplay ? params.initialTermId : BitUtil.generateRandomisedId();
        UnsafeBufferPosition publisherPosition = PublisherPos.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
        UnsafeBufferPosition publisherLimit = PublisherLimit.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
        UnsafeBufferPosition senderPosition = SenderPos.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
        UnsafeBufferPosition senderLimit = SenderLimit.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
        if (params.isReplay) {
            int bits = LogBufferDescriptor.positionBitsToShift((int)params.termLength);
            long position = LogBufferDescriptor.computePosition((int)params.termId, (int)params.termOffset, (int)bits, (int)initialTermId);
            publisherPosition.setOrdered(position);
            publisherLimit.setOrdered(position);
            senderPosition.setOrdered(position);
            senderLimit.setOrdered(position);
        }
        RetransmitHandler retransmitHandler = new RetransmitHandler((NanoClock)this.cachedNanoClock, this.ctx.systemCounters().get(SystemCounterDescriptor.INVALID_PACKETS), this.ctx.retransmitUnicastDelayGenerator(), this.ctx.retransmitUnicastLingerGenerator());
        FlowControl flowControl = udpChannel.isMulticast() || udpChannel.hasExplicitControl() ? this.ctx.multicastFlowControlSupplier().newInstance(udpChannel, streamId, registrationId) : this.ctx.unicastFlowControlSupplier().newInstance(udpChannel, streamId, registrationId);
        NetworkPublication publication = new NetworkPublication(registrationId, params, channelEndpoint, (NanoClock)this.cachedNanoClock, this.newNetworkPublicationLog(sessionId, streamId, initialTermId, udpChannel, registrationId, params), Configuration.producerWindowLength(params.termLength, this.ctx.publicationTermWindowLength()), (Position)publisherPosition, (Position)publisherLimit, (Position)senderPosition, (Position)senderLimit, SenderBpe.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel), sessionId, streamId, initialTermId, this.ctx.systemCounters(), flowControl, retransmitHandler, this.networkPublicationThreadLocals, this.ctx.publicationUnblockTimeoutNs(), this.ctx.publicationConnectionTimeoutNs(), this.ctx.untetheredWindowLimitTimeoutNs(), this.ctx.untetheredRestingTimeoutNs(), this.ctx.spiesSimulateConnection(), isExclusive);
        channelEndpoint.incRef();
        this.networkPublications.add(publication);
        this.senderProxy.newNetworkPublication(publication);
        this.linkSpies(this.subscriptionLinks, publication);
        this.activeSessionSet.add((Object)new SessionKey(sessionId, streamId, canonicalForm));
        return publication;
    }

    private RawLog newNetworkPublicationLog(int sessionId, int streamId, int initialTermId, UdpChannel udpChannel, long registrationId, PublicationParams params) {
        RawLog rawLog = this.logFactory.newPublication(udpChannel.canonicalForm(), sessionId, streamId, registrationId, params.termLength, params.isSparse);
        this.initPublicationMetadata(sessionId, streamId, initialTermId, registrationId, params, rawLog);
        return rawLog;
    }

    private RawLog newIpcPublicationLog(int sessionId, int streamId, int initialTermId, long registrationId, PublicationParams params) {
        RawLog rawLog = this.logFactory.newPublication("ipc", sessionId, streamId, registrationId, params.termLength, params.isSparse);
        this.initPublicationMetadata(sessionId, streamId, initialTermId, registrationId, params, rawLog);
        return rawLog;
    }

    private void initPublicationMetadata(int sessionId, int streamId, int initialTermId, long registrationId, PublicationParams params, RawLog rawLog) {
        UnsafeBuffer logMetaData = rawLog.metaData();
        this.defaultDataHeader.sessionId(sessionId).streamId(streamId).termId(initialTermId);
        LogBufferDescriptor.storeDefaultFrameHeader((UnsafeBuffer)logMetaData, (DirectBuffer)this.defaultDataHeader);
        LogBufferDescriptor.initialTermId((UnsafeBuffer)logMetaData, (int)initialTermId);
        LogBufferDescriptor.mtuLength((UnsafeBuffer)logMetaData, (int)params.mtuLength);
        LogBufferDescriptor.termLength((UnsafeBuffer)logMetaData, (int)rawLog.termLength());
        LogBufferDescriptor.pageSize((UnsafeBuffer)logMetaData, (int)this.ctx.filePageSize());
        LogBufferDescriptor.correlationId((UnsafeBuffer)logMetaData, (long)registrationId);
        LogBufferDescriptor.endOfStreamPosition((UnsafeBuffer)logMetaData, (long)Long.MAX_VALUE);
        DriverConductor.initialisePositionCounters(initialTermId, params, logMetaData);
    }

    private static void initialisePositionCounters(int initialTermId, PublicationParams params, UnsafeBuffer logMetaData) {
        if (params.isReplay) {
            int termId = params.termId;
            int termCount = termId - initialTermId;
            int activeIndex = LogBufferDescriptor.indexByTerm((int)initialTermId, (int)termId);
            LogBufferDescriptor.rawTail((UnsafeBuffer)logMetaData, (int)activeIndex, (long)LogBufferDescriptor.packTail((int)termId, (int)params.termOffset));
            for (int i = 1; i < 3; ++i) {
                int expectedTermId = termId + i - 3;
                activeIndex = LogBufferDescriptor.nextPartitionIndex((int)activeIndex);
                LogBufferDescriptor.initialiseTailWithTermId((UnsafeBuffer)logMetaData, (int)activeIndex, (int)expectedTermId);
            }
            LogBufferDescriptor.activeTermCount((UnsafeBuffer)logMetaData, (int)termCount);
        } else {
            LogBufferDescriptor.initialiseTailWithTermId((UnsafeBuffer)logMetaData, (int)0, (int)initialTermId);
            for (int i = 1; i < 3; ++i) {
                int expectedTermId = initialTermId + i - 3;
                LogBufferDescriptor.initialiseTailWithTermId((UnsafeBuffer)logMetaData, (int)i, (int)expectedTermId);
            }
        }
    }

    private RawLog newPublicationImageLog(int sessionId, int streamId, int initialTermId, int termBufferLength, boolean isSparse, int senderMtuLength, UdpChannel udpChannel, long correlationId) {
        RawLog rawLog = this.logFactory.newImage(udpChannel.canonicalForm(), sessionId, streamId, correlationId, termBufferLength, isSparse);
        UnsafeBuffer logMetaData = rawLog.metaData();
        this.defaultDataHeader.sessionId(sessionId).streamId(streamId).termId(initialTermId);
        LogBufferDescriptor.storeDefaultFrameHeader((UnsafeBuffer)logMetaData, (DirectBuffer)this.defaultDataHeader);
        LogBufferDescriptor.initialTermId((UnsafeBuffer)logMetaData, (int)initialTermId);
        LogBufferDescriptor.mtuLength((UnsafeBuffer)logMetaData, (int)senderMtuLength);
        LogBufferDescriptor.termLength((UnsafeBuffer)logMetaData, (int)termBufferLength);
        LogBufferDescriptor.pageSize((UnsafeBuffer)logMetaData, (int)this.ctx.filePageSize());
        LogBufferDescriptor.correlationId((UnsafeBuffer)logMetaData, (long)correlationId);
        LogBufferDescriptor.endOfStreamPosition((UnsafeBuffer)logMetaData, (long)Long.MAX_VALUE);
        return rawLog;
    }

    private SendChannelEndpoint getOrCreateSendChannelEndpoint(UdpChannel udpChannel) {
        SendChannelEndpoint channelEndpoint = this.findExistingSendChannelEndpoint(udpChannel);
        if (null == channelEndpoint) {
            channelEndpoint = this.ctx.sendChannelEndpointSupplier().newInstance(udpChannel, SendChannelStatus.allocate(this.tempBuffer, this.countersManager, udpChannel.originalUriString()), this.ctx);
            this.sendChannelEndpointByChannelMap.put((Object)udpChannel.canonicalForm(), (Object)channelEndpoint);
            this.senderProxy.registerSendChannelEndpoint(channelEndpoint);
        }
        return channelEndpoint;
    }

    private SendChannelEndpoint findExistingSendChannelEndpoint(UdpChannel udpChannel) {
        if (udpChannel.hasTag()) {
            for (SendChannelEndpoint endpoint : this.sendChannelEndpointByChannelMap.values()) {
                UdpChannel endpointUdpChannel = endpoint.udpChannel();
                if (!endpointUdpChannel.matchesTag(udpChannel)) continue;
                return endpoint;
            }
        }
        return (SendChannelEndpoint)this.sendChannelEndpointByChannelMap.get((Object)udpChannel.canonicalForm());
    }

    private void checkForClashingSubscription(SubscriptionParams params, UdpChannel udpChannel, int streamId) {
        ReceiveChannelEndpoint channelEndpoint = this.findExistingReceiveChannelEndpoint(udpChannel);
        if (null != channelEndpoint) {
            boolean isReliable = params.isReliable;
            boolean isRejoin = params.isRejoin;
            ArrayList<SubscriptionLink> existingLinks = this.subscriptionLinks;
            int size = existingLinks.size();
            for (int i = 0; i < size; ++i) {
                SubscriptionLink subscription = existingLinks.get(i);
                if (isReliable != subscription.isReliable() && subscription.matches(channelEndpoint, streamId, params)) {
                    throw new IllegalStateException("option conflicts with existing subscriptions: reliable=" + isReliable);
                }
                if (isRejoin == subscription.isRejoin() || !subscription.matches(channelEndpoint, streamId, params)) continue;
                throw new IllegalStateException("option conflicts with existing subscriptions: rejoin=" + isRejoin);
            }
        }
    }

    private void linkMatchingImages(SubscriptionLink subscription) {
        long registrationId = subscription.registrationId();
        int streamId = subscription.streamId();
        String channel = subscription.channel();
        int size = this.publicationImages.size();
        for (int i = 0; i < size; ++i) {
            PublicationImage image = this.publicationImages.get(i);
            if (!subscription.matches(image) || !image.isAcceptingSubscriptions()) continue;
            long rebuildPosition = image.rebuildPosition();
            int sessionId = image.sessionId();
            UnsafeBufferPosition position = SubscriberPos.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel, rebuildPosition);
            position.setOrdered(rebuildPosition);
            subscription.link(image, (ReadablePosition)position);
            image.addSubscriber(subscription, (ReadablePosition)position);
            this.clientProxy.onAvailableImage(image.correlationId(), streamId, sessionId, registrationId, position.id(), image.rawLog().fileName(), Configuration.sourceIdentity(image.sourceAddress()));
        }
    }

    private ArrayList<SubscriberPosition> linkIpcSubscriptions(IpcPublication publication) {
        ArrayList<SubscriptionLink> subscriptionLinks = this.subscriptionLinks;
        ArrayList<SubscriberPosition> subscriberPositions = new ArrayList<SubscriberPosition>();
        int size = subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = subscriptionLinks.get(i);
            if (!subscription.matches(publication) || subscription.isLinked(publication)) continue;
            Position subPos = this.linkIpcSubscription(publication, subscription);
            subscriberPositions.add(new SubscriberPosition(subscription, publication, subPos));
        }
        return subscriberPositions;
    }

    private Position linkIpcSubscription(IpcPublication publication, SubscriptionLink subscription) {
        long joinPosition = publication.joinPosition();
        long registrationId = subscription.registrationId();
        int sessionId = publication.sessionId();
        int streamId = subscription.streamId();
        String channel = subscription.channel();
        UnsafeBufferPosition position = SubscriberPos.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel, joinPosition);
        position.setOrdered(joinPosition);
        subscription.link(publication, (ReadablePosition)position);
        publication.addSubscriber(subscription, (ReadablePosition)position);
        return position;
    }

    private Position linkSpy(NetworkPublication publication, SubscriptionLink subscription) {
        long joinPosition = publication.consumerPosition();
        long subscriptionRegistrationId = subscription.registrationId();
        int streamId = publication.streamId();
        int sessionId = publication.sessionId();
        String channel = subscription.channel();
        UnsafeBufferPosition position = SubscriberPos.allocate(this.tempBuffer, this.countersManager, subscriptionRegistrationId, sessionId, streamId, channel, joinPosition);
        position.setOrdered(joinPosition);
        subscription.link(publication, (ReadablePosition)position);
        publication.addSubscriber(subscription, (ReadablePosition)position);
        return position;
    }

    private ReceiveChannelEndpoint getOrCreateReceiveChannelEndpoint(UdpChannel udpChannel) {
        ReceiveChannelEndpoint channelEndpoint = this.findExistingReceiveChannelEndpoint(udpChannel);
        if (null == channelEndpoint) {
            channelEndpoint = this.ctx.receiveChannelEndpointSupplier().newInstance(udpChannel, new DataPacketDispatcher(this.ctx.driverConductorProxy(), this.receiverProxy.receiver()), ReceiveChannelStatus.allocate(this.tempBuffer, this.countersManager, udpChannel.originalUriString()), this.ctx);
            this.receiveChannelEndpointByChannelMap.put((Object)udpChannel.canonicalForm(), (Object)channelEndpoint);
            this.receiverProxy.registerReceiveChannelEndpoint(channelEndpoint);
        }
        return channelEndpoint;
    }

    private ReceiveChannelEndpoint findExistingReceiveChannelEndpoint(UdpChannel udpChannel) {
        if (udpChannel.hasTag()) {
            for (ReceiveChannelEndpoint endpoint : this.receiveChannelEndpointByChannelMap.values()) {
                if (!endpoint.udpChannel().matchesTag(udpChannel)) continue;
                return endpoint;
            }
        }
        return (ReceiveChannelEndpoint)this.receiveChannelEndpointByChannelMap.get((Object)udpChannel.canonicalForm());
    }

    private AeronClient getOrAddClient(long clientId) {
        AeronClient client = DriverConductor.findClient(this.clients, clientId);
        if (null == client) {
            client = new AeronClient(clientId, this.clientLivenessTimeoutNs, this.cachedEpochClock.time(), this.ctx.systemCounters().get(SystemCounterDescriptor.CLIENT_TIMEOUTS), ClientHeartbeatTimestamp.allocate(this.tempBuffer, this.countersManager, clientId));
            this.clients.add(client);
        }
        return client;
    }

    private IpcPublication getOrAddIpcPublication(long correlationId, int streamId, String channel, boolean isExclusive) {
        IpcPublication publication = null;
        ChannelUri channelUri = ChannelUri.parse((CharSequence)channel);
        PublicationParams params = PublicationParams.getPublicationParams(this.ctx, channelUri, this, isExclusive, true);
        if (!isExclusive) {
            publication = DriverConductor.findSharedIpcPublication(this.ipcPublications, streamId);
        }
        if (null == publication) {
            if (params.hasSessionId) {
                this.checkForSessionClash(params.sessionId, streamId, "ipc");
            }
            PublicationParams.validateMtuForMaxMessage(params);
            publication = this.addIpcPublication(correlationId, streamId, channel, isExclusive, params);
        } else {
            PublicationParams.confirmMatch(channelUri, params, publication.rawLog(), publication.sessionId());
        }
        return publication;
    }

    private IpcPublication addIpcPublication(long registrationId, int streamId, String channel, boolean isExclusive, PublicationParams params) {
        int sessionId = params.hasSessionId ? params.sessionId : this.nextAvailableSessionId(streamId, "ipc");
        int initialTermId = params.isReplay ? params.initialTermId : BitUtil.generateRandomisedId();
        RawLog rawLog = this.newIpcPublicationLog(sessionId, streamId, initialTermId, registrationId, params);
        UnsafeBufferPosition publisherPosition = PublisherPos.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
        UnsafeBufferPosition publisherLimit = PublisherLimit.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
        if (params.isReplay) {
            int positionBitsToShift = LogBufferDescriptor.positionBitsToShift((int)params.termLength);
            long position = LogBufferDescriptor.computePosition((int)params.termId, (int)params.termOffset, (int)positionBitsToShift, (int)initialTermId);
            publisherPosition.setOrdered(position);
            publisherLimit.setOrdered(position);
        }
        IpcPublication publication = new IpcPublication(registrationId, params.entityTag, sessionId, streamId, (Position)publisherPosition, (Position)publisherLimit, rawLog, Configuration.producerWindowLength(params.termLength, this.ctx.ipcPublicationTermWindowLength()), this.ctx.publicationUnblockTimeoutNs(), this.ctx.untetheredWindowLimitTimeoutNs(), this.ctx.untetheredRestingTimeoutNs(), this.cachedNanoClock.nanoTime(), this.ctx.systemCounters(), isExclusive);
        this.ipcPublications.add(publication);
        this.activeSessionSet.add((Object)new SessionKey(sessionId, streamId, "ipc"));
        return publication;
    }

    private static AeronClient findClient(ArrayList<AeronClient> clients, long clientId) {
        AeronClient aeronClient = null;
        int size = clients.size();
        for (int i = 0; i < size; ++i) {
            AeronClient client = clients.get(i);
            if (client.clientId() != clientId) continue;
            aeronClient = client;
            break;
        }
        return aeronClient;
    }

    private static SubscriptionLink removeSubscriptionLink(ArrayList<SubscriptionLink> subscriptionLinks, long registrationId) {
        SubscriptionLink subscriptionLink = null;
        int size = subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = subscriptionLinks.get(i);
            if (subscription.registrationId() != registrationId) continue;
            subscriptionLink = subscription;
            ArrayListUtil.fastUnorderedRemove(subscriptionLinks, (int)i);
            break;
        }
        return subscriptionLink;
    }

    private static IpcPublication findSharedIpcPublication(ArrayList<IpcPublication> ipcPublications, long streamId) {
        IpcPublication ipcPublication = null;
        int size = ipcPublications.size();
        for (int i = 0; i < size; ++i) {
            IpcPublication publication = ipcPublications.get(i);
            if ((long)publication.streamId() != streamId || publication.isExclusive() || IpcPublication.State.ACTIVE != publication.state()) continue;
            ipcPublication = publication;
            break;
        }
        return ipcPublication;
    }

    private void checkForSessionClash(int sessionId, int streamId, String channel) {
        if (this.activeSessionSet.contains((Object)new SessionKey(sessionId, streamId, channel))) {
            throw new IllegalStateException("existing publication has clashing session id: " + sessionId);
        }
    }

    private int nextAvailableSessionId(int streamId, String channel) {
        int sessionId;
        SessionKey sessionKey = new SessionKey(streamId, channel);
        do {
            ++this.nextSessionId;
            if (this.ctx.publicationReservedSessionIdLow() <= sessionId && sessionId <= this.ctx.publicationReservedSessionIdHigh()) {
                this.nextSessionId = this.ctx.publicationReservedSessionIdHigh() + 1;
                sessionId = this.nextSessionId++;
            }
            sessionKey.sessionId = sessionId;
        } while (this.activeSessionSet.contains((Object)sessionKey));
        return sessionId;
    }

    private <T extends DriverManagedResource> void checkManagedResources(ArrayList<T> list, long nowNs, long nowMs) {
        int lastIndex;
        for (int i = lastIndex = list.size() - 1; i >= 0; --i) {
            DriverManagedResource resource = (DriverManagedResource)list.get(i);
            resource.onTimeEvent(nowNs, nowMs, this);
            if (!resource.hasReachedEndOfLife()) continue;
            if (resource.free()) {
                ArrayListUtil.fastUnorderedRemove(list, (int)i, (int)lastIndex--);
                resource.close();
                continue;
            }
            this.ctx.systemCounters().get(SystemCounterDescriptor.FREE_FAILS).incrementOrdered();
        }
    }

    private void linkSpies(ArrayList<SubscriptionLink> links, NetworkPublication publication) {
        int size = links.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = links.get(i);
            if (!subscription.matches(publication) || subscription.isLinked(publication)) continue;
            this.clientProxy.onAvailableImage(publication.registrationId(), publication.streamId(), publication.sessionId(), subscription.registrationId(), this.linkSpy(publication, subscription).id(), publication.rawLog().fileName(), "aeron:ipc");
        }
    }

    private void updateClocks(long nowNs) {
        if (this.clockUpdateDeadlineNs - nowNs < 0L) {
            this.clockUpdateDeadlineNs = nowNs + CLOCK_UPDATE_DURATION_NS;
            this.cachedNanoClock.update(nowNs);
            this.cachedEpochClock.update(this.epochClock.time());
        }
    }

    private int processTimers(long nowNs) {
        int workCount = 0;
        if (this.timeOfLastTimerCheckNs + this.timerIntervalNs - nowNs < 0L) {
            this.heartbeatAndCheckTimers(nowNs);
            this.checkForBlockedToDriverCommands(nowNs);
            this.timeOfLastTimerCheckNs = nowNs;
            workCount = 1;
        }
        return workCount;
    }

    private static boolean isOldestSubscriptionSparse(ArrayList<SubscriberPosition> subscriberPositions) {
        SubscriberPosition subscriberPosition = subscriberPositions.get(0);
        long regId = subscriberPosition.subscription().registrationId();
        boolean isSparse = subscriberPosition.subscription().isSparse();
        int size = subscriberPositions.size();
        for (int i = 1; i < size; ++i) {
            SubscriptionLink subscription = subscriberPositions.get(i).subscription();
            if (subscription.registrationId() >= regId) continue;
            isSparse = subscription.isSparse();
            regId = subscription.registrationId();
        }
        return isSparse;
    }

    static final class SessionKey {
        int sessionId;
        final int streamId;
        final String channel;

        SessionKey(int streamId, String channel) {
            this.streamId = streamId;
            this.channel = channel;
        }

        SessionKey(int sessionId, int streamId, String channel) {
            this.sessionId = sessionId;
            this.streamId = streamId;
            this.channel = channel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionKey that = (SessionKey)o;
            return this.sessionId == that.sessionId && this.streamId == that.streamId && this.channel.equals(that.channel);
        }

        public int hashCode() {
            return 31 * this.sessionId * this.streamId * this.channel.hashCode();
        }

        public String toString() {
            return "SessionKey{sessionId=" + this.sessionId + ", streamId=" + this.streamId + ", channel=" + this.channel + '}';
        }
    }
}

