/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.Subscribable;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.UntetheredSubscription;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.LogBufferUnblocker;
import java.util.ArrayList;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;

public final class IpcPublication
implements DriverManagedResource,
Subscribable {
    private static final ReadablePosition[] EMPTY_POSITIONS = new ReadablePosition[0];
    private final long registrationId;
    private final long unblockTimeoutNs;
    private final long untetheredWindowLimitTimeoutNs;
    private final long untetheredRestingTimeoutNs;
    private final long tag;
    private final int sessionId;
    private final int streamId;
    private final int tripGain;
    private final int termBufferLength;
    private final int termWindowLength;
    private final int positionBitsToShift;
    private final int initialTermId;
    private long tripLimit;
    private long consumerPosition;
    private long lastConsumerPosition;
    private long timeOfLastConsumerPositionUpdateNs;
    private long cleanPosition;
    private int refCount = 0;
    private boolean reachedEndOfLife = false;
    private final boolean isExclusive;
    private State state = State.ACTIVE;
    private final UnsafeBuffer[] termBuffers;
    private final ArrayList<UntetheredSubscription> untetheredSubscriptions = new ArrayList();
    private ReadablePosition[] subscriberPositions = EMPTY_POSITIONS;
    private final Position publisherPos;
    private final Position publisherLimit;
    private final UnsafeBuffer metaDataBuffer;
    private final RawLog rawLog;
    private final AtomicCounter unblockedPublications;

    public IpcPublication(long registrationId, long tag, int sessionId, int streamId, Position publisherPos, Position publisherLimit, RawLog rawLog, int termWindowLength, long unblockTimeoutNs, long untetheredWindowLimitTimeoutNs, long untetheredRestingTimeoutNs, long nowNs, SystemCounters systemCounters, boolean isExclusive) {
        int termLength;
        this.registrationId = registrationId;
        this.tag = tag;
        this.sessionId = sessionId;
        this.streamId = streamId;
        this.isExclusive = isExclusive;
        this.termBuffers = rawLog.termBuffers();
        this.initialTermId = LogBufferDescriptor.initialTermId((UnsafeBuffer)rawLog.metaData());
        this.termBufferLength = termLength = rawLog.termLength();
        this.positionBitsToShift = LogBufferDescriptor.positionBitsToShift((int)termLength);
        this.termWindowLength = termWindowLength;
        this.tripGain = termWindowLength >> 3;
        this.publisherPos = publisherPos;
        this.publisherLimit = publisherLimit;
        this.rawLog = rawLog;
        this.unblockTimeoutNs = unblockTimeoutNs;
        this.untetheredWindowLimitTimeoutNs = untetheredWindowLimitTimeoutNs;
        this.untetheredRestingTimeoutNs = untetheredRestingTimeoutNs;
        this.unblockedPublications = systemCounters.get(SystemCounterDescriptor.UNBLOCKED_PUBLICATIONS);
        this.metaDataBuffer = rawLog.metaData();
        this.lastConsumerPosition = this.consumerPosition = this.producerPosition();
        this.cleanPosition = this.consumerPosition;
        this.timeOfLastConsumerPositionUpdateNs = nowNs;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public long tag() {
        return this.tag;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public RawLog rawLog() {
        return this.rawLog;
    }

    public int publisherLimitId() {
        return this.publisherLimit.id();
    }

    public int termBufferLength() {
        return this.termBufferLength;
    }

    public int mtuLength() {
        return LogBufferDescriptor.mtuLength((UnsafeBuffer)this.metaDataBuffer);
    }

    @Override
    public boolean free() {
        return this.rawLog.free();
    }

    @Override
    public void close() {
        this.publisherPos.close();
        this.publisherLimit.close();
        for (ReadablePosition position : this.subscriberPositions) {
            position.close();
        }
        int size = this.untetheredSubscriptions.size();
        for (int i = 0; i < size; ++i) {
            UntetheredSubscription untetheredSubscription = this.untetheredSubscriptions.get(i);
            if (2 != untetheredSubscription.state) continue;
            untetheredSubscription.position.close();
        }
        this.rawLog.close();
    }

    @Override
    public void addSubscriber(SubscriptionLink subscriptionLink, ReadablePosition subscriberPosition) {
        LogBufferDescriptor.isConnected((UnsafeBuffer)this.metaDataBuffer, (boolean)true);
        this.subscriberPositions = (ReadablePosition[])ArrayUtil.add((Object[])this.subscriberPositions, (Object)subscriberPosition);
        if (!subscriptionLink.isTether()) {
            this.untetheredSubscriptions.add(new UntetheredSubscription(subscriptionLink, subscriberPosition, this.timeOfLastConsumerPositionUpdateNs));
        }
    }

    @Override
    public void removeSubscriber(SubscriptionLink subscriptionLink, ReadablePosition subscriberPosition) {
        this.consumerPosition = Math.max(this.consumerPosition, subscriberPosition.getVolatile());
        this.subscriberPositions = (ReadablePosition[])ArrayUtil.remove((Object[])this.subscriberPositions, (Object)subscriberPosition);
        subscriberPosition.close();
        if (!subscriptionLink.isTether()) {
            int lastIndex;
            for (int i = lastIndex = this.untetheredSubscriptions.size() - 1; i >= 0; --i) {
                if (this.untetheredSubscriptions.get((int)i).subscriptionLink != subscriptionLink) continue;
                ArrayListUtil.fastUnorderedRemove(this.untetheredSubscriptions, (int)i, (int)lastIndex);
                break;
            }
        }
        if (this.subscriberPositions.length == 0) {
            LogBufferDescriptor.isConnected((UnsafeBuffer)this.metaDataBuffer, (boolean)false);
        }
    }

    @Override
    public void onTimeEvent(long timeNs, long timeMs, DriverConductor conductor) {
        switch (this.state) {
            case ACTIVE: {
                this.checkUntetheredSubscriptions(timeNs, conductor);
                long producerPosition = this.producerPosition();
                this.publisherPos.setOrdered(producerPosition);
                if (this.isExclusive) break;
                this.checkForBlockedPublisher(producerPosition, timeNs);
                break;
            }
            case INACTIVE: {
                long producerPosition = this.producerPosition();
                this.publisherPos.setOrdered(producerPosition);
                if (this.isDrained(producerPosition)) {
                    this.state = State.LINGER;
                    conductor.transitionToLinger(this);
                    break;
                }
                if (!LogBufferUnblocker.unblock((UnsafeBuffer[])this.termBuffers, (UnsafeBuffer)this.metaDataBuffer, (long)this.consumerPosition, (int)this.termBufferLength)) break;
                this.unblockedPublications.incrementOrdered();
                break;
            }
            case LINGER: {
                this.reachedEndOfLife = true;
                conductor.cleanupIpcPublication(this);
            }
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public void incRef() {
        ++this.refCount;
    }

    public void decRef() {
        if (0 == --this.refCount) {
            this.state = State.INACTIVE;
            long producerPosition = this.producerPosition();
            this.publisherLimit.setOrdered(producerPosition);
            LogBufferDescriptor.endOfStreamPosition((UnsafeBuffer)this.metaDataBuffer, (long)producerPosition);
        }
    }

    int updatePublisherLimit() {
        int workCount = 0;
        long minSubscriberPosition = Long.MAX_VALUE;
        long maxSubscriberPosition = this.consumerPosition;
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            long position = subscriberPosition.getVolatile();
            minSubscriberPosition = Math.min(minSubscriberPosition, position);
            maxSubscriberPosition = Math.max(maxSubscriberPosition, position);
        }
        if (this.subscriberPositions.length > 0) {
            long proposedLimit;
            if (maxSubscriberPosition > this.consumerPosition) {
                this.consumerPosition = maxSubscriberPosition;
            }
            if ((proposedLimit = minSubscriberPosition + (long)this.termWindowLength) > this.tripLimit) {
                this.cleanBufferTo(minSubscriberPosition);
                this.publisherLimit.setOrdered(proposedLimit);
                this.tripLimit = proposedLimit + (long)this.tripGain;
                workCount = 1;
            }
        } else if (this.publisherLimit.get() > this.consumerPosition) {
            this.tripLimit = this.consumerPosition;
            this.publisherLimit.setOrdered(this.consumerPosition);
        }
        return workCount;
    }

    long joinPosition() {
        return this.consumerPosition;
    }

    long producerPosition() {
        long rawTail = LogBufferDescriptor.rawTailVolatile((UnsafeBuffer)this.metaDataBuffer);
        int termOffset = LogBufferDescriptor.termOffset((long)rawTail, (long)this.termBufferLength);
        return LogBufferDescriptor.computePosition((int)LogBufferDescriptor.termId((long)rawTail), (int)termOffset, (int)this.positionBitsToShift, (int)this.initialTermId);
    }

    long consumerPosition() {
        return this.consumerPosition;
    }

    State state() {
        return this.state;
    }

    private void checkUntetheredSubscriptions(long nowNs, DriverConductor conductor) {
        int lastIndex;
        ArrayList<UntetheredSubscription> untetheredSubscriptions = this.untetheredSubscriptions;
        int untetheredSubscriptionsSize = untetheredSubscriptions.size();
        if (0 == untetheredSubscriptionsSize) {
            return;
        }
        long untetheredWindowLimit = this.consumerPosition - (long)this.termWindowLength + (long)(this.termWindowLength >> 3);
        block5: for (int i = lastIndex = untetheredSubscriptionsSize - 1; i >= 0; --i) {
            UntetheredSubscription untethered = untetheredSubscriptions.get(i);
            switch (untethered.state) {
                case 0: {
                    if (untethered.position.getVolatile() > untetheredWindowLimit) {
                        untethered.timeOfLastUpdateNs = nowNs;
                        continue block5;
                    }
                    if (untethered.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - nowNs > 0L) continue block5;
                    conductor.notifyUnavailableImageLink(this.registrationId, untethered.subscriptionLink);
                    untethered.state = 1;
                    untethered.timeOfLastUpdateNs = nowNs;
                    continue block5;
                }
                case 1: {
                    if (untethered.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - nowNs > 0L) continue block5;
                    this.subscriberPositions = (ReadablePosition[])ArrayUtil.remove((Object[])this.subscriberPositions, (Object)untethered.position);
                    untethered.state = 2;
                    untethered.timeOfLastUpdateNs = nowNs;
                    continue block5;
                }
                case 2: {
                    if (untethered.timeOfLastUpdateNs + this.untetheredRestingTimeoutNs - nowNs > 0L) continue block5;
                    this.subscriberPositions = (ReadablePosition[])ArrayUtil.add((Object[])this.subscriberPositions, (Object)untethered.position);
                    conductor.notifyAvailableImageLink(this.registrationId, this.sessionId, untethered.subscriptionLink, untethered.position.id(), this.consumerPosition, this.rawLog.fileName(), "aeron:ipc");
                    LogBufferDescriptor.isConnected((UnsafeBuffer)this.metaDataBuffer, (boolean)true);
                    untethered.state = 0;
                    untethered.timeOfLastUpdateNs = nowNs;
                }
            }
        }
    }

    private boolean isDrained(long producerPosition) {
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            if (subscriberPosition.getVolatile() >= producerPosition) continue;
            return false;
        }
        return true;
    }

    private void checkForBlockedPublisher(long producerPosition, long timeNs) {
        long consumerPosition = this.consumerPosition;
        if (consumerPosition == this.lastConsumerPosition && this.isPossiblyBlocked(producerPosition, consumerPosition)) {
            if (this.timeOfLastConsumerPositionUpdateNs + this.unblockTimeoutNs - timeNs < 0L && LogBufferUnblocker.unblock((UnsafeBuffer[])this.termBuffers, (UnsafeBuffer)this.metaDataBuffer, (long)consumerPosition, (int)this.termBufferLength)) {
                this.unblockedPublications.incrementOrdered();
            }
        } else {
            this.timeOfLastConsumerPositionUpdateNs = timeNs;
            this.lastConsumerPosition = consumerPosition;
        }
    }

    private boolean isPossiblyBlocked(long producerPosition, long consumerPosition) {
        int expectedTermCount;
        int producerTermCount = LogBufferDescriptor.activeTermCount((UnsafeBuffer)this.metaDataBuffer);
        if (producerTermCount != (expectedTermCount = (int)(consumerPosition >> this.positionBitsToShift))) {
            return true;
        }
        return producerPosition > consumerPosition;
    }

    private void cleanBufferTo(long position) {
        long cleanPosition = this.cleanPosition;
        if (position > cleanPosition) {
            UnsafeBuffer dirtyTerm = this.termBuffers[LogBufferDescriptor.indexByPosition((long)cleanPosition, (int)this.positionBitsToShift)];
            int bytesForCleaning = (int)(position - cleanPosition);
            int bufferCapacity = this.termBufferLength;
            int termOffset = (int)cleanPosition & bufferCapacity - 1;
            int length = Math.min(bytesForCleaning, bufferCapacity - termOffset);
            dirtyTerm.setMemory(termOffset + 8, length - 8, (byte)0);
            dirtyTerm.putLongOrdered(termOffset, 0L);
            this.cleanPosition = cleanPosition + (long)length;
        }
    }

    static enum State {
        ACTIVE,
        INACTIVE,
        LINGER;

    }
}

