/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FlowControl;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.agrona.SystemUtil;
import org.agrona.collections.ArrayListUtil;

public class MinMulticastFlowControl
implements FlowControl {
    public static final String RECEIVER_TIMEOUT_PROP_NAME = "aeron.MinMulticastFlowControl.receiverTimeout";
    public static final long RECEIVER_TIMEOUT_DEFAULT = TimeUnit.SECONDS.toNanos(2L);
    public static final long RECEIVER_TIMEOUT = SystemUtil.getDurationInNanos((String)"aeron.MinMulticastFlowControl.receiverTimeout", (long)RECEIVER_TIMEOUT_DEFAULT);
    private final ArrayList<Receiver> receiverList = new ArrayList();

    @Override
    public void initialize(int initialTermId, int termBufferLength) {
    }

    @Override
    public long onStatusMessage(StatusMessageFlyweight flyweight, InetSocketAddress receiverAddress, long senderLimit, int initialTermId, int positionBitsToShift, long timeNs) {
        long position = LogBufferDescriptor.computePosition((int)flyweight.consumptionTermId(), (int)flyweight.consumptionTermOffset(), (int)positionBitsToShift, (int)initialTermId);
        long windowLength = flyweight.receiverWindowLength();
        long receiverId = flyweight.receiverId();
        boolean isExisting = false;
        long minPosition = Long.MAX_VALUE;
        ArrayList<Receiver> receiverList = this.receiverList;
        int size = receiverList.size();
        for (int i = 0; i < size; ++i) {
            Receiver receiver = receiverList.get(i);
            if (receiverId == receiver.receiverId) {
                receiver.lastPosition = Math.max(position, receiver.lastPosition);
                receiver.lastPositionPlusWindow = position + windowLength;
                receiver.timeOfLastStatusMessageNs = timeNs;
                isExisting = true;
            }
            minPosition = Math.min(minPosition, receiver.lastPositionPlusWindow);
        }
        if (!isExisting) {
            receiverList.add(new Receiver(position, position + windowLength, timeNs, receiverId, receiverAddress));
            minPosition = Math.min(minPosition, position + windowLength);
        }
        return Math.max(senderLimit, minPosition);
    }

    @Override
    public long onIdle(long timeNs, long senderLimit, long senderPosition, boolean isEos) {
        int lastIndex;
        long minPosition = Long.MAX_VALUE;
        long minLimitPosition = Long.MAX_VALUE;
        ArrayList<Receiver> receiverList = this.receiverList;
        for (int i = lastIndex = receiverList.size() - 1; i >= 0; --i) {
            Receiver receiver = receiverList.get(i);
            if (receiver.timeOfLastStatusMessageNs + RECEIVER_TIMEOUT - timeNs < 0L) {
                ArrayListUtil.fastUnorderedRemove(receiverList, (int)i, (int)lastIndex--);
                continue;
            }
            minPosition = Math.min(minPosition, receiver.lastPosition);
            minLimitPosition = Math.min(minLimitPosition, receiver.lastPositionPlusWindow);
        }
        return receiverList.size() > 0 ? minLimitPosition : senderLimit;
    }

    static class Receiver {
        long lastPosition;
        long lastPositionPlusWindow;
        long timeOfLastStatusMessageNs;
        final long receiverId;
        final InetSocketAddress address;

        Receiver(long lastPosition, long lastPositionPlusWindow, long timeNs, long receiverId, InetSocketAddress receiverAddress) {
            this.lastPosition = lastPosition;
            this.lastPositionPlusWindow = lastPositionPlusWindow;
            this.timeOfLastStatusMessageNs = timeNs;
            this.receiverId = receiverId;
            this.address = receiverAddress;
        }
    }
}

