/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.CongestionControl;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.LossDetector;
import io.aeron.driver.LossHandler;
import io.aeron.driver.PublicationImagePadding3;
import io.aeron.driver.Subscribable;
import io.aeron.driver.SubscriberPosition;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.UntetheredSubscription;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.media.ImageConnection;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationUdpTransport;
import io.aeron.driver.reports.LossReport;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.TermGapFiller;
import io.aeron.logbuffer.TermRebuilder;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.agrona.UnsafeAccess;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;

public class PublicationImage
extends PublicationImagePadding3
implements LossHandler,
DriverManagedResource,
Subscribable {
    private volatile long beginLossChange = -1L;
    private volatile long endLossChange = -1L;
    private int lossTermId;
    private int lossTermOffset;
    private int lossLength;
    private volatile long beginSmChange = -1L;
    private volatile long endSmChange = -1L;
    private long nextSmPosition;
    private int nextSmReceiverWindowLength;
    private long timeOfLastStatusMessageScheduleNs;
    private long lastLossChangeNumber = -1L;
    private long lastSmChangeNumber = -1L;
    private long lastSmPosition;
    private long lastSmWindowLimit;
    private long timeOfLastStateChangeNs;
    private final long correlationId;
    private final long imageLivenessTimeoutNs;
    private final long untetheredWindowLimitTimeoutNs;
    private final long untetheredRestingTimeoutNs;
    private final int sessionId;
    private final int streamId;
    private final int positionBitsToShift;
    private final int termLengthMask;
    private final int initialTermId;
    private final boolean isReliable;
    private boolean isTrackingRebuild = true;
    private volatile State state = State.INIT;
    private final NanoClock nanoClock;
    private final NanoClock cachedNanoClock;
    private final ReceiveChannelEndpoint channelEndpoint;
    private final UnsafeBuffer[] termBuffers;
    private final Position hwmPosition;
    private final LossDetector lossDetector;
    private final CongestionControl congestionControl;
    private final Position rebuildPosition;
    private final InetSocketAddress sourceAddress;
    private final AtomicCounter heartbeatsReceived;
    private final AtomicCounter statusMessagesSent;
    private final AtomicCounter nakMessagesSent;
    private final AtomicCounter flowControlUnderRuns;
    private final AtomicCounter flowControlOverRuns;
    private final AtomicCounter lossGapFills;
    private final EpochClock cachedEpochClock;
    private final RawLog rawLog;

    public PublicationImage(long correlationId, long imageLivenessTimeoutNs, long untetheredWindowLimitTimeoutNs, long untetheredRestingTimeoutNs, ReceiveChannelEndpoint channelEndpoint, int transportIndex, InetSocketAddress controlAddress, int sessionId, int streamId, int initialTermId, int activeTermId, int initialTermOffset, RawLog rawLog, FeedbackDelayGenerator lossFeedbackDelayGenerator, ArrayList<SubscriberPosition> subscriberPositions, Position hwmPosition, Position rebuildPosition, NanoClock nanoClock, NanoClock cachedNanoClock, EpochClock cachedEpochClock, SystemCounters systemCounters, InetSocketAddress sourceAddress, CongestionControl congestionControl, LossReport lossReport) {
        long position;
        long nowNs;
        this.correlationId = correlationId;
        this.imageLivenessTimeoutNs = imageLivenessTimeoutNs;
        this.untetheredWindowLimitTimeoutNs = untetheredWindowLimitTimeoutNs;
        this.untetheredRestingTimeoutNs = untetheredRestingTimeoutNs;
        this.channelEndpoint = channelEndpoint;
        this.sessionId = sessionId;
        this.streamId = streamId;
        this.rawLog = rawLog;
        this.hwmPosition = hwmPosition;
        this.rebuildPosition = rebuildPosition;
        this.sourceAddress = sourceAddress;
        this.initialTermId = initialTermId;
        this.congestionControl = congestionControl;
        this.lossReport = lossReport;
        this.nanoClock = nanoClock;
        this.cachedNanoClock = cachedNanoClock;
        this.cachedEpochClock = cachedEpochClock;
        this.timeOfLastStateChangeNs = nowNs = cachedNanoClock.nanoTime();
        this.lastPacketTimestampNs = nowNs;
        this.subscriberPositions = this.positionArray(subscriberPositions, nowNs);
        this.isReliable = subscriberPositions.get(0).subscription().isReliable();
        this.heartbeatsReceived = systemCounters.get(SystemCounterDescriptor.HEARTBEATS_RECEIVED);
        this.statusMessagesSent = systemCounters.get(SystemCounterDescriptor.STATUS_MESSAGES_SENT);
        this.nakMessagesSent = systemCounters.get(SystemCounterDescriptor.NAK_MESSAGES_SENT);
        this.flowControlUnderRuns = systemCounters.get(SystemCounterDescriptor.FLOW_CONTROL_UNDER_RUNS);
        this.flowControlOverRuns = systemCounters.get(SystemCounterDescriptor.FLOW_CONTROL_OVER_RUNS);
        this.lossGapFills = systemCounters.get(SystemCounterDescriptor.LOSS_GAP_FILLS);
        this.imageConnections = (ImageConnection[])ArrayUtil.ensureCapacity((Object[])this.imageConnections, (int)(transportIndex + 1));
        this.imageConnections[transportIndex] = new ImageConnection(nowNs, controlAddress);
        this.termBuffers = rawLog.termBuffers();
        this.lossDetector = new LossDetector(lossFeedbackDelayGenerator, this);
        int termLength = rawLog.termLength();
        this.termLengthMask = termLength - 1;
        this.positionBitsToShift = LogBufferDescriptor.positionBitsToShift((int)termLength);
        this.nextSmPosition = position = LogBufferDescriptor.computePosition((int)activeTermId, (int)initialTermOffset, (int)this.positionBitsToShift, (int)initialTermId);
        this.nextSmReceiverWindowLength = congestionControl.initialWindowLength();
        this.lastSmPosition = position;
        this.lastSmWindowLimit = position + (long)this.nextSmReceiverWindowLength;
        this.cleanPosition = position;
        hwmPosition.setOrdered(position);
        rebuildPosition.setOrdered(position);
    }

    @Override
    public boolean free() {
        return this.rawLog.free();
    }

    @Override
    public void close() {
        this.hwmPosition.close();
        this.rebuildPosition.close();
        for (ReadablePosition position : this.subscriberPositions) {
            position.close();
        }
        int size = this.untetheredSubscriptions.size();
        for (int i = 0; i < size; ++i) {
            UntetheredSubscription untetheredSubscription = (UntetheredSubscription)this.untetheredSubscriptions.get(i);
            if (2 != untetheredSubscription.state) continue;
            untetheredSubscription.position.close();
        }
        this.congestionControl.close();
        this.rawLog.close();
    }

    public long correlationId() {
        return this.correlationId;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    public String channel() {
        return this.channelEndpoint.originalUriString();
    }

    @Override
    public void addSubscriber(SubscriptionLink subscriptionLink, ReadablePosition subscriberPosition) {
        this.subscriberPositions = (ReadablePosition[])ArrayUtil.add((Object[])this.subscriberPositions, (Object)subscriberPosition);
        if (!subscriptionLink.isTether()) {
            this.untetheredSubscriptions.add(new UntetheredSubscription(subscriptionLink, subscriberPosition, this.timeOfLastStatusMessageScheduleNs));
        }
    }

    @Override
    public void removeSubscriber(SubscriptionLink subscriptionLink, ReadablePosition subscriberPosition) {
        this.subscriberPositions = (ReadablePosition[])ArrayUtil.remove((Object[])this.subscriberPositions, (Object)subscriberPosition);
        subscriberPosition.close();
        if (!subscriptionLink.isTether()) {
            int lastIndex;
            for (int i = lastIndex = this.untetheredSubscriptions.size() - 1; i >= 0; --i) {
                if (((UntetheredSubscription)this.untetheredSubscriptions.get((int)i)).subscriptionLink != subscriptionLink) continue;
                ArrayListUtil.fastUnorderedRemove((ArrayList)this.untetheredSubscriptions, (int)i, (int)lastIndex);
                break;
            }
        }
        if (this.subscriberPositions.length == 0) {
            this.isTrackingRebuild = false;
        }
    }

    @Override
    public void onGapDetected(int termId, int termOffset, int length) {
        long changeNumber;
        this.beginLossChange = changeNumber = this.beginLossChange + 1L;
        this.lossTermId = termId;
        this.lossTermOffset = termOffset;
        this.lossLength = length;
        this.endLossChange = changeNumber;
        if (null != this.reportEntry) {
            this.reportEntry.recordObservation(length, this.cachedEpochClock.time());
        } else if (null != this.lossReport) {
            this.reportEntry = this.lossReport.createEntry(length, this.cachedEpochClock.time(), this.sessionId, this.streamId, this.channel(), this.sourceAddress.toString());
            if (null == this.reportEntry) {
                this.lossReport = null;
            }
        }
    }

    InetSocketAddress sourceAddress() {
        return this.sourceAddress;
    }

    ReceiveChannelEndpoint channelEndpoint() {
        return this.channelEndpoint;
    }

    void removeFromDispatcher() {
        this.channelEndpoint.removePublicationImage(this);
    }

    RawLog rawLog() {
        return this.rawLog;
    }

    void activate() {
        this.state(State.ACTIVE);
    }

    void addDestination(int transportIndex, ReceiveDestinationUdpTransport transport) {
        this.imageConnections = (ImageConnection[])ArrayUtil.ensureCapacity((Object[])this.imageConnections, (int)(transportIndex + 1));
        if (transport.isMulticast()) {
            this.imageConnections[transportIndex] = new ImageConnection(this.cachedNanoClock.nanoTime(), transport.udpChannel().remoteControl());
        } else if (transport.hasExplicitControl()) {
            this.imageConnections[transportIndex] = new ImageConnection(this.cachedNanoClock.nanoTime(), transport.explicitControlAddress());
        }
    }

    void removeDestination(int transportIndex) {
        this.imageConnections[transportIndex] = null;
    }

    void addDestinationConnectionIfUnknown(int transportIndex, InetSocketAddress remoteAddress) {
        this.trackConnection(transportIndex, remoteAddress, this.cachedNanoClock.nanoTime());
    }

    final void trackRebuild(long nowNs, long statusMessageTimeoutNs) {
        long minSubscriberPosition = Long.MAX_VALUE;
        long maxSubscriberPosition = Long.MIN_VALUE;
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            long position = subscriberPosition.getVolatile();
            minSubscriberPosition = Math.min(minSubscriberPosition, position);
            maxSubscriberPosition = Math.max(maxSubscriberPosition, position);
        }
        long rebuildPosition = Math.max(this.rebuildPosition.get(), maxSubscriberPosition);
        long hwmPosition = this.hwmPosition.getVolatile();
        long scanOutcome = this.lossDetector.scan(this.termBuffers[LogBufferDescriptor.indexByPosition((long)rebuildPosition, (int)this.positionBitsToShift)], rebuildPosition, hwmPosition, nowNs, this.termLengthMask, this.positionBitsToShift, this.initialTermId);
        int rebuildTermOffset = (int)rebuildPosition & this.termLengthMask;
        long newRebuildPosition = rebuildPosition - (long)rebuildTermOffset + (long)LossDetector.rebuildOffset(scanOutcome);
        this.rebuildPosition.proposeMaxOrdered(newRebuildPosition);
        long ccOutcome = this.congestionControl.onTrackRebuild(nowNs, minSubscriberPosition, this.nextSmPosition, hwmPosition, rebuildPosition, newRebuildPosition, LossDetector.lossFound(scanOutcome));
        int windowLength = CongestionControl.receiverWindowLength(ccOutcome);
        int threshold = CongestionControl.threshold(windowLength);
        if (CongestionControl.shouldForceStatusMessage(ccOutcome) || this.timeOfLastStatusMessageScheduleNs + statusMessageTimeoutNs - nowNs < 0L || minSubscriberPosition > this.nextSmPosition + (long)threshold) {
            this.cleanBufferTo(minSubscriberPosition - (long)(this.termLengthMask + 1));
            this.scheduleStatusMessage(nowNs, minSubscriberPosition, windowLength);
        }
    }

    void ifActiveGoInactive() {
        if (State.ACTIVE == this.state) {
            this.state(State.INACTIVE);
        }
    }

    final boolean isTrackingRebuild() {
        return this.isTrackingRebuild;
    }

    int insertPacket(int termId, int termOffset, UnsafeBuffer buffer, int length, int transportIndex, InetSocketAddress srcAddress) {
        long proposedPosition;
        boolean isHeartbeat = DataHeaderFlyweight.isHeartbeat((UnsafeBuffer)buffer, (int)length);
        long packetPosition = LogBufferDescriptor.computePosition((int)termId, (int)termOffset, (int)this.positionBitsToShift, (int)this.initialTermId);
        long l = proposedPosition = isHeartbeat ? packetPosition : packetPosition + (long)length;
        if (!this.isFlowControlUnderRun(packetPosition) && !this.isFlowControlOverRun(proposedPosition)) {
            this.trackConnection(transportIndex, srcAddress, this.lastPacketTimestampNs);
            if (isHeartbeat) {
                if (DataHeaderFlyweight.isEndOfStream((UnsafeBuffer)buffer) && !this.isEndOfStream && this.allEos(transportIndex)) {
                    LogBufferDescriptor.endOfStreamPosition((UnsafeBuffer)this.rawLog.metaData(), (long)proposedPosition);
                    this.isEndOfStream = true;
                }
                this.heartbeatsReceived.incrementOrdered();
            } else {
                UnsafeBuffer termBuffer = this.termBuffers[LogBufferDescriptor.indexByPosition((long)packetPosition, (int)this.positionBitsToShift)];
                TermRebuilder.insert((UnsafeBuffer)termBuffer, (int)termOffset, (UnsafeBuffer)buffer, (int)length);
            }
            this.lastPacketTimestampNs = this.cachedNanoClock.nanoTime();
            this.hwmPosition.proposeMaxOrdered(proposedPosition);
        }
        return length;
    }

    boolean hasActivityAndNotEndOfStream(long nowNs) {
        boolean isActive = true;
        if (this.lastPacketTimestampNs + this.imageLivenessTimeoutNs - nowNs < 0L || this.isEndOfStream && this.rebuildPosition.getVolatile() >= this.hwmPosition.get()) {
            isActive = false;
        }
        return isActive;
    }

    int sendPendingStatusMessage() {
        long changeNumber;
        int workCount = 0;
        if (State.ACTIVE == this.state && (changeNumber = this.endSmChange) != this.lastSmChangeNumber) {
            long smPosition = this.nextSmPosition;
            int receiverWindowLength = this.nextSmReceiverWindowLength;
            UnsafeAccess.UNSAFE.loadFence();
            if (changeNumber == this.beginSmChange) {
                int termId = LogBufferDescriptor.computeTermIdFromPosition((long)smPosition, (int)this.positionBitsToShift, (int)this.initialTermId);
                int termOffset = (int)smPosition & this.termLengthMask;
                this.channelEndpoint.sendStatusMessage(this.imageConnections, this.sessionId, this.streamId, termId, termOffset, receiverWindowLength, (short)0);
                this.statusMessagesSent.incrementOrdered();
                this.lastSmPosition = smPosition;
                this.lastSmWindowLimit = smPosition + (long)receiverWindowLength;
                this.lastSmChangeNumber = changeNumber;
                this.updateActiveTransportCount();
            }
            workCount = 1;
        }
        return workCount;
    }

    int processPendingLoss() {
        int workCount = 0;
        long changeNumber = this.endLossChange;
        if (changeNumber != this.lastLossChangeNumber) {
            int termId = this.lossTermId;
            int termOffset = this.lossTermOffset;
            int length = this.lossLength;
            UnsafeAccess.UNSAFE.loadFence();
            if (changeNumber == this.beginLossChange) {
                if (this.isReliable) {
                    this.channelEndpoint.sendNakMessage(this.imageConnections, this.sessionId, this.streamId, termId, termOffset, length);
                    this.nakMessagesSent.incrementOrdered();
                } else {
                    UnsafeBuffer termBuffer = this.termBuffers[LogBufferDescriptor.indexByTerm((int)this.initialTermId, (int)termId)];
                    if (TermGapFiller.tryFillGap((UnsafeBuffer)this.rawLog.metaData(), (UnsafeBuffer)termBuffer, (int)termId, (int)termOffset, (int)length)) {
                        this.lossGapFills.incrementOrdered();
                    }
                }
                this.lastLossChangeNumber = changeNumber;
            }
            workCount = 1;
        }
        return workCount;
    }

    int initiateAnyRttMeasurements(long nowNs) {
        int workCount = 0;
        if (this.congestionControl.shouldMeasureRtt(nowNs)) {
            long preciseTimeNs = this.nanoClock.nanoTime();
            this.channelEndpoint.sendRttMeasurement(this.imageConnections, this.sessionId, this.streamId, preciseTimeNs, 0L, true);
            this.congestionControl.onRttMeasurementSent(preciseTimeNs);
            workCount = 1;
        }
        return workCount;
    }

    void onRttMeasurement(RttMeasurementFlyweight header, int transportIndex, InetSocketAddress srcAddress) {
        long nowNs = this.nanoClock.nanoTime();
        long rttInNs = nowNs - header.echoTimestampNs() - header.receptionDelta();
        this.congestionControl.onRttMeasurement(nowNs, rttInNs, srcAddress);
    }

    boolean isAcceptingSubscriptions() {
        return this.subscriberPositions.length > 0 && (this.state == State.ACTIVE || this.state == State.INIT);
    }

    long rebuildPosition() {
        return this.rebuildPosition.get();
    }

    @Override
    public void onTimeEvent(long timeNs, long timesMs, DriverConductor conductor) {
        switch (this.state) {
            case ACTIVE: {
                this.checkUntetheredSubscriptions(timeNs, conductor);
                break;
            }
            case INACTIVE: {
                if (this.isDrained()) {
                    this.state = State.LINGER;
                    this.timeOfLastStateChangeNs = timeNs;
                    conductor.transitionToLinger(this);
                }
                this.isTrackingRebuild = false;
                break;
            }
            case LINGER: {
                if (!this.hasNoSubscribers() && this.timeOfLastStateChangeNs + this.imageLivenessTimeoutNs - timeNs >= 0L) break;
                this.state = State.DONE;
                conductor.cleanupImage(this);
            }
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return State.DONE == this.state;
    }

    private boolean isDrained() {
        long rebuildPosition = this.rebuildPosition.get();
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            if (subscriberPosition.getVolatile() >= rebuildPosition) continue;
            return false;
        }
        return true;
    }

    private boolean hasNoSubscribers() {
        return this.subscriberPositions.length == 0;
    }

    private boolean isFlowControlUnderRun(long packetPosition) {
        boolean isFlowControlUnderRun;
        boolean bl = isFlowControlUnderRun = packetPosition < this.lastSmPosition;
        if (isFlowControlUnderRun) {
            this.flowControlUnderRuns.incrementOrdered();
        }
        return isFlowControlUnderRun;
    }

    private boolean isFlowControlOverRun(long proposedPosition) {
        boolean isFlowControlOverRun;
        boolean bl = isFlowControlOverRun = proposedPosition > this.lastSmWindowLimit;
        if (isFlowControlOverRun) {
            this.flowControlOverRuns.incrementOrdered();
        }
        return isFlowControlOverRun;
    }

    private void cleanBufferTo(long position) {
        long cleanPosition = this.cleanPosition;
        if (position > cleanPosition) {
            int bytesForCleaning = (int)(position - cleanPosition);
            UnsafeBuffer dirtyTerm = this.termBuffers[LogBufferDescriptor.indexByPosition((long)cleanPosition, (int)this.positionBitsToShift)];
            int termOffset = (int)cleanPosition & this.termLengthMask;
            int length = Math.min(bytesForCleaning, dirtyTerm.capacity() - termOffset);
            dirtyTerm.setMemory(termOffset, length - 8, (byte)0);
            dirtyTerm.putLongOrdered(termOffset + (length - 8), 0L);
            this.cleanPosition = cleanPosition + (long)length;
        }
    }

    private void trackConnection(int transportIndex, InetSocketAddress srcAddress, long nowNs) {
        this.imageConnections = (ImageConnection[])ArrayUtil.ensureCapacity((Object[])this.imageConnections, (int)(transportIndex + 1));
        ImageConnection imageConnection = this.imageConnections[transportIndex];
        if (null == imageConnection) {
            this.imageConnections[transportIndex] = imageConnection = new ImageConnection(nowNs, srcAddress);
        }
        imageConnection.timeOfLastActivityNs = nowNs;
        imageConnection.timeOfLastFrameNs = nowNs;
    }

    private boolean allEos(int transportIndex) {
        this.imageConnections[transportIndex].isEos = true;
        int length = this.imageConnections.length;
        for (int i = 0; i < length; ++i) {
            ImageConnection imageConnection = this.imageConnections[i];
            if (null != imageConnection && !imageConnection.isEos) {
                return false;
            }
            if (null != imageConnection || !this.channelEndpoint.hasDestination(i)) continue;
            return false;
        }
        return true;
    }

    private void state(State state) {
        this.timeOfLastStateChangeNs = this.cachedNanoClock.nanoTime();
        this.state = state;
    }

    private void scheduleStatusMessage(long nowNs, long smPosition, int receiverWindowLength) {
        long changeNumber;
        this.beginSmChange = changeNumber = this.beginSmChange + 1L;
        this.nextSmPosition = smPosition;
        this.nextSmReceiverWindowLength = receiverWindowLength;
        this.endSmChange = changeNumber;
        this.timeOfLastStatusMessageScheduleNs = nowNs;
    }

    private void checkUntetheredSubscriptions(long nowNs, DriverConductor conductor) {
        int lastIndex;
        ArrayList untetheredSubscriptions = this.untetheredSubscriptions;
        int untetheredSubscriptionsSize = untetheredSubscriptions.size();
        if (0 == untetheredSubscriptionsSize) {
            return;
        }
        long maxConsumerPosition = 0L;
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            long position = subscriberPosition.getVolatile();
            if (position <= maxConsumerPosition) continue;
            maxConsumerPosition = position;
        }
        int windowLength = this.nextSmReceiverWindowLength;
        long untetheredWindowLimit = maxConsumerPosition - (long)windowLength + (long)(windowLength >> 3);
        block6: for (int i = lastIndex = untetheredSubscriptionsSize - 1; i >= 0; --i) {
            UntetheredSubscription untethered = (UntetheredSubscription)untetheredSubscriptions.get(i);
            switch (untethered.state) {
                case 0: {
                    if (untethered.position.getVolatile() > untetheredWindowLimit) {
                        untethered.timeOfLastUpdateNs = nowNs;
                        continue block6;
                    }
                    if (untethered.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - nowNs > 0L) continue block6;
                    conductor.notifyUnavailableImageLink(this.correlationId, untethered.subscriptionLink);
                    untethered.state = 1;
                    untethered.timeOfLastUpdateNs = nowNs;
                    continue block6;
                }
                case 1: {
                    if (untethered.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - nowNs > 0L) continue block6;
                    this.subscriberPositions = (ReadablePosition[])ArrayUtil.remove((Object[])this.subscriberPositions, (Object)untethered.position);
                    untethered.state = 2;
                    untethered.timeOfLastUpdateNs = nowNs;
                    continue block6;
                }
                case 2: {
                    if (untethered.timeOfLastUpdateNs + this.untetheredRestingTimeoutNs - nowNs > 0L) continue block6;
                    this.subscriberPositions = (ReadablePosition[])ArrayUtil.add((Object[])this.subscriberPositions, (Object)untethered.position);
                    conductor.notifyAvailableImageLink(this.correlationId, this.sessionId, untethered.subscriptionLink, untethered.position.id(), this.rebuildPosition.get(), this.rawLog.fileName(), Configuration.sourceIdentity(this.sourceAddress));
                    untethered.state = 0;
                    untethered.timeOfLastUpdateNs = nowNs;
                }
            }
        }
    }

    private void updateActiveTransportCount() {
        long nowNs = this.cachedNanoClock.nanoTime();
        int activeTransportCount = 0;
        for (ImageConnection imageConnection : this.imageConnections) {
            if (null == imageConnection || nowNs >= imageConnection.timeOfLastFrameNs + this.imageLivenessTimeoutNs) continue;
            ++activeTransportCount;
        }
        LogBufferDescriptor.activeTransportCount((UnsafeBuffer)this.rawLog.metaData(), (int)activeTransportCount);
    }

    private ReadablePosition[] positionArray(ArrayList<SubscriberPosition> subscriberPositions, long nowNs) {
        int size = subscriberPositions.size();
        ReadablePosition[] positions = new ReadablePosition[subscriberPositions.size()];
        for (int i = 0; i < size; ++i) {
            SubscriberPosition subscriberPosition = subscriberPositions.get(i);
            positions[i] = subscriberPosition.position();
            if (subscriberPosition.subscription().isTether()) continue;
            this.untetheredSubscriptions.add(new UntetheredSubscription(subscriberPosition.subscription(), (ReadablePosition)subscriberPosition.position(), nowNs));
        }
        return positions;
    }

    static enum State {
        INIT,
        ACTIVE,
        INACTIVE,
        LINGER,
        DONE;

    }
}

