/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.PublicationImage;
import io.aeron.driver.Receiver;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationUdpTransport;
import io.aeron.driver.media.UdpChannel;
import java.util.Queue;
import org.agrona.concurrent.status.AtomicCounter;

public class ReceiverProxy {
    private final ThreadingMode threadingMode;
    private final Queue<Runnable> commandQueue;
    private final AtomicCounter failCount;
    private Receiver receiver;

    public ReceiverProxy(ThreadingMode threadingMode, Queue<Runnable> commandQueue, AtomicCounter failCount) {
        this.threadingMode = threadingMode;
        this.commandQueue = commandQueue;
        this.failCount = failCount;
    }

    public void receiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public Receiver receiver() {
        return this.receiver;
    }

    public void addSubscription(ReceiveChannelEndpoint mediaEndpoint, int streamId) {
        if (this.notConcurrent()) {
            this.receiver.onAddSubscription(mediaEndpoint, streamId);
        } else {
            this.offer(() -> this.receiver.onAddSubscription(mediaEndpoint, streamId));
        }
    }

    public void addSubscription(ReceiveChannelEndpoint mediaEndpoint, int streamId, int sessionId) {
        if (this.notConcurrent()) {
            this.receiver.onAddSubscription(mediaEndpoint, streamId, sessionId);
        } else {
            this.offer(() -> this.receiver.onAddSubscription(mediaEndpoint, streamId, sessionId));
        }
    }

    public void removeSubscription(ReceiveChannelEndpoint mediaEndpoint, int streamId) {
        if (this.notConcurrent()) {
            this.receiver.onRemoveSubscription(mediaEndpoint, streamId);
        } else {
            this.offer(() -> this.receiver.onRemoveSubscription(mediaEndpoint, streamId));
        }
    }

    public void removeSubscription(ReceiveChannelEndpoint mediaEndpoint, int streamId, int sessionId) {
        if (this.notConcurrent()) {
            this.receiver.onRemoveSubscription(mediaEndpoint, streamId, sessionId);
        } else {
            this.offer(() -> this.receiver.onRemoveSubscription(mediaEndpoint, streamId, sessionId));
        }
    }

    public void newPublicationImage(ReceiveChannelEndpoint channelEndpoint, PublicationImage image) {
        if (this.notConcurrent()) {
            this.receiver.onNewPublicationImage(channelEndpoint, image);
        } else {
            this.offer(() -> this.receiver.onNewPublicationImage(channelEndpoint, image));
        }
    }

    public void registerReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        if (this.notConcurrent()) {
            this.receiver.onRegisterReceiveChannelEndpoint(channelEndpoint);
        } else {
            this.offer(() -> this.receiver.onRegisterReceiveChannelEndpoint(channelEndpoint));
        }
    }

    public void closeReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        if (this.notConcurrent()) {
            this.receiver.onCloseReceiveChannelEndpoint(channelEndpoint);
        } else {
            this.offer(() -> this.receiver.onCloseReceiveChannelEndpoint(channelEndpoint));
        }
    }

    public void removeCoolDown(ReceiveChannelEndpoint channelEndpoint, int sessionId, int streamId) {
        if (this.notConcurrent()) {
            this.receiver.onRemoveCoolDown(channelEndpoint, sessionId, streamId);
        } else {
            this.offer(() -> this.receiver.onRemoveCoolDown(channelEndpoint, sessionId, streamId));
        }
    }

    public void addDestination(ReceiveChannelEndpoint channelEndpoint, ReceiveDestinationUdpTransport transport) {
        if (this.notConcurrent()) {
            this.receiver.onAddDestination(channelEndpoint, transport);
        } else {
            this.offer(() -> this.receiver.onAddDestination(channelEndpoint, transport));
        }
    }

    public void removeDestination(ReceiveChannelEndpoint channelEndpoint, UdpChannel udpChannel) {
        if (this.notConcurrent()) {
            this.receiver.onRemoveDestination(channelEndpoint, udpChannel);
        } else {
            this.offer(() -> this.receiver.onRemoveDestination(channelEndpoint, udpChannel));
        }
    }

    private boolean notConcurrent() {
        return this.threadingMode == ThreadingMode.SHARED || this.threadingMode == ThreadingMode.INVOKER;
    }

    private void offer(Runnable cmd) {
        while (!this.commandQueue.offer(cmd) && !Thread.currentThread().isInterrupted()) {
            this.failCount.incrementOrdered();
            Thread.yield();
        }
    }
}

