/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.NetworkPublication;
import io.aeron.driver.Sender;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.media.SendChannelEndpoint;
import java.net.InetSocketAddress;
import java.util.Queue;
import org.agrona.concurrent.status.AtomicCounter;

public class SenderProxy {
    private final ThreadingMode threadingMode;
    private final Queue<Runnable> commandQueue;
    private final AtomicCounter failCount;
    private Sender sender;

    public SenderProxy(ThreadingMode threadingMode, Queue<Runnable> commandQueue, AtomicCounter failCount) {
        this.threadingMode = threadingMode;
        this.commandQueue = commandQueue;
        this.failCount = failCount;
    }

    public void sender(Sender sender) {
        this.sender = sender;
    }

    public void registerSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
        if (this.notConcurrent()) {
            this.sender.onRegisterSendChannelEndpoint(channelEndpoint);
        } else {
            this.offer(() -> this.sender.onRegisterSendChannelEndpoint(channelEndpoint));
        }
    }

    public void closeSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
        if (this.notConcurrent()) {
            this.sender.onCloseSendChannelEndpoint(channelEndpoint);
        } else {
            this.offer(() -> this.sender.onCloseSendChannelEndpoint(channelEndpoint));
        }
    }

    public void removeNetworkPublication(NetworkPublication publication) {
        if (this.notConcurrent()) {
            this.sender.onRemoveNetworkPublication(publication);
        } else {
            this.offer(() -> this.sender.onRemoveNetworkPublication(publication));
        }
    }

    public void newNetworkPublication(NetworkPublication publication) {
        if (this.notConcurrent()) {
            this.sender.onNewNetworkPublication(publication);
        } else {
            this.offer(() -> this.sender.onNewNetworkPublication(publication));
        }
    }

    public void addDestination(SendChannelEndpoint channelEndpoint, InetSocketAddress address) {
        if (this.notConcurrent()) {
            this.sender.onAddDestination(channelEndpoint, address);
        } else {
            this.offer(() -> this.sender.onAddDestination(channelEndpoint, address));
        }
    }

    public void removeDestination(SendChannelEndpoint channelEndpoint, InetSocketAddress address) {
        if (this.notConcurrent()) {
            this.sender.onRemoveDestination(channelEndpoint, address);
        } else {
            this.offer(() -> this.sender.onRemoveDestination(channelEndpoint, address));
        }
    }

    private boolean notConcurrent() {
        return this.threadingMode == ThreadingMode.SHARED || this.threadingMode == ThreadingMode.INVOKER;
    }

    private void offer(Runnable cmd) {
        while (!this.commandQueue.offer(cmd) && !Thread.currentThread().isInterrupted()) {
            this.failCount.incrementOrdered();
            Thread.yield();
        }
    }
}

