/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.NetworkUtil;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.media.UdpTransportPoller;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class DataTransportPoller
extends UdpTransportPoller {
    private final ByteBuffer byteBuffer;
    private final UnsafeBuffer unsafeBuffer;
    private final DataHeaderFlyweight dataMessage;
    private final SetupFlyweight setupMessage;
    private final RttMeasurementFlyweight rttMeasurement;
    private ChannelAndTransport[] channelAndTransports = new ChannelAndTransport[0];

    public DataTransportPoller() {
        this.byteBuffer = NetworkUtil.allocateDirectAlignedAndPadded(65504, 128);
        this.unsafeBuffer = new UnsafeBuffer(this.byteBuffer);
        this.dataMessage = new DataHeaderFlyweight(this.unsafeBuffer);
        this.setupMessage = new SetupFlyweight(this.unsafeBuffer);
        this.rttMeasurement = new RttMeasurementFlyweight(this.unsafeBuffer);
    }

    public void close() {
        for (ChannelAndTransport channelEndpoint : this.channelAndTransports) {
            channelEndpoint.channelEndpoint.closeMultiRcvDestination(this);
            channelEndpoint.channelEndpoint.close();
        }
        super.close();
    }

    @Override
    public int pollTransports() {
        int bytesReceived = 0;
        try {
            if (this.channelAndTransports.length <= 5) {
                for (ChannelAndTransport channelAndTransport : this.channelAndTransports) {
                    bytesReceived += this.poll(channelAndTransport);
                }
            } else {
                this.selector.selectNow();
                SelectionKey[] keys = this.selectedKeySet.keys();
                int length = this.selectedKeySet.size();
                for (int i = 0; i < length; ++i) {
                    bytesReceived += this.poll((ChannelAndTransport)keys[i].attachment());
                }
                this.selectedKeySet.reset();
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return bytesReceived;
    }

    @Override
    public SelectionKey registerForRead(UdpChannelTransport transport) {
        return this.registerForRead((ReceiveChannelEndpoint)transport, transport, 0);
    }

    public SelectionKey registerForRead(ReceiveChannelEndpoint channelEndpoint, UdpChannelTransport transport, int transportIndex) {
        SelectionKey key = null;
        try {
            ChannelAndTransport channelAndTransport = new ChannelAndTransport(channelEndpoint, transport, transportIndex);
            key = transport.receiveDatagramChannel().register(this.selector, 1, channelAndTransport);
            this.channelAndTransports = (ChannelAndTransport[])ArrayUtil.add((Object[])this.channelAndTransports, (Object)channelAndTransport);
        }
        catch (ClosedChannelException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return key;
    }

    @Override
    public void cancelRead(UdpChannelTransport transport) {
        this.cancelRead((ReceiveChannelEndpoint)transport, transport);
    }

    public void cancelRead(ReceiveChannelEndpoint channelEndpoint, UdpChannelTransport transport) {
        Object[] transports = this.channelAndTransports;
        int index = -1;
        int length = transports.length;
        for (int i = 0; i < length; ++i) {
            if (channelEndpoint != transports[i].channelEndpoint || transport != ((ChannelAndTransport)transports[i]).transport) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.channelAndTransports = (ChannelAndTransport[])ArrayUtil.remove((Object[])transports, (int)index);
        }
    }

    private int poll(ChannelAndTransport channelAndTransport) {
        int length;
        ReceiveChannelEndpoint channelEndpoint;
        int bytesReceived = 0;
        InetSocketAddress srcAddress = channelAndTransport.transport.receive(this.byteBuffer);
        if (null != srcAddress && (channelEndpoint = channelAndTransport.channelEndpoint).isValidFrame(this.unsafeBuffer, length = this.byteBuffer.position())) {
            channelEndpoint.receiveHook(this.unsafeBuffer, length, srcAddress);
            int transportIndex = channelAndTransport.transportIndex;
            int frameType = FrameDescriptor.frameType((UnsafeBuffer)this.unsafeBuffer, (int)0);
            if (1 == frameType || 0 == frameType) {
                bytesReceived = channelEndpoint.onDataPacket(this.dataMessage, this.unsafeBuffer, length, srcAddress, transportIndex);
            } else if (5 == frameType) {
                channelEndpoint.onSetupMessage(this.setupMessage, this.unsafeBuffer, length, srcAddress, transportIndex);
            } else if (6 == frameType) {
                channelEndpoint.onRttMeasurement(this.rttMeasurement, this.unsafeBuffer, length, srcAddress, transportIndex);
            }
        }
        return bytesReceived;
    }

    static class ChannelAndTransport {
        final ReceiveChannelEndpoint channelEndpoint;
        final UdpChannelTransport transport;
        final int transportIndex;

        ChannelAndTransport(ReceiveChannelEndpoint channelEndpoint, UdpChannelTransport transport, int transportIndex) {
            this.channelEndpoint = channelEndpoint;
            this.transport = transport;
            this.transportIndex = transportIndex;
        }
    }
}

