/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import java.net.InetSocketAddress;
import org.agrona.AsciiEncoding;

class SocketAddressParser {
    SocketAddressParser() {
    }

    static InetSocketAddress parse(CharSequence cs) {
        if (null == cs || cs.length() == 0) {
            throw new NullPointerException("input string must not be null or empty");
        }
        InetSocketAddress address = SocketAddressParser.tryParseIpV4(cs);
        if (null == address) {
            address = SocketAddressParser.tryParseIpV6(cs);
        }
        if (null == address) {
            throw new IllegalArgumentException("invalid format: " + cs);
        }
        return address;
    }

    private static InetSocketAddress tryParseIpV4(CharSequence cs) {
        IpV4State state = IpV4State.HOST;
        int separatorIndex = -1;
        int length = cs.length();
        block4: for (int i = 0; i < length; ++i) {
            char c = cs.charAt(i);
            switch (state) {
                case HOST: {
                    if (':' != c) continue block4;
                    separatorIndex = i;
                    state = IpV4State.PORT;
                    continue block4;
                }
                case PORT: {
                    if (':' == c) {
                        return null;
                    }
                    if (c >= '0' && '9' >= c) continue block4;
                    return null;
                }
            }
        }
        if (-1 != separatorIndex && 1 < length - separatorIndex) {
            String hostname = cs.subSequence(0, separatorIndex).toString();
            int portIndex = separatorIndex + 1;
            int port = AsciiEncoding.parseIntAscii((CharSequence)cs, (int)portIndex, (int)(length - portIndex));
            return new InetSocketAddress(hostname, port);
        }
        throw new IllegalArgumentException("'port' part of the address is required for ipv4: " + cs);
    }

    private static InetSocketAddress tryParseIpV6(CharSequence cs) {
        IpV6State state = IpV6State.START_ADDR;
        int portIndex = -1;
        int scopeIndex = -1;
        int length = cs.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = cs.charAt(i);
            switch (state) {
                case START_ADDR: {
                    if ('[' == c) {
                        state = IpV6State.HOST;
                        continue block7;
                    }
                    return null;
                }
                case HOST: {
                    if (']' == c) {
                        state = IpV6State.END_ADDR;
                        continue block7;
                    }
                    if ('%' == c) {
                        scopeIndex = i;
                        state = IpV6State.SCOPE;
                        continue block7;
                    }
                    if (':' == c || c >= 'a' && 'f' >= c || c >= 'A' && 'F' >= c || c >= '0' && '9' >= c) continue block7;
                    return null;
                }
                case SCOPE: {
                    if (']' == c) {
                        state = IpV6State.END_ADDR;
                        continue block7;
                    }
                    if ('_' == c || '.' == c || '~' == c || '-' == c || c >= 'a' && 'z' >= c || c >= 'A' && 'Z' >= c || c >= '0' && '9' >= c) continue block7;
                    return null;
                }
                case END_ADDR: {
                    if (':' == c) {
                        portIndex = i;
                        state = IpV6State.PORT;
                        continue block7;
                    }
                    return null;
                }
                case PORT: {
                    if (':' == c) {
                        return null;
                    }
                    if (c >= '0' && '9' >= c) continue block7;
                    return null;
                }
            }
        }
        if (-1 != portIndex && 1 < length - portIndex) {
            String hostname = cs.subSequence(1, scopeIndex != -1 ? scopeIndex : portIndex - 1).toString();
            int port = AsciiEncoding.parseIntAscii((CharSequence)cs, (int)(++portIndex), (int)(length - portIndex));
            return new InetSocketAddress(hostname, port);
        }
        throw new IllegalArgumentException("'port' part of the address is required for ipv6: " + cs);
    }

    static enum IpV6State {
        START_ADDR,
        HOST,
        SCOPE,
        END_ADDR,
        PORT;

    }

    static enum IpV4State {
        HOST,
        PORT;

    }
}

