/*
 * Decompiled with CFR 0.152.
 */
package io.agodadev.testmetricsscala;

import io.agodadev.testmetricsscala.GitContext;
import io.agodadev.testmetricsscala.GitContextException;
import io.agodadev.testmetricsscala.GitContextException$;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class GitContextReader$ {
    public static final GitContextReader$ MODULE$ = new GitContextReader$();

    public GitContext getGitContext() {
        String url = this.runCommand("config --get remote.origin.url");
        String branch = (String)package$.MODULE$.env().getOrElse((Object)"CI_COMMIT_REF_NAME", (Function0 & Serializable)() -> MODULE$.runCommand("rev-parse --abbrev-ref HEAD"));
        if (url.isEmpty()) {
            throw new GitContextException("Unable to get git remote url.", GitContextException$.MODULE$.$lessinit$greater$default$2());
        }
        if (branch.isEmpty()) {
            throw new GitContextException("Unable to get git branch.", GitContextException$.MODULE$.$lessinit$greater$default$2());
        }
        String cleanedUrl = this.cleanGitlabCIToken(url);
        return new GitContext(cleanedUrl, this.getRepositoryNameFromUrl(cleanedUrl), branch);
    }

    private String runCommand(String args) {
        String gitCommand = ((String)package$.MODULE$.props().apply((Object)"os.name")).toLowerCase().contains("win") ? "git.exe" : "git";
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(1).append(gitCommand).append(" ").append(args).toString()).$bang$bang().trim());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String output = (String)success.value();
            return output;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            throw new GitContextException("Failed to run git command.", ex);
        }
        throw new MatchError((Object)try_);
    }

    private String getRepositoryNameFromUrl(String url) {
        String repositoryName = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(url), '/')));
        if (repositoryName.endsWith(".git")) {
            return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(repositoryName), 4);
        }
        return repositoryName;
    }

    private String cleanGitlabCIToken(String url) {
        if (url.contains("@") && url.startsWith("https")) {
            return new StringBuilder(8).append("https://").append(ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(url), '@')))).toString();
        }
        return url;
    }

    private GitContextReader$() {
    }
}

