/*
 * Decompiled with CFR 0.152.
 */
package io.agrest;

import io.agrest.AgException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AgExceptionTest {
    @Test
    public void testOf() {
        AgException e = AgException.of((int)101, (String)"a %s b", (Object[])new Object[]{"X"});
        Assertions.assertEquals((Object)"a X b", (Object)e.getMessage());
        Assertions.assertNull((Object)e.getCause());
        Assertions.assertEquals((int)101, (int)e.getStatus());
    }

    @Test
    public void testOf_Exception() {
        Throwable cause = new Throwable();
        AgException e = AgException.of((int)101, (Throwable)cause, (String)"a %s b", (Object[])new Object[]{"X"});
        Assertions.assertEquals((Object)"a X b", (Object)e.getMessage());
        Assertions.assertSame((Object)cause, (Object)e.getCause());
        Assertions.assertEquals((int)101, (int)e.getStatus());
    }

    @Test
    public void testBadRequest() {
        AgException e = AgException.badRequest();
        Assertions.assertNull((Object)e.getMessage());
        Assertions.assertNull((Object)e.getCause());
        Assertions.assertEquals((int)400, (int)e.getStatus());
    }

    @Test
    public void testBadRequest_Message() {
        AgException e = AgException.badRequest((String)"a %s b", (Object[])new Object[]{"X"});
        Assertions.assertEquals((Object)"a X b", (Object)e.getMessage());
        Assertions.assertNull((Object)e.getCause());
        Assertions.assertEquals((int)400, (int)e.getStatus());
    }

    @Test
    public void testBadRequest_Exception() {
        Throwable cause = new Throwable();
        AgException e = AgException.badRequest((Throwable)cause, (String)"a %s b", (Object[])new Object[]{"X"});
        Assertions.assertEquals((Object)"a X b", (Object)e.getMessage());
        Assertions.assertSame((Object)cause, (Object)e.getCause());
        Assertions.assertEquals((int)400, (int)e.getStatus());
    }

    @Test
    public void testForbidden() {
        AgException e = AgException.forbidden((String)"a %s b", (Object[])new Object[]{"X"});
        Assertions.assertEquals((Object)"a X b", (Object)e.getMessage());
        Assertions.assertNull((Object)e.getCause());
        Assertions.assertEquals((int)403, (int)e.getStatus());
    }

    @Test
    public void testForbidden_Exception() {
        Throwable cause = new Throwable();
        AgException e = AgException.forbidden((Throwable)cause, (String)"a %s b", (Object[])new Object[]{"X"});
        Assertions.assertEquals((Object)"a X b", (Object)e.getMessage());
        Assertions.assertSame((Object)cause, (Object)e.getCause());
        Assertions.assertEquals((int)403, (int)e.getStatus());
    }
}

