/*
 * Decompiled with CFR 0.152.
 */
package io.agrest;

import io.agrest.RootResourceEntity;
import io.agrest.meta.AgEntity;
import io.agrest.pojo.model.P1;
import io.agrest.protocol.Exp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ResourceEntityTest {
    private <T> AgEntity<T> mockEntity(Class<T> type) {
        AgEntity entity = (AgEntity)Mockito.mock(AgEntity.class);
        Mockito.when((Object)entity.getName()).thenReturn((Object)"mock");
        Mockito.when((Object)entity.getType()).thenReturn(type);
        return entity;
    }

    @Test
    public void testQualifier() {
        RootResourceEntity e = new RootResourceEntity(this.mockEntity(P1.class));
        Assertions.assertNull((Object)e.getExp());
        e.andExp(Exp.simple((String)"a = 1"));
        Assertions.assertEquals((Object)Exp.simple((String)"a = 1"), (Object)e.getExp());
        e.andExp(Exp.simple((String)"b = 2"));
        Assertions.assertEquals((Object)Exp.simple((String)"a = 1").and(Exp.simple((String)"b = 2")), (Object)e.getExp());
    }

    @Test
    public void testGetDataWindow_NoOffsetLimit() {
        List<P1> data = Arrays.asList(new P1(), new P1(), new P1());
        RootResourceEntity e = new RootResourceEntity(this.mockEntity(P1.class));
        Assertions.assertSame(data, (Object)e.getDataWindow(data));
    }

    @Test
    public void testGetDataWindow_Offset() {
        List<P1> data = Arrays.asList(new P1(), new P1(), new P1());
        RootResourceEntity e = new RootResourceEntity(this.mockEntity(P1.class));
        e.setStart(1);
        Assertions.assertEquals(Arrays.asList(data.get(1), data.get(2)), (Object)e.getDataWindow(data));
    }

    @Test
    public void testGetDataWindow_OffsetPastEnd() {
        List<P1> data = Arrays.asList(new P1(), new P1(), new P1());
        RootResourceEntity e = new RootResourceEntity(this.mockEntity(P1.class));
        e.setStart(4);
        Assertions.assertEquals(Collections.emptyList(), (Object)e.getDataWindow(data));
    }

    @Test
    public void testGetDataWindow_Limit() {
        List<P1> data = Arrays.asList(new P1(), new P1(), new P1());
        RootResourceEntity e = new RootResourceEntity(this.mockEntity(P1.class));
        e.setLimit(2);
        Assertions.assertEquals(Arrays.asList(data.get(0), data.get(1)), (Object)e.getDataWindow(data));
    }

    @Test
    public void testGetDataWindow_LimitPastEnd() {
        List<P1> data = Arrays.asList(new P1(), new P1(), new P1());
        RootResourceEntity e = new RootResourceEntity(this.mockEntity(P1.class));
        e.setLimit(4);
        Assertions.assertEquals(Arrays.asList(data.get(0), data.get(1), data.get(2)), (Object)e.getDataWindow(data));
    }

    @Test
    public void testGetDataWindow_OffsetLimit() {
        List<P1> data = Arrays.asList(new P1(), new P1(), new P1());
        RootResourceEntity e = new RootResourceEntity(this.mockEntity(P1.class));
        e.setStart(1);
        e.setLimit(1);
        Assertions.assertEquals(Arrays.asList(data.get(1)), (Object)e.getDataWindow(data));
    }

    @Test
    public void testGetDataWindow_OffsetNegativeLimit() {
        List<P1> data = Arrays.asList(new P1(), new P1(), new P1());
        RootResourceEntity e = new RootResourceEntity(this.mockEntity(P1.class));
        e.setStart(1);
        e.setLimit(-5);
        Assertions.assertEquals(Arrays.asList(data.get(1), data.get(2)), (Object)e.getDataWindow(data));
    }

    @Test
    public void testGetDataWindow_LimitNegativeOffset() {
        List<P1> data = Arrays.asList(new P1(), new P1(), new P1());
        RootResourceEntity e = new RootResourceEntity(this.mockEntity(P1.class));
        e.setLimit(2);
        e.setStart(-2);
        Assertions.assertEquals(Arrays.asList(data.get(0), data.get(1)), (Object)e.getDataWindow(data));
    }
}

