/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.access;

import io.agrest.access.PropertyFilteringRulesBuilder;
import io.agrest.junit.AgPojoTester;
import io.agrest.meta.AgEntity;
import io.agrest.pojo.model.P11;
import io.bootique.junit5.BQTest;
import io.bootique.junit5.BQTestTool;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@BQTest
public class PropertyFilteringRulesBuilderTest {
    @BQTestTool
    static final AgPojoTester tester = AgPojoTester.builder().build();

    @Test
    public void testDefault_AllAvailable() {
        PropertyFilteringRulesBuilder pab = new PropertyFilteringRulesBuilder();
        Assertions.assertEquals(Map.of(), (Object)pab.resolveInaccessible(tester.entity(P11.class), AgEntity.overlay(P11.class)));
    }

    @Test
    public void testDefault_AllAvailable_WithOverlay() {
        PropertyFilteringRulesBuilder pab = new PropertyFilteringRulesBuilder();
        Assertions.assertEquals(Map.of(), (Object)pab.resolveInaccessible(tester.entity(P11.class), AgEntity.overlay(P11.class).attribute("x", String.class, p11 -> "a")));
    }

    @Test
    public void testEmpty() {
        PropertyFilteringRulesBuilder pab = new PropertyFilteringRulesBuilder().empty();
        Assertions.assertEquals(Map.of("id", false, "intProp", false, "p6", false), (Object)pab.resolveInaccessible(tester.entity(P11.class), AgEntity.overlay(P11.class)));
    }

    @Test
    public void testIdOnly() {
        PropertyFilteringRulesBuilder pab = new PropertyFilteringRulesBuilder().idOnly();
        Assertions.assertEquals((Object)pab.resolveInaccessible(tester.entity(P11.class), AgEntity.overlay(P11.class)), Map.of("intProp", false, "p6", false, "id", true));
    }

    @Test
    public void testId() {
        PropertyFilteringRulesBuilder pab = new PropertyFilteringRulesBuilder().empty().id(true);
        Assertions.assertEquals(Map.of("intProp", false, "p6", false, "id", true), (Object)pab.resolveInaccessible(tester.entity(P11.class), AgEntity.overlay(P11.class)));
    }

    @Test
    public void testAllButId() {
        PropertyFilteringRulesBuilder pab = new PropertyFilteringRulesBuilder().empty().attributes(true).relationships(true);
        Assertions.assertEquals(Map.of("id", false, "p6", true, "intProp", true), (Object)pab.resolveInaccessible(tester.entity(P11.class), AgEntity.overlay(P11.class)));
    }

    @Test
    public void testExcludeByName() {
        PropertyFilteringRulesBuilder pab = new PropertyFilteringRulesBuilder().property("intProp", false);
        Assertions.assertEquals(Map.of("intProp", false), (Object)pab.resolveInaccessible(tester.entity(P11.class), AgEntity.overlay(P11.class)));
    }

    @Test
    public void testExcludeByName_InOverlay() {
        PropertyFilteringRulesBuilder pab = new PropertyFilteringRulesBuilder().property("x", false);
        Assertions.assertEquals(Map.of("x", false), (Object)pab.resolveInaccessible(tester.entity(P11.class), AgEntity.overlay(P11.class).attribute("x", String.class, p11 -> "a")));
    }
}

