/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.compiler;

import io.agrest.compiler.AgEntityCompiler;
import io.agrest.compiler.AnnotationsAgEntityBuilder;
import io.agrest.compiler.AnnotationsAgEntityCompiler;
import io.agrest.meta.AgAttribute;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgRelationship;
import io.agrest.meta.AgSchema;
import io.agrest.meta.LazySchema;
import io.agrest.pojo.model.P3;
import io.agrest.pojo.model.P4;
import io.agrest.pojo.model.P5;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class AnnotationsAgEntityBuilderTest {
    private static Collection<AgEntityCompiler> COMPILERS;

    @BeforeAll
    public static void setUpClass() {
        COMPILERS = Arrays.asList(new AnnotationsAgEntityCompiler(Collections.emptyMap()));
    }

    @Test
    public void testBuild_Default() {
        AgEntity p3e = new AnnotationsAgEntityBuilder(P3.class, (AgSchema)new LazySchema(COMPILERS)).build();
        Assertions.assertNotNull((Object)p3e);
        Assertions.assertEquals((Object)"P3", (Object)p3e.getName());
        Assertions.assertEquals((int)0, (int)p3e.getRelationships().size());
        Assertions.assertEquals((int)1, (int)p3e.getAttributes().size());
        AgAttribute name = p3e.getAttribute("name");
        Assertions.assertNotNull((Object)name);
        Assertions.assertEquals((Object)"name", (Object)name.getName());
        Assertions.assertEquals(String.class, (Object)name.getType());
    }

    @Test
    public void testToOneRelationship() {
        AgEntity p4e = new AnnotationsAgEntityBuilder(P4.class, (AgSchema)new LazySchema(COMPILERS)).build();
        Assertions.assertNotNull((Object)p4e);
        Assertions.assertEquals((Object)"P4", (Object)p4e.getName());
        Assertions.assertEquals((int)1, (int)p4e.getRelationships().size());
        Assertions.assertEquals((int)0, (int)p4e.getAttributes().size());
        AgRelationship p3r = p4e.getRelationship("p3");
        Assertions.assertNotNull((Object)p3r);
        Assertions.assertEquals(P3.class, (Object)p3r.getTargetEntity().getType());
        Assertions.assertFalse((boolean)p3r.isToMany());
    }

    @Test
    public void testToManyRelationship() {
        AgEntity p5e = new AnnotationsAgEntityBuilder(P5.class, (AgSchema)new LazySchema(COMPILERS)).build();
        Assertions.assertNotNull((Object)p5e);
        Assertions.assertEquals((Object)"P5", (Object)p5e.getName());
        Assertions.assertEquals((int)1, (int)p5e.getRelationships().size());
        Assertions.assertEquals((int)0, (int)p5e.getAttributes().size());
        AgRelationship p4sr = p5e.getRelationship("p4s");
        Assertions.assertNotNull((Object)p4sr);
        Assertions.assertEquals(P4.class, (Object)p4sr.getTargetEntity().getType());
        Assertions.assertTrue((boolean)p4sr.isToMany());
    }
}

