/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.compiler;

import io.agrest.annotation.AgAttribute;
import io.agrest.annotation.AgId;
import io.agrest.compiler.AgEntityCompiler;
import io.agrest.compiler.AnnotationsAgEntityCompiler;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgSchema;
import io.agrest.meta.LazySchema;
import io.agrest.pojo.model.P8;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class AnnotationsAgEntityCompilerTest {
    private static Collection<AgEntityCompiler> compilers;

    @BeforeAll
    public static void setUpClass() {
        compilers = new ArrayList<AgEntityCompiler>();
        compilers.add((AgEntityCompiler)new AnnotationsAgEntityCompiler(Collections.emptyMap()));
    }

    @Test
    public void testCompile() {
        AgEntity entity = new AnnotationsAgEntityCompiler(Collections.emptyMap()).compile(Entity.class, (AgSchema)new LazySchema(compilers));
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((int)1, (int)entity.getIdParts().size());
        Assertions.assertEquals((int)1, (int)entity.getAttributes().size());
        Assertions.assertEquals((int)0, (int)entity.getRelationships().size());
    }

    @Test
    public void testCompile_CollectionAttributes() {
        AgEntity entity = new AnnotationsAgEntityCompiler(Collections.emptyMap()).compile(P8.class, (AgSchema)new LazySchema(compilers));
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((int)1, (int)entity.getIdParts().size());
        Assertions.assertEquals((int)7, (int)entity.getAttributes().size());
        Assertions.assertEquals(Collection.class, (Object)entity.getAttribute("booleans").getType());
        Assertions.assertEquals(Collection.class, (Object)entity.getAttribute("doubles").getType());
        Assertions.assertEquals(Collection.class, (Object)entity.getAttribute("characters").getType());
        Assertions.assertEquals(Collection.class, (Object)entity.getAttribute("wildcardCollection").getType());
        Assertions.assertEquals(Collection.class, (Object)entity.getAttribute("genericCollection").getType());
        Assertions.assertEquals(List.class, (Object)entity.getAttribute("numberList").getType());
        Assertions.assertEquals(Set.class, (Object)entity.getAttribute("stringSet").getType());
        Assertions.assertEquals((int)0, (int)entity.getRelationships().size());
    }

    @Test
    public void testCompile_EntityWithNoAnnotations() {
        AgEntity entity = new AnnotationsAgEntityCompiler(Collections.emptyMap()).compile(EntityNoAnnotations.class, (AgSchema)new LazySchema(compilers));
        Assertions.assertNotNull((Object)entity);
        Assertions.assertTrue((boolean)entity.getAttributes().isEmpty());
    }

    static class EntityNoAnnotations {
        EntityNoAnnotations() {
        }

        public String getX() {
            return "x";
        }

        public int getY() {
            return 6;
        }
    }

    static class Entity {
        Entity() {
        }

        @AgId
        public String getX() {
            return "x";
        }

        @AgAttribute
        public int getY() {
            return 6;
        }
    }
}

