/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.converter.jsonvalue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.agrest.AgException;
import io.agrest.converter.jsonvalue.FloatConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FloatConverterTest {
    @Test
    public void testConverter_Zero() {
        Float value = Float.valueOf(0.0f);
        Assertions.assertEquals((Float)value, (Float)this.convert(value));
    }

    @Test
    public void testConverter_Integer_Zero() {
        Float value = Float.valueOf(0.0f);
        Assertions.assertEquals((Float)value, (Float)this.convert(0));
    }

    @Test
    public void testConverter_MinValue() {
        Float value = Float.valueOf(Float.MIN_VALUE);
        Assertions.assertEquals((Float)value, (Float)this.convert(value));
    }

    @Test
    public void testConverter_NegativeMinValue() {
        Float value = Float.valueOf(-1.4E-45f);
        Assertions.assertEquals((Float)value, (Float)this.convert(value));
    }

    @Test
    public void testConverter_MaxValue() {
        Float value = Float.valueOf(Float.MAX_VALUE);
        Assertions.assertEquals((Float)value, (Float)this.convert(value));
    }

    @Test
    public void testConverter_NegativeMaxValue() {
        Float value = Float.valueOf(-3.4028235E38f);
        Assertions.assertEquals((Float)value, (Float)this.convert(value));
    }

    @Test
    public void testConverter_NaN() {
        Assertions.assertEquals((Float)Float.valueOf(Float.NaN), (Float)this.convert("NaN"));
    }

    @Test
    public void testConverter_PositiveInfinity() {
        Assertions.assertEquals((Float)Float.valueOf(Float.POSITIVE_INFINITY), (Float)this.convert("Infinity"));
        Assertions.assertEquals((Float)Float.valueOf(Float.POSITIVE_INFINITY), (Float)this.convert("+Infinity"));
    }

    @Test
    public void testConverter_NegativeInfinity() {
        Assertions.assertEquals((Float)Float.valueOf(Float.NEGATIVE_INFINITY), (Float)this.convert("-Infinity"));
    }

    @Test
    public void testConverter_TooLarge_Positive() {
        Assertions.assertThrows(AgException.class, () -> FloatConverter.converter().value((JsonNode)new DoubleNode(3.7431058130238175E38)));
    }

    @Test
    public void testConverter_TooSmall_Positive() {
        Assertions.assertThrows(AgException.class, () -> FloatConverter.converter().value((JsonNode)new DoubleNode(1.2611686178923354E-45)));
    }

    @Test
    public void testConverter_TooLarge_Negative() {
        Assertions.assertThrows(AgException.class, () -> FloatConverter.converter().value((JsonNode)new DoubleNode(-3.7431058130238175E38)));
    }

    @Test
    public void testConverter_TooSmall_Negative() {
        Assertions.assertThrows(AgException.class, () -> FloatConverter.converter().value((JsonNode)new DoubleNode(-1.2611686178923354E-45)));
    }

    private Float convert(Float value) {
        return (Float)FloatConverter.converter().value((JsonNode)new FloatNode(value.floatValue()));
    }

    private Float convert(Integer value) {
        return (Float)FloatConverter.converter().value((JsonNode)new IntNode(value.intValue()));
    }

    private Float convert(String value) {
        return (Float)FloatConverter.converter().value((JsonNode)new TextNode(value));
    }
}

