/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.converter.jsonvalue;

import io.agrest.converter.jsonvalue.EnumConverter;
import io.agrest.converter.jsonvalue.JsonValueConverter;
import io.agrest.converter.jsonvalue.JsonValueConverters;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class JsonValueConvertersTest {
    @Test
    public void testConverter() {
        JsonValueConverter c1 = (JsonValueConverter)Mockito.mock(JsonValueConverter.class);
        JsonValueConverter c2 = (JsonValueConverter)Mockito.mock(JsonValueConverter.class);
        JsonValueConverters factory = new JsonValueConverters(Map.of(Long.class, c1), c2);
        Assertions.assertSame((Object)c1, (Object)factory.converter(Long.class));
        Assertions.assertSame((Object)c2, (Object)factory.converter(Long.TYPE));
        Assertions.assertSame((Object)c2, (Object)factory.converter(this.getClass()));
        Assertions.assertSame((Object)c2, (Object)factory.converter(Object.class));
    }

    @Test
    public void testConverter_Enum() {
        JsonValueConverter c1 = (JsonValueConverter)Mockito.mock(JsonValueConverter.class);
        JsonValueConverter c2 = (JsonValueConverter)Mockito.mock(JsonValueConverter.class);
        JsonValueConverters factory = new JsonValueConverters(Collections.emptyMap(), c2);
        Assertions.assertSame((Object)c2, (Object)factory.converter(Object.class));
        JsonValueConverter e1c = factory.converter(E1.class);
        Assertions.assertTrue((boolean)(e1c instanceof EnumConverter));
        Assertions.assertSame(E1.class, (Object)((EnumConverter)e1c).getEnumType());
        JsonValueConverter e2c = factory.converter(E2.class);
        Assertions.assertTrue((boolean)(e2c instanceof EnumConverter));
        Assertions.assertSame(E2.class, (Object)((EnumConverter)e2c).getEnumType());
        Assertions.assertSame((Object)e1c, (Object)factory.converter(E1.class));
    }

    public static enum E2 {
        e21,
        e22;

    }

    public static enum E1 {
        e11,
        e12;

    }
}

