/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.converter.jsonvalue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.agrest.converter.jsonvalue.JsonValueConverter;
import io.agrest.converter.jsonvalue.JsonValueConverters;
import io.agrest.converter.jsonvalue.JsonValueConvertersProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JsonValueConverters_PojoTest {
    JsonValueConverters converterFactory;
    JsonNodeFactory nodeFactory;

    @BeforeEach
    public void before() {
        this.converterFactory = new JsonValueConvertersProvider(Collections.emptyMap()).get();
        this.nodeFactory = JsonNodeFactory.instance;
    }

    private <T> JsonValueConverter<T> compile(Class<T> type) {
        return this.converterFactory.typedConverter(type);
    }

    private JsonNodeFactory nodeFactory() {
        return this.nodeFactory;
    }

    @Test
    public void testCompiler_SimpleProperties() {
        JsonValueConverter<T1> reader = this.compile(T1.class);
        ObjectNode objectNode = this.nodeFactory().objectNode();
        objectNode.set("boolean", (JsonNode)this.nodeFactory().booleanNode(true));
        objectNode.set("integer", (JsonNode)this.nodeFactory().numberNode(1));
        objectNode.set("string", (JsonNode)this.nodeFactory().textNode("abc"));
        T1 t1 = (T1)reader.value((JsonNode)objectNode);
        Assertions.assertEquals((Object)true, (Object)t1.isBoolean());
        Assertions.assertEquals((Integer)1, (Integer)t1.getInteger());
        Assertions.assertEquals((Object)"abc", (Object)t1.getString());
    }

    @Test
    public void testCompiler_CollectionProperties() {
        JsonValueConverter<T2> reader = this.compile(T2.class);
        ObjectNode objectNode = this.nodeFactory().objectNode();
        objectNode.set("booleans", (JsonNode)this.nodeFactory().arrayNode().add(true).add(false));
        objectNode.set("integers", (JsonNode)this.nodeFactory().arrayNode().add(1).add(2).add(3));
        objectNode.set("strings", (JsonNode)this.nodeFactory().arrayNode().add("a").add("b").add("c"));
        T2 t2 = (T2)reader.value((JsonNode)objectNode);
        this.assertSameContent(t2.getBooleans(), true, false);
        this.assertSameContent(t2.getIntegers(), 1, 2, 3);
        this.assertSameContent(t2.getStrings(), "a", "b", "c");
    }

    @Test
    public void testCompiler_RelationshipProperties() {
        JsonValueConverter<T3> reader = this.compile(T3.class);
        ObjectNode t3_objectNode_Hollow = this.nodeFactory().objectNode();
        t3_objectNode_Hollow.set("id", (JsonNode)this.nodeFactory().numberNode(11));
        ObjectNode t4_objectNode1 = this.nodeFactory().objectNode();
        t4_objectNode1.set("id", (JsonNode)this.nodeFactory().numberNode(41));
        t4_objectNode1.set("t3", (JsonNode)t3_objectNode_Hollow);
        ObjectNode t4_objectNode2 = this.nodeFactory().objectNode();
        t4_objectNode2.set("id", (JsonNode)this.nodeFactory().numberNode(42));
        ObjectNode t5_objectNode = this.nodeFactory().objectNode();
        t5_objectNode.set("id", (JsonNode)this.nodeFactory().numberNode(51));
        t5_objectNode.set("t3s", (JsonNode)this.nodeFactory().arrayNode().add((JsonNode)t3_objectNode_Hollow));
        ObjectNode t3_objectNode = this.nodeFactory().objectNode();
        t3_objectNode.set("id", (JsonNode)this.nodeFactory().numberNode(11));
        t3_objectNode.set("t4s", (JsonNode)this.nodeFactory().arrayNode().add((JsonNode)t4_objectNode1).add((JsonNode)t4_objectNode2));
        t3_objectNode.set("t5", (JsonNode)t5_objectNode);
        T3 t3_expected = new T3(11);
        T4 t4_1 = new T4(41);
        t4_1.setT3(new T3(11));
        T4 t4_2 = new T4(42);
        t3_expected.setT4s(Arrays.asList(t4_1, t4_2));
        T5 t5 = new T5(51);
        t5.setT3s(Set.of(new T3(11)));
        t3_expected.setT5(t5);
        T3 t3 = (T3)reader.value((JsonNode)t3_objectNode);
        Assertions.assertEquals((Object)t3_expected, (Object)t3);
    }

    private <T extends Collection<?>> void assertSameContent(T collection, Object ... values) {
        Assertions.assertNotNull(collection);
        Assertions.assertEquals((int)values.length, (int)collection.size());
        for (Object value : values) {
            Assertions.assertTrue((boolean)collection.contains(value), (String)("Value is missing from the collection: '" + value + "'"));
        }
    }

    public static class T5 {
        public static final String P_ID = "id";
        public static final String P_T3S = "t3s";
        private Integer id;
        private Collection<T3> t3s;

        public T5(Integer id) {
            this.id = Objects.requireNonNull(id);
        }

        public T5() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Collection<T3> getT3s() {
            return this.t3s;
        }

        public void setT3s(Collection<T3> t3s) {
            this.t3s = t3s;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            T5 t5 = (T5)object;
            if (!this.id.equals(t5.id)) {
                return false;
            }
            return this.t3s != null ? this.t3s.containsAll(t5.t3s) : t5.t3s == null;
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.t3s != null ? this.t3s.hashCode() : 0);
            return result;
        }
    }

    public static class T4 {
        public static final String P_ID = "id";
        public static final String P_T3 = "t3";
        private Integer id;
        private T3 t3;

        public T4(Integer id) {
            this.id = Objects.requireNonNull(id);
        }

        public T4() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public T3 getT3() {
            return this.t3;
        }

        public void setT3(T3 t3) {
            this.t3 = t3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            T4 t4 = (T4)object;
            if (!this.id.equals(t4.id)) {
                return false;
            }
            return Objects.equals(this.t3, t4.t3);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.t3 != null ? this.t3.hashCode() : 0);
            return result;
        }
    }

    public static class T3 {
        public static final String P_ID = "id";
        public static final String P_T4S = "t4s";
        public static final String P_T5 = "t5";
        private Integer id;
        private Collection<T4> t4s;
        private T5 t5;

        public T3(Integer id) {
            this.id = Objects.requireNonNull(id);
        }

        public T3() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Collection<T4> getT4s() {
            return this.t4s;
        }

        public void setT4s(Collection<T4> t4s) {
            this.t4s = t4s;
        }

        public T5 getT5() {
            return this.t5;
        }

        public void setT5(T5 t5) {
            this.t5 = t5;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            T3 t3 = (T3)object;
            if (!this.id.equals(t3.id)) {
                return false;
            }
            if (this.t4s != null ? !this.t4s.containsAll(t3.t4s) : t3.t4s != null) {
                return false;
            }
            return Objects.equals(this.t5, t3.t5);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.t4s != null ? this.t4s.hashCode() : 0);
            result = 31 * result + (this.t5 != null ? this.t5.hashCode() : 0);
            return result;
        }
    }

    public static class T2 {
        public static final String P_BOOLEANS = "booleans";
        public static final String P_INTEGERS = "integers";
        public static final String P_STRINGS = "strings";
        private Collection<Boolean> booleans;
        private List<Integer> integers;
        private Set<String> strings;

        public Collection<Boolean> getBooleans() {
            return this.booleans;
        }

        public void setBooleans(Collection<Boolean> booleans) {
            this.booleans = booleans;
        }

        public List<Integer> getIntegers() {
            return this.integers;
        }

        public void setIntegers(List<Integer> integers) {
            this.integers = integers;
        }

        public Set<String> getStrings() {
            return this.strings;
        }

        public void setStrings(Set<String> strings) {
            this.strings = strings;
        }
    }

    public static class T1 {
        public static final String P_BOOLEAN = "boolean";
        public static final String P_INTEGER = "integer";
        public static final String P_STRING = "string";
        private Boolean booleanProperty;
        private Integer integerProperty;
        private String stringProperty;

        public Boolean isBoolean() {
            return this.booleanProperty;
        }

        public void setBoolean(Boolean booleanProperty) {
            this.booleanProperty = booleanProperty;
        }

        public Integer getInteger() {
            return this.integerProperty;
        }

        public void setInteger(Integer pInteger) {
            this.integerProperty = pInteger;
        }

        public String getString() {
            return this.stringProperty;
        }

        public void setString(String pString) {
            this.stringProperty = pString;
        }
    }
}

