/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.converter.jsonvalue;

import io.agrest.converter.jsonvalue.Normalizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NormalizerTest {
    @Test
    public void testNormalize_Null() {
        Assertions.assertNull((Object)Normalizer.normalize(null, Integer.class));
        Assertions.assertNull((Object)Normalizer.normalize(null, Long.class));
    }

    @Test
    public void testNormalize_NonNumber() {
        Object x = new Object();
        Assertions.assertSame((Object)x, (Object)Normalizer.normalize((Object)x, Integer.class));
        Assertions.assertSame((Object)x, (Object)Normalizer.normalize((Object)x, Long.class));
    }

    @Test
    public void testNormalize_Long() {
        Long smallLong = new Long(5L);
        Assertions.assertSame((Object)smallLong, (Object)Normalizer.normalize((Object)smallLong, Integer.class));
        Assertions.assertSame((Object)smallLong, (Object)Normalizer.normalize((Object)smallLong, Long.class));
        Long bigLong = new Long(-2147482649L);
        Assertions.assertSame((Object)bigLong, (Object)Normalizer.normalize((Object)bigLong, Integer.class));
        Assertions.assertSame((Object)bigLong, (Object)Normalizer.normalize((Object)bigLong, Long.class));
    }

    @Test
    public void testNormalize_Int() {
        Integer integer = new Integer(5);
        Long smallLong = new Long(5L);
        Assertions.assertSame((Object)integer, (Object)Normalizer.normalize((Object)integer, Integer.class));
        Assertions.assertEquals((Object)smallLong, (Object)Normalizer.normalize((Object)integer, Long.class));
    }
}

