/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.converter.jsonvalue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.agrest.converter.jsonvalue.UtcDateConverter;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DecimalStyle;
import java.time.temporal.ChronoField;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UtcDateConverterTest {
    private static final DateTimeFormatter AGREST_ISO_LOCAL_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).toFormatter().withDecimalStyle(DecimalStyle.STANDARD).withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter AGREST_ISO_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').append(AGREST_ISO_LOCAL_TIME).toFormatter().withDecimalStyle(DecimalStyle.STANDARD).withZone(ZoneId.systemDefault());

    private static String isoFormat(Date date) {
        return AGREST_ISO_LOCAL_DATE_TIME.format(Instant.ofEpochMilli(date.getTime()));
    }

    private static <T extends Date> T convert(Class<T> targetType, String value) {
        return (T)((Date)UtcDateConverter.converter(targetType).value((JsonNode)new TextNode(value)));
    }

    @Test
    public void testConverter_javaUtilDate() {
        Date date = new Date();
        Date parsed = UtcDateConverterTest.convert(Date.class, UtcDateConverterTest.isoFormat(date));
        Assertions.assertEquals((Object)date, (Object)parsed);
    }

    @Test
    public void testConverter_javaSqlDate() {
        Date date = new Date();
        java.sql.Date parsed = UtcDateConverterTest.convert(java.sql.Date.class, UtcDateConverterTest.isoFormat(date));
        Assertions.assertEquals((Object)date, (Object)parsed);
    }

    @Test
    public void testConverter_javaSqlTime() {
        Date date = new Date();
        Time parsed = UtcDateConverterTest.convert(Time.class, UtcDateConverterTest.isoFormat(date));
        Assertions.assertEquals((Object)date, (Object)parsed);
    }

    @Test
    public void testConverter_javaSqlTimestamp() {
        Date date = new Date();
        Timestamp parsed = UtcDateConverterTest.convert(Timestamp.class, UtcDateConverterTest.isoFormat(date));
        Assertions.assertEquals((Object)date, (Object)parsed);
    }
}

