/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.converter.valuestring;

import io.agrest.converter.valuestring.ISODateTimeConverter;
import io.agrest.converter.valuestring.ValueStringConverter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ISODateTimeConverterTest {
    private ValueStringConverter converter = ISODateTimeConverter.converter();

    @Test
    public void testISODateTimeConverter() {
        this._testISODateTimeConverter(1458995247000L, "yyyy-MM-dd'T'HH:mm:ss");
    }

    @Test
    public void testISODateTimeConverter_FractionalPart1() {
        this._testISODateTimeConverter(1458995247001L, "yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    @Test
    public void testISODateTimeConverter_FractionalPart2() {
        this._testISODateTimeConverter(1458995247100L, "yyyy-MM-dd'T'HH:mm:ss.S");
    }

    private void _testISODateTimeConverter(long millis, String expectedPattern) {
        String expected = DateTimeFormatter.ofPattern(expectedPattern).format(ISODateTimeConverterTest.fromMillis(millis));
        Assertions.assertEquals((Object)expected, (Object)this.converter.asString((Object)new Date(millis)));
    }

    private static LocalDateTime fromMillis(long millis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
    }
}

